/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.assertj.core.util.Lists;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.hierarchy.ComponentHierarchy;

public final class SingleComponentHierarchy
implements ComponentHierarchy {
    private final Container root;
    private final List<Container> list = Lists.newArrayList();
    private final ComponentHierarchy hierarchy;

    public SingleComponentHierarchy(@Nonnull Container root, @Nonnull ComponentHierarchy hierarchy) {
        this.root = root;
        this.hierarchy = hierarchy;
        this.list.add(root);
    }

    public Container root() {
        return this.root;
    }

    @Override
    @Nullable
    public Container parentOf(@Nonnull Component c) {
        return this.hierarchy.parentOf(c);
    }

    @Override
    @Nonnull
    public Collection<Container> roots() {
        return this.list;
    }

    @Override
    @Nonnull
    public Collection<Component> childrenOf(@Nonnull Component c) {
        return this.hierarchy.childrenOf(c);
    }

    @Override
    public boolean contains(@Nonnull Component c) {
        return this.hierarchy.contains(c) && SwingUtilities.isDescendingFrom(c, this.root);
    }

    @Override
    public void dispose(@Nonnull Window w) {
        this.hierarchy.dispose(w);
    }
}

