/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/ScrollSnapToFocused;", "Lcom/intellij/ui/components/JBScrollPane;", "component", "Ljavax/swing/JComponent;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "scrollViewPortIfNeeded", "", "focused", "intellij.ide.startup.importSettings"})
public final class ScrollSnapToFocused
extends JBScrollPane {
    @NotNull
    private final JComponent component;

    public ScrollSnapToFocused(@NotNull JComponent component, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        super((Component)component);
        this.component = component;
        this.horizontalScrollBarPolicy = 31;
        this.setBorder((Border)JBUI.Borders.empty());
        this.setMinimumSize(new Dimension(0, 0));
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        PropertyChangeListener listener = arg_0 -> ScrollSnapToFocused._init_$lambda$0(focusManager, this, arg_0);
        focusManager.addPropertyChangeListener("focusOwner", listener);
        Disposer.register((Disposable)disposable, () -> ScrollSnapToFocused._init_$lambda$1(focusManager, listener));
    }

    private final void scrollViewPortIfNeeded(JComponent focused) {
        if (this.component.isAncestorOf(focused)) {
            boolean outOfViewport;
            Point viewPortLocationOnScreen = this.viewport.getLocationOnScreen();
            Point focusedBounds = focused.getLocationOnScreen();
            int viewportWidth = this.viewport.getWidth();
            int viewportHeight = this.viewport.getHeight();
            boolean bl = outOfViewport = focusedBounds.y < viewPortLocationOnScreen.y || focusedBounds.y + focused.getHeight() > viewPortLocationOnScreen.y + viewportHeight;
            if (outOfViewport) {
                focusedBounds.translate(-viewPortLocationOnScreen.x, -viewPortLocationOnScreen.y);
                focused.scrollRectToVisible(new Rectangle(0, 0, viewportWidth, viewportHeight));
            }
        }
    }

    private static final void _init_$lambda$0(KeyboardFocusManager $focusManager, ScrollSnapToFocused this$0, PropertyChangeEvent e) {
        Component focussed;
        if (e.getNewValue() != null && (focussed = $focusManager.getFocusOwner()) != null && focussed instanceof JComponent && SwingUtilities.isDescendingFrom(focussed, this$0.component)) {
            this$0.scrollViewPortIfNeeded((JComponent)focussed);
        }
    }

    private static final void _init_$lambda$1(KeyboardFocusManager $focusManager, PropertyChangeListener $listener) {
        $focusManager.removePropertyChangeListener($listener);
    }
}

