'use client';
import { jsx } from 'react/jsx-runtime';
import 'dayjs';
import { shiftTimezone } from '../../utils/shift-timezone.mjs';
import '../DatesProvider/DatesProvider.mjs';
import { useDatesContext } from '../DatesProvider/use-dates-context.mjs';

function formatValue(value, type) {
  const ctx = useDatesContext();
  const formatDateWithTimezone = (date) => {
    return shiftTimezone("remove", date, ctx.getTimezone()).toISOString();
  };
  if (type === "range" && Array.isArray(value)) {
    const [startDate, endDate] = value;
    if (!startDate) {
      return "";
    }
    if (!endDate) {
      return `${formatDateWithTimezone(startDate)} \u2013`;
    }
    return `${formatDateWithTimezone(startDate)} \u2013 ${formatDateWithTimezone(endDate)}`;
  }
  if (type === "multiple" && Array.isArray(value)) {
    return value.map((date) => date && formatDateWithTimezone(date)).filter(Boolean).join(", ");
  }
  if (!Array.isArray(value) && value) {
    return formatDateWithTimezone(value);
  }
  return "";
}
function HiddenDatesInput({ value, type, name, form }) {
  return /* @__PURE__ */ jsx("input", { type: "hidden", value: formatValue(value, type), name, form });
}
HiddenDatesInput.displayName = "@mantine/dates/HiddenDatesInput";

export { HiddenDatesInput };
//# sourceMappingURL=HiddenDatesInput.mjs.map
