
# GNUPLOT file to plot verification examples (Figs 1 & 2) of Ehlers and Eippers (1999)

#To see color names:
# >> show palette colornames

#To see line style, line width, etc.:
# >> set terminal wxt enhanced dashed
# >> test
clear
reset
set datafile separator ","
set encoding utf8

# -------------------------------------------------------------------------------
# DATA EXTRACTED WITH ENGAUGE FROM EHLERS & EIPPERS PAPER COPIED HERE
# -------------------------------------------------------------------------------
$dataEhlers1 << EOD
#x,step load,load increase,theor bound
0.0,0.0,0.0,-0.33
0.0114476,-0.023822,-0.023822,-0.33
0.0332767,-0.0366492,-0.0393381,-0.33
0.0333608,-0.0366742,-0.0393979,-0.33
0.0765419,-0.0494764,-0.0549133,-0.33
0.0767103,-0.049521,-0.0549738,-0.33
0.119765,-0.0609293,-0.0670155,-0.33
0.130764,-0.0632646,-0.0700916,-0.33
0.162918,-0.0700916,-0.0813088,-0.33
0.174099,-0.0717567,-0.0852094,-0.33
0.205987,-0.0765052,-0.0941279,-0.33
0.228153,-0.0799625,-0.100327,-0.33
0.238296,-0.0815445,-0.103164,-0.33
0.270576,-0.0856675,-0.112192,-0.33
0.282206,-0.0873173,-0.115445,-0.33
0.302871,-0.0902487,-0.121051,-0.33
0.336246,-0.095925,-0.130105,-0.33
0.356742,-0.099411,-0.136826,-0.33
0.379553,-0.102325,-0.144306,-0.33
0.389023,-0.103534,-0.146516,-0.33
0.432035,-0.108115,-0.156556,-0.33
0.444325,-0.109685,-0.159424,-0.33
0.464316,-0.112238,-0.16409,-0.33
0.496597,-0.116361,-0.171624,-0.33
0.509096,-0.117693,-0.174542,-0.33
0.539609,-0.120942,-0.183076,-0.33
0.561172,-0.125065,-0.189106,-0.33
0.56315,-0.125255,-0.18966,-0.33
0.604171,-0.129188,-0.200788,-0.33
0.617189,-0.130575,-0.204319,-0.33
0.647183,-0.13377,-0.211109,-0.33
0.668704,-0.136518,-0.215981,-0.33
0.681947,-0.137788,-0.218979,-0.33
0.711702,-0.140641,-0.225924,-0.33
0.746719,-0.143999,-0.234097,-0.33
0.754701,-0.144764,-0.235848,-0.33
0.808404,-0.148429,-0.247628,-0.33
0.811462,-0.148709,-0.248298,-0.33
0.883641,-0.155301,-0.262318,-0.33
0.886938,-0.155554,-0.262958,-0.33
0.937358,-0.159424,-0.269612,-0.33
0.980357,-0.163547,-0.275286,-0.33
0.994554,-0.164355,-0.27716,-0.33
1.03757,-0.166802,-0.281741,-0.33
1.04478,-0.167212,-0.282068,-0.33
1.09848,-0.170877,-0.284503,-0.33
1.1629,-0.174542,-0.287425,-0.33
1.2093,-0.177181,-0.289529,-0.33
1.22732,-0.178207,-0.290189,-0.33
1.28441,-0.181454,-0.292277,-0.33
1.29174,-0.181872,-0.292427,-0.33
1.36687,-0.185079,-0.293955,-0.33
1.44201,-0.188743,-0.295483,-0.33
1.50963,-0.191218,-0.296859,-0.33
1.51712,-0.191492,-0.296965,-0.33
1.60296,-0.194699,-0.298188,-0.33
1.68878,-0.19699,-0.29941,-0.33
1.77459,-0.19928,-0.300632,-0.33
1.86348,-0.200968,-0.301898,-0.33
1.87111,-0.201113,-0.301979,-0.33
1.96763,-0.202945,-0.30301,-0.33
2.07485,-0.204319,-0.304156,-0.33
2.17136,-0.205694,-0.305187,-0.33
2.20657,-0.206028,-0.305563,-0.33
2.26785,-0.20661,-0.30607,-0.33
2.37504,-0.207068,-0.306956,-0.33
2.47154,-0.207984,-0.307754,-0.33
2.53892,-0.208272,-0.308312,-0.33
2.57873,-0.208442,-0.308612,-0.33
2.68593,-0.208901,-0.30942,-0.33
2.79312,-0.209359,-0.310228,-0.33
2.88958,-0.209359,-0.310956,-0.33
2.90342,-0.209359,-0.31106,-0.33
2.99676,-0.209359,-0.311544,-0.33
3.10396,-0.209817,-0.312099,-0.33
3.21116,-0.210275,-0.312654,-0.33
3.25717,-0.210275,-0.312893,-0.33
3.31834,-0.210275,-0.313138,-0.33
3.42552,-0.210275,-0.313567,-0.33
3.5327,-0.210275,-0.313997,-0.33
3.60019,-0.210275,-0.314267,-0.33
3.63988,-0.210275,-0.314417,-0.33
3.74706,-0.210275,-0.314821,-0.33
3.85424,-0.210275,-0.315225,-0.33
3.96142,-0.210275,-0.315629,-0.33
3.96465,-0.210275,-0.315641,-0.33
4.0686,-0.210275,-0.315911,-0.33
4.17579,-0.210275,-0.316188,-0.33
4.28297,-0.210275,-0.316466,-0.33
4.31838,-0.210275,-0.316558,-0.33
4.39015,-0.210275,-0.316738,-0.33
4.49733,-0.210275,-0.317007,-0.33
4.60451,-0.210275,-0.317277,-0.33
4.68282,-0.210275,-0.317474,-0.33
4.71169,-0.210275,-0.317586,-0.33
4.81887,-0.210275,-0.318002,-0.33
4.92605,-0.210275,-0.318419,-0.33
5.03323,-0.210275,-0.318835,-0.33
5.03656,-0.210275,-0.318848,-0.33
5.14042,-0.210275,-0.318983,-0.33
5.2476,-0.210275,-0.319121,-0.33
5.35478,-0.210275,-0.31926,-0.33
5.39027,-0.210275,-0.319306,-0.33
5.46196,-0.210275,-0.319396,-0.33
5.56914,-0.210275,-0.319531,-0.33
5.67632,-0.210275,-0.319666,-0.33
5.7547,-0.210275,-0.319764,-0.33
5.7835,-0.210275,-0.319803,-0.33
5.89068,-0.210275,-0.319946,-0.33
5.99786,-0.210275,-0.320089,-0.33
6.09769,-0.210275,-0.320223,-0.33
6.10505,-0.210275,-0.320232,-0.33
6.21223,-0.210275,-0.320366,-0.33
6.31941,-0.210275,-0.320501,-0.33
6.42659,-0.210275,-0.320636,-0.33
6.46212,-0.210275,-0.320681,-0.33
6.53377,-0.210275,-0.320866,-0.33
6.64095,-0.210275,-0.321144,-0.33
6.74813,-0.210275,-0.321421,-0.33
6.81585,-0.210275,-0.321597,-0.33
6.85531,-0.210275,-0.321648,-0.33
6.9625,-0.210275,-0.321787,-0.33
7.06968,-0.210275,-0.321926,-0.33
7.16956,-0.210275,-0.322055,-0.33
7.17686,-0.210275,-0.322055,-0.33
7.28404,-0.210275,-0.322055,-0.33
7.39122,-0.210275,-0.322055,-0.33
7.4984,-0.210275,-0.322055,-0.33
7.52326,-0.210275,-0.322055,-0.33
7.60558,-0.210275,-0.322158,-0.33
7.71276,-0.210275,-0.322293,-0.33
7.81994,-0.210275,-0.322428,-0.33
7.88769,-0.210275,-0.322513,-0.33
7.92713,-0.210275,-0.322563,-0.33
8.03431,-0.210275,-0.322697,-0.33
8.14149,-0.210275,-0.322832,-0.33
8.24867,-0.210275,-0.322967,-0.33
8.25212,-0.210275,-0.322971,-0.33
8.35585,-0.210275,-0.323106,-0.33
8.46303,-0.210275,-0.323244,-0.33
8.57021,-0.210275,-0.323383,-0.33
8.60583,-0.210275,-0.323429,-0.33
8.67739,-0.210275,-0.323429,-0.33
8.78457,-0.210275,-0.323429,-0.33
8.89176,-0.210275,-0.323429,-0.33
8.95953,-0.210275,-0.323429,-0.33
8.99894,-0.210275,-0.32348,-0.33
9.10612,-0.210275,-0.323619,-0.33
9.2133,-0.210275,-0.323758,-0.33
9.31324,-0.210275,-0.323887,-0.33
9.32048,-0.210275,-0.323887,-0.33
9.42766,-0.210275,-0.323887,-0.33
9.53484,-0.210275,-0.323887,-0.33
9.64202,-0.210275,-0.323887,-0.33
9.67766,-0.210275,-0.323887,-0.33
9.7492,-0.210275,-0.323986,-0.33
9.85639,-0.210275,-0.324134,-0.33
9.96357,-0.210275,-0.324282,-0.33
10.0099,-0.210275,-0.324346,-0.33
EOD

$dataEhlers2 << EOD
#x,kappa_0,kappa_1,kappa_2,kappa_5
0	,	0	,	0	,	0	,	0
0.0104603	,	-0.00766284	,	-0.00063857	,	-0.00510856	,	-0.008066
0.0313808	,	-0.0223499	,	-0.00766284	,	-0.0146871	,	-0.01062069
0.041841	,	-0.0269796	,	-0.011175	,	-0.0194764	,	-0.01541
0.0523013	,	-0.0316092	,	-0.0136494	,	-0.0221371	,	-0.0167935
0.0732218	,	-0.0427842	,	-0.0185983	,	-0.0274585	,	-0.0195607
0.083682	,	-0.0456577	,	-0.0210728	,	-0.0322478	,	-0.0203908
0.104603	,	-0.0514049	,	-0.0280971	,	-0.0343231	,	-0.0220511
0.115063	,	-0.0541188	,	-0.0316092	,	-0.0353608	,	-0.0228812
0.125523	,	-0.0568327	,	-0.0363186	,	-0.0363985	,	-0.0237114
0.146444	,	-0.0600255	,	-0.0457375	,	-0.0402299	,	-0.0254674
0.156904	,	-0.0632184	,	-0.050447	,	-0.0415868	,	-0.0263455
0.167364	,	-0.0673691	,	-0.0434227	,	-0.0429438	,	-0.0272235
0.177824	,	-0.0687527	,	-0.0539591	,	-0.0443008	,	-0.0280536
0.188285	,	-0.0701362	,	-0.0556354	,	-0.0456577	,	-0.0288838
0.198745	,	-0.0715198	,	-0.0573116	,	-0.0474138	,	-0.0297139
0.209205	,	-0.0747126	,	-0.0589879	,	-0.0491699	,	-0.0305441
0.219665	,	-0.0761494	,	-0.0606641	,	-0.0498883	,	-0.0313742
0.230126	,	-0.0775862	,	-0.0619413	,	-0.0506066	,	-0.031917
0.251046	,	-0.0807791	,	-0.0644955	,	-0.0520434	,	-0.0330026
0.261506	,	-0.0839719	,	-0.066092	,	-0.0530013	,	-0.0335453
0.282427	,	-0.0865262	,	-0.0692848	,	-0.054917	,	-0.0346309
0.292887	,	-0.0878033	,	-0.0708812	,	-0.0559547	,	-0.0351737
0.303347	,	-0.0909962	,	-0.0723712	,	-0.0569923	,	-0.0357165
0.324268	,	-0.0929119	,	-0.0753512	,	-0.0590677	,	-0.036802
0.334728	,	-0.0938697	,	-0.0762559	,	-0.0603448	,	-0.0373129
0.345188	,	-0.0954662	,	-0.0771605	,	-0.061622	,	-0.0378238
0.355649	,	-0.0970626	,	-0.0780651	,	-0.0627927	,	-0.0383346
0.376569	,	-0.100255	,	-0.0798744	,	-0.0651341	,	-0.0393563
0.387029	,	-0.101852	,	-0.0807791	,	-0.0657727	,	-0.0399239
0.39749	,	-0.103448	,	-0.0818966	,	-0.0664112	,	-0.0404916
0.41841	,	-0.106322	,	-0.0841315	,	-0.0676884	,	-0.0416268
0.42887	,	-0.107918	,	-0.085249	,	-0.0684068	,	-0.0421944
0.439331	,	-0.109515	,	-0.0863133	,	-0.0691252	,	-0.042762
0.460251	,	-0.11143	,	-0.0884419	,	-0.0705619	,	-0.0438973
0.470711	,	-0.112388	,	-0.0895062	,	-0.0719455	,	-0.0444649
0.491632	,	-0.115581	,	-0.0916347	,	-0.0747126	,	-0.0453163
0.523013	,	-0.118774	,	-0.0945083	,	-0.0763889	,	-0.0465934
0.533473	,	-0.119732	,	-0.0954662	,	-0.0769476	,	-0.0470192
0.554393	,	-0.121648	,	-0.0975947	,	-0.0785441	,	-0.047977
0.575314	,	-0.12484	,	-0.0997233	,	-0.0801405	,	-0.0489349
0.596234	,	-0.127182	,	-0.101852	,	-0.0814176	,	-0.0498927
0.606695	,	-0.128352	,	-0.102682	,	-0.0820562	,	-0.050212
0.617155	,	-0.12947	,	-0.103512	,	-0.0826948	,	-0.0505313
0.648536	,	-0.132822	,	-0.106003	,	-0.0842273	,	-0.0514891
0.658996	,	-0.13394	,	-0.106778	,	-0.0847382	,	-0.0518084
0.669456	,	-0.135057	,	-0.107553	,	-0.085249	,	-0.0523193
0.690377	,	-0.137292	,	-0.109104	,	-0.0873244	,	-0.053341
0.711297	,	-0.139421	,	-0.110655	,	-0.0893997	,	-0.0543627
0.721757	,	-0.140485	,	-0.11143	,	-0.0900383	,	-0.0547529
0.753138	,	-0.142401	,	-0.113825	,	-0.091954	,	-0.0559237
0.763598	,	-0.14304	,	-0.114623	,	-0.0925926	,	-0.0563139
0.784519	,	-0.145168	,	-0.11622	,	-0.0938697	,	-0.0570944
0.794979	,	-0.146232	,	-0.116858	,	-0.0945083	,	-0.0574846
0.805439	,	-0.147669	,	-0.117497	,	-0.0951469	,	-0.0578748
0.8159	,	-0.149106	,	-0.118135	,	-0.0955726	,	-0.0582296
0.857741	,	-0.15198	,	-0.12069	,	-0.0972754	,	-0.0596486
0.868201	,	-0.152778	,	-0.121328	,	-0.0977011	,	-0.0600034
0.899582	,	-0.155172	,	-0.123819	,	-0.0998563	,	-0.0610677
0.910042	,	-0.15613	,	-0.124649	,	-0.100575	,	-0.061387
0.920502	,	-0.157088	,	-0.125479	,	-0.101277	,	-0.0617063
0.930962	,	-0.158046	,	-0.126153	,	-0.10198	,	-0.0620255
0.962343	,	-0.160201	,	-0.128175	,	-0.104087	,	-0.0629834
0.972803	,	-0.16092	,	-0.128849	,	-0.104534	,	-0.063183
1.00418	,	-0.164112	,	-0.130871	,	-0.105875	,	-0.0637816
1.01464	,	-0.164687	,	-0.131545	,	-0.106322	,	-0.0639812
1.04603	,	-0.166411	,	-0.133653	,	-0.107759	,	-0.0645798
1.05649	,	-0.166986	,	-0.134355	,	-0.108238	,	-0.0652184
1.06695	,	-0.167704	,	-0.135057	,	-0.108716	,	-0.065857
1.07741	,	-0.168423	,	-0.1356	,	-0.109195	,	-0.0661762
1.09833	,	-0.16986	,	-0.136686	,	-0.110217	,	-0.0668148
1.12971	,	-0.172015	,	-0.138314	,	-0.11175	,	-0.0677727
1.14017	,	-0.172733	,	-0.138857	,	-0.112324	,	-0.0680565
1.17155	,	-0.174457	,	-0.140485	,	-0.114049	,	-0.0689079
1.18201	,	-0.175032	,	-0.141078	,	-0.114623	,	-0.0691917
1.19247	,	-0.175607	,	-0.141671	,	-0.115182	,	-0.0694755
1.22385	,	-0.177762	,	-0.14345	,	-0.116858	,	-0.0703269
1.23431	,	-0.17848	,	-0.144043	,	-0.117417	,	-0.0706143
1.24477	,	-0.178991	,	-0.144636	,	-0.117976	,	-0.0709017
1.26569	,	-0.180013	,	-0.145849	,	-0.119093	,	-0.0714764
1.28661	,	-0.181034	,	-0.147063	,	-0.120016	,	-0.0720511
1.32845	,	-0.18295	,	-0.149489	,	-0.12186	,	-0.0732005
1.34937	,	-0.183908	,	-0.150702	,	-0.122783	,	-0.0736566
1.35983	,	-0.184355	,	-0.151181	,	-0.123244	,	-0.0738847
1.40167	,	-0.186143	,	-0.153097	,	-0.124521	,	-0.0747969
1.41213	,	-0.186622	,	-0.153576	,	-0.12484	,	-0.0750706
1.43305	,	-0.18758	,	-0.154563	,	-0.125479	,	-0.075618
1.46444	,	-0.189017	,	-0.156043	,	-0.126756	,	-0.076439
1.4749	,	-0.189389	,	-0.156537	,	-0.127182	,	-0.0767126
1.49582	,	-0.190134	,	-0.157524	,	-0.128033	,	-0.07726
1.5272	,	-0.191252	,	-0.159004	,	-0.129523	,	-0.078081
1.54812	,	-0.191981	,	-0.159962	,	-0.130517	,	-0.0786284
1.58996	,	-0.193441	,	-0.161877	,	-0.132503	,	-0.079723
1.60042	,	-0.193806	,	-0.162356	,	-0.132886	,	-0.0799967
1.61088	,	-0.19408	,	-0.162835	,	-0.133269	,	-0.0802704
1.62134	,	-0.194353	,	-0.163204	,	-0.133653	,	-0.0805441
1.67364	,	-0.195722	,	-0.165046	,	-0.135568	,	-0.0819124
1.69456	,	-0.196269	,	-0.165782	,	-0.136335	,	-0.0824598
1.74686	,	-0.197637	,	-0.167625	,	-0.137931	,	-0.0840562
1.76778	,	-0.198185	,	-0.168405	,	-0.13857	,	-0.0843755
1.82008	,	-0.199553	,	-0.170356	,	-0.140166	,	-0.0851737
1.83054	,	-0.199753	,	-0.170746	,	-0.140485	,	-0.0853333
1.841	,	-0.199952	,	-0.171137	,	-0.140805	,	-0.085493
1.90377	,	-0.201149	,	-0.173326	,	-0.143069	,	-0.0864508
1.91423	,	-0.201327	,	-0.173691	,	-0.143446	,	-0.0866105
1.95607	,	-0.202036	,	-0.175151	,	-0.144955	,	-0.0877052
1.98745	,	-0.202568	,	-0.176245	,	-0.146009	,	-0.0885262
1.99791	,	-0.202746	,	-0.176564	,	-0.14636	,	-0.0887542
2.06067	,	-0.203597	,	-0.17848	,	-0.148467	,	-0.0901226
2.08159	,	-0.203881	,	-0.179119	,	-0.148946	,	-0.0905217
2.09205	,	-0.204023	,	-0.179395	,	-0.149186	,	-0.0907213
2.14435	,	-0.204555	,	-0.180779	,	-0.150383	,	-0.091719
2.18619	,	-0.204981	,	-0.181886	,	-0.15166	,	-0.0925705
2.20711	,	-0.205194	,	-0.182439	,	-0.152299	,	-0.0929962
2.21757	,	-0.2053	,	-0.182716	,	-0.152618	,	-0.0932356
2.23849	,	-0.205513	,	-0.183269	,	-0.153328	,	-0.0937146
2.28033	,	-0.205939	,	-0.184334	,	-0.154747	,	-0.0946724
2.29079	,	-0.206003	,	-0.1846	,	-0.155101	,	-0.0949119
2.31172	,	-0.20613	,	-0.185132	,	-0.155811	,	-0.0951513
2.36402	,	-0.20645	,	-0.186462	,	-0.156951	,	-0.09575
2.37448	,	-0.206513	,	-0.186682	,	-0.157179	,	-0.0958697
2.38494	,	-0.206577	,	-0.186901	,	-0.157407	,	-0.0960978
2.4477	,	-0.207003	,	-0.188218	,	-0.159049	,	-0.0974662
2.45816	,	-0.207074	,	-0.188438	,	-0.159323	,	-0.0976657
2.47908	,	-0.207216	,	-0.188877	,	-0.159802	,	-0.0980648
2.53138	,	-0.207535	,	-0.189974	,	-0.160999	,	-0.0990626
2.54184	,	-0.207599	,	-0.190166	,	-0.161239	,	-0.0992621
2.58368	,	-0.207854	,	-0.190932	,	-0.162197	,	-0.1000603
2.61506	,	-0.207961	,	-0.191507	,	-0.162915	,	-0.100659
2.62552	,	-0.207996	,	-0.191699	,	-0.163155	,	-0.1007787
2.63598	,	-0.208032	,	-0.19189	,	-0.163442	,	-0.1008985
2.67782	,	-0.208174	,	-0.192562	,	-0.164591	,	-0.1013774
2.69874	,	-0.208245	,	-0.192898	,	-0.165166	,	-0.1016169
2.73013	,	-0.208351	,	-0.193403	,	-0.166028	,	-0.102301
2.77197	,	-0.208493	,	-0.194075	,	-0.166596	,	-0.103213
2.82427	,	-0.208653	,	-0.194915	,	-0.167305	,	-0.104011
2.83473	,	-0.208685	,	-0.195083	,	-0.167625	,	-0.104171
2.85565	,	-0.208748	,	-0.195427	,	-0.168263	,	-0.10449
2.87657	,	-0.208812	,	-0.195771	,	-0.168902	,	-0.104874
2.89749	,	-0.208812	,	-0.196115	,	-0.16954	,	-0.105257
2.90795	,	-0.208812	,	-0.196286	,	-0.1697	,	-0.105448
2.97071	,	-0.208812	,	-0.197318	,	-0.170658	,	-0.106167
2.98117	,	-0.208812	,	-0.197436	,	-0.170817	,	-0.106286
2.99163	,	-0.208844	,	-0.197553	,	-0.17103	,	-0.106406
3.07531	,	-0.2091	,	-0.198494	,	-0.172733	,	-0.107758
3.08577	,	-0.209132	,	-0.198612	,	-0.172903	,	-0.107927
3.16946	,	-0.209132	,	-0.199553	,	-0.174266	,	-0.10928
3.19038	,	-0.209132	,	-0.199727	,	-0.174606	,	-0.109564
3.23222	,	-0.209259	,	-0.200075	,	-0.175287	,	-0.110131
3.2636	,	-0.209355	,	-0.200337	,	-0.175803	,	-0.110557
3.28452	,	-0.209419	,	-0.200511	,	-0.176147	,	-0.110912
3.29498	,	-0.209451	,	-0.200602	,	-0.176319	,	-0.111089
3.35774	,	-0.209451	,	-0.201149	,	-0.17735	,	-0.112153
3.3682	,	-0.209451	,	-0.201241	,	-0.177522	,	-0.112295
3.38912	,	-0.209451	,	-0.201423	,	-0.177877	,	-0.112579
3.45188	,	-0.209451	,	-0.20197	,	-0.178941	,	-0.11343
3.46234	,	-0.209451	,	-0.202062	,	-0.179119	,	-0.113537
3.49372	,	-0.209451	,	-0.202335	,	-0.179544	,	-0.113856
3.50418	,	-0.209451	,	-0.202427	,	-0.179686	,	-0.113963
3.54603	,	-0.209451	,	-0.2027	,	-0.180254	,	-0.114388
3.55649	,	-0.209451	,	-0.202769	,	-0.180396	,	-0.114548
3.59833	,	-0.209451	,	-0.203042	,	-0.181034	,	-0.115186
3.62971	,	-0.209451	,	-0.203248	,	-0.181513	,	-0.115665
3.65063	,	-0.209451	,	-0.203384	,	-0.181833	,	-0.115956
3.70293	,	-0.209451	,	-0.203704	,	-0.182631	,	-0.116681
3.72385	,	-0.209451	,	-0.203831	,	-0.18295	,	-0.116972
3.74477	,	-0.209451	,	-0.203959	,	-0.183224	,	-0.117262
3.80753	,	-0.209451	,	-0.204342	,	-0.184045	,	-0.1179
3.83891	,	-0.209451	,	-0.204534	,	-0.184455	,	-0.11822
3.85983	,	-0.209451	,	-0.204662	,	-0.184729	,	-0.118539
3.87029	,	-0.209451	,	-0.204715	,	-0.184866	,	-0.118699
3.88075	,	-0.209451	,	-0.204768	,	-0.185008	,	-0.118858
3.91213	,	-0.209451	,	-0.204928	,	-0.185434	,	-0.119217
3.96444	,	-0.209451	,	-0.205194	,	-0.186143	,	-0.119816
3.98536	,	-0.209451	,	-0.2053	,	-0.186271	,	-0.120056
4.01674	,	-0.209451	,	-0.205431	,	-0.186462	,	-0.120415
4.04812	,	-0.209642	,	-0.205561	,	-0.186654	,	-0.120774
4.06904	,	-0.20977	,	-0.205648	,	-0.186782	,	-0.121093
4.12134	,	-0.210089	,	-0.205866	,	-0.187527	,	-0.121891
4.1318	,	-0.210089	,	-0.20591	,	-0.187676	,	-0.122051
4.21548	,	-0.210089	,	-0.206258	,	-0.188868	,	-0.122903
4.22594	,	-0.210089	,	-0.206316	,	-0.189017	,	-0.123009
4.32008	,	-0.210089	,	-0.206838	,	-0.189974	,	-0.124286
4.33054	,	-0.210089	,	-0.206897	,	-0.190081	,	-0.124406
4.38285	,	-0.210089	,	-0.207042	,	-0.190613	,	-0.125004
4.40377	,	-0.210089	,	-0.2071	,	-0.190741	,	-0.125244
4.43515	,	-0.210089	,	-0.207187	,	-0.190932	,	-0.125531
4.48745	,	-0.210089	,	-0.207332	,	-0.191252	,	-0.12601
4.50837	,	-0.210089	,	-0.20739	,	-0.191464	,	-0.126202
4.53975	,	-0.210089	,	-0.207477	,	-0.191784	,	-0.126521
4.56067	,	-0.210089	,	-0.207535	,	-0.191997	,	-0.126734
4.58159	,	-0.210089	,	-0.207588	,	-0.192209	,	-0.126947
4.63389	,	-0.210089	,	-0.207721	,	-0.192701	,	-0.127479
4.64435	,	-0.210089	,	-0.207748	,	-0.192799	,	-0.127639
4.67573	,	-0.210089	,	-0.207828	,	-0.193094	,	-0.128117
4.68619	,	-0.210089	,	-0.207854	,	-0.193192	,	-0.128224
4.71757	,	-0.210089	,	-0.207896	,	-0.193487	,	-0.128543
4.74895	,	-0.210089	,	-0.207938	,	-0.193712	,	-0.128862
4.76987	,	-0.210089	,	-0.207965	,	-0.193862	,	-0.129075
4.85356	,	-0.210089	,	-0.208077	,	-0.194463	,	-0.130097
4.87448	,	-0.210089	,	-0.208104	,	-0.194613	,	-0.130352
4.8954	,	-0.210089	,	-0.208132	,	-0.194764	,	-0.130416
4.92678	,	-0.210089	,	-0.208174	,	-0.194977	,	-0.130512
4.95816	,	-0.210089	,	-0.208254	,	-0.195189	,	-0.130608
4.97908	,	-0.210089	,	-0.208307	,	-0.195331	,	-0.130672
4.98954	,	-0.210089	,	-0.208333	,	-0.195402	,	-0.130814
5.0523	,	-0.210089	,	-0.208493	,	-0.195785	,	-0.131665
5.07322	,	-0.210089	,	-0.208551	,	-0.195913	,	-0.131949
5.09414	,	-0.210089	,	-0.208609	,	-0.196041	,	-0.132162
5.12552	,	-0.210089	,	-0.208696	,	-0.196315	,	-0.132481
5.16736	,	-0.210089	,	-0.208812	,	-0.196679	,	-0.132907
5.23013	,	-0.210089	,	-0.208986	,	-0.197227	,	-0.133332
5.24059	,	-0.210089	,	-0.209015	,	-0.197318	,	-0.133403
5.26151	,	-0.210089	,	-0.209073	,	-0.19746	,	-0.133545
5.28243	,	-0.210089	,	-0.209132	,	-0.197602	,	-0.133737
5.32427	,	-0.210089	,	-0.209132	,	-0.197886	,	-0.13412
5.33473	,	-0.210089	,	-0.209132	,	-0.197957	,	-0.134216
5.36611	,	-0.210089	,	-0.209132	,	-0.198063	,	-0.134503
5.40795	,	-0.210089	,	-0.209132	,	-0.198205	,	-0.134982
5.42887	,	-0.210089	,	-0.209158	,	-0.198276	,	-0.135222
5.44979	,	-0.210089	,	-0.209185	,	-0.198404	,	-0.135461
5.51255	,	-0.210089	,	-0.209265	,	-0.198787	,	-0.13594
5.53347	,	-0.210089	,	-0.209291	,	-0.198914	,	-0.1361
5.61715	,	-0.210089	,	-0.209398	,	-0.199482	,	-0.136667
5.62762	,	-0.210089	,	-0.209411	,	-0.199553	,	-0.136738
5.659	,	-0.210089	,	-0.209451	,	-0.199713	,	-0.137057
5.7113	,	-0.210089	,	-0.209584	,	-0.199979	,	-0.13759
5.72176	,	-0.210089	,	-0.20961	,	-0.200032	,	-0.137696
5.78452	,	-0.210089	,	-0.20977	,	-0.200351	,	-0.138175
5.80544	,	-0.210089	,	-0.20977	,	-0.200458	,	-0.138335
5.8159	,	-0.210089	,	-0.20977	,	-0.200511	,	-0.138441
5.89958	,	-0.210089	,	-0.20977	,	-0.200851	,	-0.139292
5.91004	,	-0.210089	,	-0.20977	,	-0.200894	,	-0.139399
5.9728	,	-0.210089	,	-0.20977	,	-0.201149	,	-0.140037
5.99372	,	-0.210089	,	-0.20977	,	-0.201213	,	-0.14025
6.00418	,	-0.210089	,	-0.20977	,	-0.201245	,	-0.140321
6.07741	,	-0.210089	,	-0.209834	,	-0.201469	,	-0.140818
6.08787	,	-0.210089	,	-0.209843	,	-0.201504	,	-0.140889
6.09833	,	-0.210089	,	-0.209852	,	-0.20154	,	-0.140953
6.17155	,	-0.210089	,	-0.209916	,	-0.201788	,	-0.1414
6.19247	,	-0.210089	,	-0.209934	,	-0.201916	,	-0.141527
6.22385	,	-0.210089	,	-0.209962	,	-0.202107	,	-0.14174
6.28661	,	-0.210089	,	-0.210016	,	-0.20249	,	-0.142166
6.32845	,	-0.210089	,	-0.210053	,	-0.202746	,	-0.142485
6.37029	,	-0.210089	,	-0.210089	,	-0.202746	,	-0.142805
6.43305	,	-0.210089	,	-0.210089	,	-0.202746	,	-0.143379
6.4749	,	-0.210089	,	-0.210089	,	-0.202928	,	-0.143762
6.50628	,	-0.210089	,	-0.210089	,	-0.203065	,	-0.143937
6.5272	,	-0.210089	,	-0.210089	,	-0.203129	,	-0.144053
6.58996	,	-0.210089	,	-0.210089	,	-0.203321	,	-0.144401
6.61088	,	-0.210089	,	-0.210089	,	-0.203384	,	-0.144543
6.6318	,	-0.210089	,	-0.210089	,	-0.203455	,	-0.144685
6.6841	,	-0.210089	,	-0.210089	,	-0.203633	,	-0.14504
6.70502	,	-0.210089	,	-0.210089	,	-0.203704	,	-0.145181
6.7364	,	-0.210089	,	-0.210089	,	-0.203823	,	-0.145394
6.77824	,	-0.210089	,	-0.210089	,	-0.203983	,	-0.145678
6.841	,	-0.210089	,	-0.210089	,	-0.204223	,	-0.146317
6.87238	,	-0.210089	,	-0.210089	,	-0.204342	,	-0.146636
6.94561	,	-0.210089	,	-0.210089	,	-0.204342	,	-0.146884
6.96653	,	-0.210089	,	-0.210089	,	-0.204342	,	-0.146955
6.97699	,	-0.210089	,	-0.210089	,	-0.204342	,	-0.147051
7.05021	,	-0.210089	,	-0.210089	,	-0.204622	,	-0.147722
7.06067	,	-0.210089	,	-0.210089	,	-0.204662	,	-0.147817
7.07113	,	-0.210089	,	-0.210089	,	-0.204693	,	-0.147913
7.15481	,	-0.210089	,	-0.210089	,	-0.204949	,	-0.148481
7.16527	,	-0.210089	,	-0.210089	,	-0.204981	,	-0.148552
7.25941	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.149126
7.26987	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.14919
7.31172	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.149446
7.36402	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.149765
7.42678	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.150148
7.43724	,	-0.210089	,	-0.210089	,	-0.2053	,	-0.150255
7.46862	,	-0.210089	,	-0.210089	,	-0.20542	,	-0.150574
7.52092	,	-0.210089	,	-0.210089	,	-0.205619	,	-0.151106
7.56276	,	-0.210089	,	-0.210089	,	-0.205779	,	-0.151106
7.6046	,	-0.210089	,	-0.210089	,	-0.205939	,	-0.151106
7.61506	,	-0.210089	,	-0.210089	,	-0.205939	,	-0.151106
7.66736	,	-0.210089	,	-0.210089	,	-0.205939	,	-0.151425
7.70921	,	-0.210089	,	-0.210089	,	-0.205939	,	-0.151681
7.71967	,	-0.210089	,	-0.210089	,	-0.205971	,	-0.151745
7.78243	,	-0.210089	,	-0.210089	,	-0.206162	,	-0.152383
7.81381	,	-0.210089	,	-0.210089	,	-0.206258	,	-0.152702
7.87657	,	-0.210089	,	-0.210089	,	-0.206405	,	-0.153086
7.91841	,	-0.210089	,	-0.210089	,	-0.206504	,	-0.153341
7.94979	,	-0.210089	,	-0.210089	,	-0.206577	,	-0.153554
7.97071	,	-0.210089	,	-0.210089	,	-0.206577	,	-0.153696
8.00209	,	-0.210089	,	-0.210089	,	-0.206577	,	-0.153909
8.01255	,	-0.210089	,	-0.210089	,	-0.206577	,	-0.15398
8.05439	,	-0.210089	,	-0.210089	,	-0.206577	,	-0.154192
8.08577	,	-0.210089	,	-0.210089	,	-0.206673	,	-0.154352
8.159	,	-0.210089	,	-0.210089	,	-0.206897	,	-0.154725
8.19038	,	-0.210089	,	-0.210089	,	-0.206897	,	-0.154884
8.20084	,	-0.210089	,	-0.210089	,	-0.206897	,	-0.154937
8.25314	,	-0.210089	,	-0.210089	,	-0.206897	,	-0.155292
8.29498	,	-0.210089	,	-0.210089	,	-0.207038	,	-0.155576
8.34728	,	-0.210089	,	-0.210089	,	-0.207216	,	-0.155576
8.39958	,	-0.210089	,	-0.210089	,	-0.207322	,	-0.155576
8.4728	,	-0.210089	,	-0.210089	,	-0.207471	,	-0.156135
8.48326	,	-0.210089	,	-0.210089	,	-0.207493	,	-0.156215
8.50418	,	-0.210089	,	-0.210089	,	-0.207535	,	-0.156356
8.57741	,	-0.210089	,	-0.210089	,	-0.207312	,	-0.156853
8.60879	,	-0.210089	,	-0.210089	,	-0.207216	,	-0.15696
8.67155	,	-0.210089	,	-0.210089	,	-0.207455	,	-0.157172
8.69247	,	-0.210089	,	-0.210089	,	-0.207535	,	-0.1573
8.71339	,	-0.210089	,	-0.210089	,	-0.207535	,	-0.157428
8.77615	,	-0.210089	,	-0.210089	,	-0.207535	,	-0.157811
8.79707	,	-0.210089	,	-0.210089	,	-0.207535	,	-0.157917
8.81799	,	-0.210089	,	-0.210089	,	-0.207599	,	-0.158024
8.90167	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.15845
8.92259	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.158513
9.00628	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.158769
9.0272	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.158911
9.04812	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.159053
9.10042	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.159407
9.1318	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.159647
9.15272	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.159807
9.1841	,	-0.210089	,	-0.210089	,	-0.207974	,	-0.160046
9.20502	,	-0.210089	,	-0.210089	,	-0.208054	,	-0.16011
9.2364	,	-0.210089	,	-0.210089	,	-0.208174	,	-0.160206
9.2887	,	-0.210089	,	-0.210089	,	-0.208014	,	-0.160365
9.341	,	-0.210089	,	-0.210089	,	-0.207854	,	-0.160525
9.39331	,	-0.210089	,	-0.210089	,	-0.208209	,	-0.160685
9.43515	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161004
9.44561	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161084
9.47699	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161323
9.52929	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161642
9.55021	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161706
9.63389	,	-0.210089	,	-0.210089	,	-0.208493	,	-0.161962
9.71757	,	-0.210089	,	-0.210089	,	-0.208963	,	-0.162194
9.74895	,	-0.210089	,	-0.210089	,	-0.209019	,	-0.162281
9.81172	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.162707
9.8431	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.16292
9.8954	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.163097
9.91632	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.163168
9.93724	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.163239
10	,	-0.210089	,	-0.210089	,	-0.209132	,	-0.163452
EOD

# -------------------------------------------------------------------------------

unset colorbox
unset grid

set style line 1  lt 1 lw 2 lc rgb "black"   ps 0.7 dt 1
set style line 2  lt 2 lw 2 lc rgb "gray25"  ps 0.7 dt 2
set style line 3  lt 4 lw 2 lc rgb "gray50"  ps 0.7 dt 3
set style line 4  lt 10 lw 2 lc rgb "gray75"  ps 0.7

set style line 11 lt 1  lw 1   lc rgb "dark-spring-green"   ps 0.7
set style line 12 lt 2  lw 1   lc rgb "dark-blue"           ps 0.7
set style line 13 lt 7  lw 1   lc rgb "dark-red"            ps 1.0
set style line 21 lt 19 lw 1   lc rgb "dark-yellow"         ps 1.0
set style line 22 lt 8  lw 1   lc rgb "dark-magenta"        ps 1.0
set style line 23 lt 4  lw 1   lc rgb "coral"               ps 1.0

# -------------------------------------------------------------------------------
# Read files for plotting                                                         ****CHANGE IF NEEDED***
# -------------------------------------------------------------------------------
fileStepK0 = "./Ehlers_step_load_kappa_0/data-for-gnuplot.sol"
fileStepK1 = "./Ehlers_step_load_kappa_1/data-for-gnuplot.sol"
fileStepK2 = "./Ehlers_step_load_kappa_2/data-for-gnuplot.sol"
fileStepK5 = "./Ehlers_step_load_kappa_5/data-for-gnuplot.sol"
fileIncrK0 = "./Ehlers_increase_load_kappa_0/data-for-gnuplot.sol"

# ---------  VERIFICATION EHLERS FIG 1 -------------------------------------------
set term png size 750,350 enhanced font 'Verdana,12'

set xrange [0:10]
set yrange [-0.35:0]

set xlabel 'Time [s]' font 'Verdana,14'
set ylabel 'vertical displacement [m]' font 'Verdana,14'

set key box  rmargin font 'Verdana,12'   width -10.0

set output "Ehlers-Fig1.png"
plot '$dataEhlers1'  using 1:2          with lines  ls 1  title 'Ehlers 1999,             step loading', \
     '$dataEhlers1'  using 1:3          with lines  ls 2  title                       'load increasing', \
     '$dataEhlers1'  using 1:4          with lines  ls 3  title                  'theoretical boundary', \
     fileStepK0      using 1:7 every 40  with points ls 23 title 'deal.II poroelasticity, step loading', \
     fileIncrK0      using 1:7 every 40  with points ls 12 title                           'load increasing'


# ---------  VERIFICATION EHLERS FIG 2 -------------------------------------------
set term png size 450,500 enhanced font 'Verdana,12'

set xrange [0:10]
set yrange [-0.25:0]

set xlabel 'Time [s]' font 'Verdana,14'
set ylabel 'vertical displacement [m]' font 'Verdana,14'

set key box out vert right above box font 'Verdana,12' width -5.0

set output "Ehlers-Fig2-displ.png"
plot '$dataEhlers2'  using 1:2          with lines  ls 1  title '(Ehlers 1999) κ = 0' , \
     '$dataEhlers2'  using 1:3          with lines  ls 2  title 'κ = 1' , \
     '$dataEhlers2'  using 1:4          with lines  ls 3  title 'κ = 2' , \
     '$dataEhlers2'  using 1:5          with lines  ls 4  title 'κ = 5' , \
     fileStepK0      using 1:7 every 50  with points ls 21 title 'deal.II poroelasticity, κ = 0', \
     fileStepK1      using 1:7 every 50  with points ls 22 title 'κ = 1', \
     fileStepK2      using 1:7 every 50  with points ls 23 title 'κ = 2', \
     fileStepK5      using 1:7 every 50  with points ls 11 title 'κ = 5'

set term png size 450,420 enhanced font 'Verdana,12'

set xrange [0:10]
set yrange [0:8]
set ylabel 'pore pressure [MPa]' font 'Verdana,14'

set output "Ehlers-Fig2-pressure.png"
plot fileStepK0   using 1:($12)/1000000  with lines ls 21 title 'deal.II poroelasticity, κ = 0', \
     fileStepK1   using 1:($12)/1000000  with lines ls 22 title 'κ = 1', \
     fileStepK2   using 1:($12)/1000000  with lines ls 23 title 'κ = 2', \
     fileStepK5   using 1:($12)/1000000  with lines ls 11 title 'κ = 5'


# ---------  VALIDATION EHLERS CONSOLIDATION CURVES  -------------------------------------------
#Final specimen shortening                                                                         ****CHANGE IF NEEDED***
Umax = 2.087773e-01

set key box out vert right above box font 'Verdana,12'  width -5.0

set logscale x
set xrange [0.001:10]
set yrange [1:0]

set xlabel 'Time [s]' font 'Verdana,14'
set ylabel 'consolidation ratio [-]' font 'Verdana,14'

set output "Ehlers-consolidation.png"
plot fileStepK0  using ($1):(-($7)/Umax) with lines ls 21 title 'deal.II poroelasticity, κ = 0', \
     fileStepK1  using ($1):(-($7)/Umax) with lines ls 22 title 'κ = 1', \
     fileStepK2  using ($1):(-($7)/Umax) with lines ls 23 title 'κ = 2', \
     fileStepK5  using ($1):(-($7)/Umax) with lines ls 11 title 'κ = 5'

unset logscale x
set yrange [0:1]
