/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

public class Polyconic
extends Projection {
    public static final Identifier POLY = new Identifier("EPSG", "9818", "Polyconic (American)", "POLY");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;

    public Polyconic(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(POLY, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.PSEUDOCONICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.APHYLACTIC;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) {
        double a = this.ellipsoid.getSemiMajorAxis();
        double M0 = a * this.ellipsoid.curvilinearAbscissa(this.lat0);
        if (coord[0] == 0.0) {
            coord[0] = this.FE + this.ellipsoid.getSemiMajorAxis() * (coord[1] - this.lon0);
            coord[1] = this.FN - M0;
        } else {
            double M = a * this.ellipsoid.curvilinearAbscissa(coord[0]);
            double v = this.ellipsoid.transverseRadiusOfCurvature(coord[0]);
            double L = (coord[1] - this.lon0) * Math.sin(coord[0]);
            coord[1] = this.FN + M - M0 + v / Math.tan(coord[0]) * (1.0 - Math.cos(L));
            coord[0] = this.FE + v / Math.tan(coord[0]) * Math.sin(L);
        }
        return coord;
    }

    private double curvilinearAbscissaPrime(double latitude) {
        double[] arc_coeff = this.ellipsoid.getArcCoeff();
        return arc_coeff[0] + 2.0 * arc_coeff[1] * Math.cos(2.0 * latitude) + 4.0 * arc_coeff[2] * Math.cos(4.0 * latitude) + 6.0 * arc_coeff[3] * Math.cos(6.0 * latitude) + 8.0 * arc_coeff[4] * Math.cos(8.0 * latitude);
    }

    @Override
    public Projection inverse() {
        return new Polyconic(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double a = this.ellipsoid.getSemiMajorAxis();
                double M0 = a * this.ellipsoid.curvilinearAbscissa(this.lat0);
                double e2 = this.ellipsoid.getSquareEccentricity();
                double x = coord[0] - this.FE;
                double y = coord[1] - this.FN;
                if (y + M0 == 0.0) {
                    coord[0] = 0.0;
                    coord[1] = this.lon0 + x / a;
                } else {
                    double A = (y + M0) / a;
                    double B = A * A + Math.pow(x / a, 2.0);
                    double C = 0.0;
                    int MAXITER = 10;
                    double lat = A;
                    double latold = 1.0E30;
                    int iter = 0;
                    while (++iter < 10 && Math.abs(lat - latold) > 1.0E-15) {
                        latold = lat;
                        C = Math.sqrt(1.0 - e2 * Math.sin(lat) * Math.sin(lat)) * Math.tan(lat);
                        double J = this.ellipsoid.curvilinearAbscissa(lat);
                        double I = Polyconic.this.curvilinearAbscissaPrime(lat);
                        lat = latold - (A * (C * J + 1.0) - J - C / 2.0 * (J * J + B)) / (e2 * Math.sin(2.0 * latold) * (J * (J - 2.0 * A) + B) / 4.0 / C + (A - J) * (C * I - 2.0 / Math.sin(2.0 * latold)) - I);
                    }
                    if (iter == 10) {
                        throw new ArithmeticException("The inverse Polyconic Projection method diverges. Last value of tolerance = " + Math.abs(lat - latold));
                    }
                    coord[0] = lat;
                    coord[1] = this.lon0 + Math.asin(x * C / a) / Math.sin(lat);
                }
                return coord;
            }

            @Override
            public Projection inverse() {
                return Polyconic.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return Polyconic.this.toString() + " inverse";
            }
        };
    }
}

