/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.installer.AutomatedInstaller;
import com.izforge.izpack.installer.ConsoleInstaller;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import java.util.Date;

public class Installer {
    public static void main(String[] stringArray) {
        Debug.log(" - Logger initialized at '" + new Date(System.currentTimeMillis()) + "'.");
        Debug.log(" - commandline args: " + StringTool.stringArrayToSpaceSeparatedString(stringArray));
        if (System.getProperty("mrj.version") != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "IzPack");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
        }
        try {
            if (stringArray.length == 0) {
                Class.forName("com.izforge.izpack.installer.GUIInstaller").newInstance();
            } else if (stringArray.length == 1) {
                if ("-console".equals(stringArray[0].trim())) {
                    Debug.log("starting in console mode");
                    ConsoleInstaller consoleInstaller = new ConsoleInstaller();
                    consoleInstaller.doInstall();
                } else {
                    AutomatedInstaller automatedInstaller = new AutomatedInstaller(stringArray[0]);
                    automatedInstaller.doInstall();
                }
            } else if (stringArray.length == 2) {
                ConsoleInstaller consoleInstaller;
                if ("-options-template".equals(stringArray[0].trim())) {
                    Debug.log("Generating properties file");
                    consoleInstaller = new ConsoleInstaller();
                    consoleInstaller.doGeneratePropertiesFile(stringArray[1]);
                }
                if ("-options".equals(stringArray[0].trim())) {
                    Debug.log("Installing from  properties file");
                    consoleInstaller = new ConsoleInstaller();
                    consoleInstaller.doInstallFromPropertiesFile(stringArray[1]);
                } else {
                    System.out.println("not a valid option!!!!");
                }
            }
        }
        catch (Exception exception) {
            System.err.println("- ERROR -");
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

