/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.witness;

import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractState;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.classfile.MethodSignature;

public class JvmLocalVariableLocation
extends JvmMemoryLocation {
    public final int index;

    public JvmLocalVariableLocation(int index) {
        this(null, index);
    }

    public JvmLocalVariableLocation(ArgProgramLocationDependentAbstractState<JvmCfaNode, JvmCfaEdge, MethodSignature> argNode, int index) {
        this.argNode = argNode;
        this.index = index;
    }

    @Override
    public JvmLocalVariableLocation copy() {
        return new JvmLocalVariableLocation(this.argNode, this.index);
    }

    @Override
    public <T extends LatticeAbstractState> T extractValueOrDefault(JvmAbstractState abstractState, T defaultValue) {
        return abstractState.getVariableOrDefault(this.index, defaultValue);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JvmLocalVariableLocation)) {
            return false;
        }
        JvmLocalVariableLocation other = (JvmLocalVariableLocation)obj;
        return super.equals(obj) && this.index == other.index;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.argNode, this.index);
    }

    public String toString() {
        return "JvmLocalVariableLocation(" + this.index + ")" + (this.argNode == null ? "" : "@" + ((JvmCfaNode)this.argNode.getProgramLocation()).getSignature().getFqn() + ":" + ((JvmCfaNode)this.argNode.getProgramLocation()).getOffset());
    }
}

