/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequencesReplacer;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.visitor.ClassVisitor;

public class SimpleEnumClassSimplifier
implements ClassVisitor,
AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(SimpleEnumClassSimplifier.class);
    private static final int ENUM_CLASS_NAME = 0x40000003;
    private static final int ENUM_TYPE_NAME = 0x40000004;
    private static final int ENUM_CONSTANT_NAME = 0x40000000;
    private static final int ENUM_CONSTANT_ORDINAL = 0x40000001;
    private static final int ENUM_CONSTANT_FIELD_NAME = 0x40000002;
    private static final int STRING_ENUM_CONSTANT_NAME = 0;
    private static final int METHOD_ENUM_INIT = 1;
    private static final int FIELD_ENUM_CONSTANT = 2;
    private static final int CLASS_ENUM = 3;
    private static final int NAME_AND_TYPE_ENUM_INIT = 4;
    private static final int NAME_AND_TYPE_ENUM_CONSTANT = 5;
    private static final int UTF8_INIT = 6;
    private static final int UTF8_STRING_I = 7;
    private static final Constant[] CONSTANTS = new Constant[]{new StringConstant(0x40000000, null, null), new MethodrefConstant(3, 4, null, null), new FieldrefConstant(3, 5, null, null), new ClassConstant(0x40000003, null), new NameAndTypeConstant(6, 7), new NameAndTypeConstant(0x40000002, 0x40000004), new Utf8Constant("<init>"), new Utf8Constant("(Ljava/lang/String;I)V")};
    private static final Instruction[][][] INSTRUCTION_SEQUENCES = new Instruction[][][]{{{new ConstantInstruction(-69, 3), new SimpleInstruction(89), new ConstantInstruction(18, 0), new SimpleInstruction(3, 0x40000001), new ConstantInstruction(-73, 1)}, {new SimpleInstruction(17, 0x40000001), new SimpleInstruction(4), new SimpleInstruction(96)}}, {{new SimpleInstruction(3, 0x40000001), new ConstantInstruction(-73, 1)}, {new SimpleInstruction(3), new ConstantInstruction(-73, 1), new SimpleInstruction(87), new SimpleInstruction(17, 0x40000001), new SimpleInstruction(4), new SimpleInstruction(96)}}, {{new ConstantInstruction(-73, 1)}, {new SimpleInstruction(91), new SimpleInstruction(87), new SimpleInstruction(3), new ConstantInstruction(-73, 1), new SimpleInstruction(95), new SimpleInstruction(87), new SimpleInstruction(4), new SimpleInstruction(96)}}};
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private final InstructionSequencesReplacer instructionSequenceReplacer = new InstructionSequencesReplacer(CONSTANTS, INSTRUCTION_SEQUENCES, null, this.codeAttributeEditor);

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        logger.debug("SimpleEnumClassSimplifier: [{}]", (Object)programClass.getName());
        programClass.u2accessFlags &= 0xFFFFBFFF;
        Method valueOfMethod = programClass.findMethod("valueOf", null);
        if (valueOfMethod != null) {
            new ClassEditor(programClass).removeMethod(valueOfMethod);
        }
        programClass.methodAccept("<clinit>", "()V", new AllAttributeVisitor(this));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this.instructionSequenceReplacer);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }
}

