/*
 * Decompiled with CFR 0.152.
 */
package driftwood.util;

import java.io.IOException;
import java.io.OutputStream;

public class URLEncodedOutputStream
extends OutputStream {
    static final String HEX_CHARS = "0123456789ABCDEF";
    OutputStream out;
    boolean doEncoding = true;

    public URLEncodedOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        if (!this.doEncoding) {
            this.out.write(n);
        } else if (97 <= n && n <= 122 || 65 <= n && n <= 90 || 48 <= n && n <= 57 || n == 46 || n == 45 || n == 42 || n == 95) {
            this.out.write(n);
        } else if (n == 32) {
            this.out.write(43);
        } else {
            this.out.write(37);
            this.out.write(HEX_CHARS.charAt(n >> 4 & 0xF));
            this.out.write(HEX_CHARS.charAt(n & 0xF));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public boolean getEncoding() {
        return this.doEncoding;
    }

    public void setEncoding(boolean bl) {
        this.doEncoding = bl;
    }
}

