/*
 * Decompiled with CFR 0.152.
 */
package king.core;

import driftwood.r3.Transform;
import java.util.ArrayList;
import king.core.AGE;
import king.core.Engine;
import king.core.KGroup;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KList
extends AGE<KGroup, KPoint>
implements Cloneable {
    public static final String VECTOR = "vector";
    public static final String DOT = "dot";
    public static final String MARK = "mark";
    public static final String LABEL = "label";
    public static final String TRIANGLE = "triangle";
    public static final String RIBBON = "ribbon";
    public static final String RING = "ring";
    public static final String BALL = "ball";
    public static final String SPHERE = "sphere";
    public static final String ARROW = "arrow";
    protected String type;
    protected KList instance = null;
    protected KPaint color = KPalette.defaultColor;
    protected int alpha = 255;
    protected float radius = 0.2f;
    protected float angle = 20.0f;
    protected int width = 2;
    protected int style = 0;
    protected Object clipMode = null;
    protected int dimension = 3;
    protected boolean screen = false;
    protected boolean rear = false;
    protected boolean fore = false;

    public KList(String string) {
        this(string, "");
    }

    public KList(String string, String string2) {
        this.type = string;
        this.setName(string2);
    }

    public KList clone(boolean bl) {
        try {
            KList kList = (KList)super.clone(bl);
            kList.children = new ArrayList();
            if (bl) {
                KList kList2 = this.getUltimateInstance();
                if (kList2 == null) {
                    kList2 = this;
                }
                KPoint kPoint = null;
                for (KPoint kPoint2 : kList2.getChildren()) {
                    KPoint kPoint3 = kPoint2.clone();
                    kList.add(kPoint3);
                    kPoint3.setParent(kList);
                    if (kPoint3.getPrev() != null) {
                        kPoint3.setPrev(kPoint);
                    }
                    kPoint = kPoint3;
                }
            } else if (this.getInstance() == null) {
                kList.setInstance(this);
            } else {
                kList.setInstance(this.getInstance());
            }
            if (this.masters != null) {
                kList.masters = new ArrayList(this.masters);
            }
            return kList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone failed in cloneable object");
        }
    }

    public void setInstance(KList kList) {
        this.instance = kList;
        this.fireKinChanged(256);
    }

    public KList getInstance() {
        return this.instance;
    }

    public KList getUltimateInstance() {
        KList kList = this.getInstance();
        if (kList == null) {
            return null;
        }
        while (kList.getInstance() != null) {
            kList = kList.getInstance();
        }
        return kList;
    }

    public String getType() {
        return this.type;
    }

    public KPaint getColor() {
        return this.color;
    }

    public void setColor(KPaint kPaint) {
        this.color = kPaint;
        this.fireKinChanged(514);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n > 7 ? 7 : (n < 1 ? 1 : n);
        this.fireKinChanged(514);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        this.radius = f;
        this.fireKinChanged(514);
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int n) {
        this.alpha = n;
    }

    public void setScreen(boolean bl) {
        this.screen = bl;
        this.fireKinChanged(514);
    }

    public boolean getScreen() {
        return this.screen;
    }

    public void setRear(boolean bl) {
        this.rear = bl;
        this.fireKinChanged(514);
    }

    public boolean getRear() {
        return this.rear;
    }

    public void setFore(boolean bl) {
        this.fore = bl;
        this.fireKinChanged(514);
    }

    public boolean getFore() {
        return this.fore;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
        this.fireKinChanged(514);
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
        this.fireKinChanged(514);
    }

    public Object getClipMode() {
        return this.clipMode;
    }

    public void setClipMode(Object object) {
        this.clipMode = object;
        this.fireKinChanged(514);
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int n) {
        this.dimension = n;
        this.fireKinChanged(514);
    }

    public boolean getNoHighlight() {
        return (this.flags & 0x400) == 1024;
    }

    public void setNoHighlight(boolean bl) {
        int n = this.flags;
        this.flags = bl ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
        if (this.flags != n) {
            this.fireKinChanged(2);
        }
    }

    @Override
    public void doTransform(Engine engine, Transform transform) {
        Transform transform2;
        KList kList;
        if (!this.isOn()) {
            return;
        }
        if (this.clipMode != null) {
            engine.chooseClipMode(this.clipMode);
        }
        if ((kList = this.getUltimateInstance()) != null) {
            engine.setActingParent(this);
            transform2 = transform;
            if (kList.getTransform() != null) {
                transform2 = new Transform().like(kList.getTransform()).append(transform);
            }
            for (KPoint kPoint : kList.getChildren()) {
                kPoint.doTransform(engine, transform2, engine.zoom3D);
            }
        }
        engine.setActingParent(null);
        transform2 = transform;
        if (this.getTransform() != null) {
            transform2 = new Transform().like(this.getTransform()).append(transform);
        }
        for (KPoint kPoint : this.getChildren()) {
            kPoint.doTransform(engine, transform2, engine.zoom3D);
        }
        if (this.clipMode != null) {
            engine.chooseClipMode(null);
        }
    }
}

