/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelingTool;
import chiropraxis.kingtools.SidechainRotator;
import chiropraxis.sc.SidechainIdealizer;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.util.SoftLog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import king.ToolBox;
import king.core.KPoint;

public class ScMutTool
extends ModelingTool
implements ItemListener {
    SidechainIdealizer idealizer = null;
    String[] resChoices = null;
    boolean usePdbv3 = true;

    public ScMutTool(ToolBox toolBox) {
        super(toolBox);
        try {
            this.idealizer = new SidechainIdealizer();
            Collection collection = this.idealizer.getResidueTypes();
            this.resChoices = collection.toArray(new String[collection.size()]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void start() {
        super.start();
        if (this.idealizer == null) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Library of ideal amino acids could not be loaded.", "Missing data resource", 0);
            this.parent.activateDefaultTool();
            return;
        }
        this.modelman.onShowDialog(null);
        this.services.setID("Ctrl-click, option-click, or middle-click a residue to mutate it");
        this.kCanvas.repaint();
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint != null) {
            ModelState modelState;
            if (this.modelman.isMolten()) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Residues cannot be mutated while the model is being resculpted.\nPlease release all mobile groups and then try again.", "Cannot mutate molten model", 0);
                return;
            }
            Model model = this.modelman.getModel();
            Residue residue = this.getResidueNearest(model, modelState = this.modelman.getFrozenState(), kPoint.getX(), kPoint.getY(), kPoint.getZ());
            if (residue != null) {
                this.askMutateResidue(model, residue, modelState);
            }
        }
    }

    private String makeOptionPane(Residue residue) {
        JOptionPane jOptionPane = new JOptionPane("Mutate this sidechain to what?", 3, 2, null);
        jOptionPane.setSelectionValues(this.resChoices);
        jOptionPane.setInitialSelectionValue(residue.getName());
        JDialog jDialog = jOptionPane.createDialog(this.kMain.getTopWindow(), "Choose mutation");
        jOptionPane.selectInitialValue();
        JCheckBox jCheckBox = new JCheckBox("Use PDB v2.3 (old) format");
        jCheckBox.setPreferredSize(new Dimension(300, 30));
        jCheckBox.setMaximumSize(new Dimension(300, 30));
        jCheckBox.setAlignmentX(0.5f);
        this.usePdbv3 = true;
        jCheckBox.addItemListener(this);
        jOptionPane.add(jCheckBox);
        jDialog.setVisible(true);
        return (String)jOptionPane.getInputValue();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.usePdbv3 = itemEvent.getStateChange() == 2;
    }

    void askMutateResidue(Model model, Residue residue, ModelState modelState) {
        try {
            String string = this.makeOptionPane(residue);
            if (string == null || string.equals(JOptionPane.UNINITIALIZED_VALUE)) {
                return;
            }
            ModelState modelState2 = new ModelState(modelState);
            Residue residue2 = this.idealizer.makeIdealResidue(residue.getChain(), residue.getSegment(), residue.getSequenceNumber(), residue.getInsertionCode(), string, modelState2, this.usePdbv3);
            modelState2 = this.idealizer.dockResidue(residue2, modelState2, residue, modelState);
            if (string.equals("HIS")) {
                string = (String)JOptionPane.showInputDialog(this.kMain.getTopWindow(), "Choose protonation state:", "Choose protonation state", 3, null, new String[]{"ND1 and NE2", "ND1 only", "NE2 only"}, "ND1 and NE2");
                if ("ND1 only".equals(string)) {
                    residue2.remove(residue2.getAtom(" HE2"));
                } else if ("NE2 only".equals(string)) {
                    residue2.remove(residue2.getAtom(" HD1"));
                }
            }
            Model model2 = (Model)model.clone();
            model2.replace(residue, residue2);
            modelState2 = modelState2.createForModel(model2);
            this.modelman.replaceModelAndState(model2, modelState2);
            this.modelman.addUserMod("Mutated " + residue + " to " + residue2);
            try {
                new SidechainRotator(this.kMain, residue2, this.modelman);
            }
            catch (IOException iOException) {
                iOException.printStackTrace(SoftLog.err);
            }
        }
        catch (ResidueException residueException) {
            residueException.printStackTrace(SoftLog.err);
        }
        catch (AtomException atomException) {
            atomException.printStackTrace(SoftLog.err);
        }
    }

    protected Container getToolPanel() {
        return null;
    }

    public String getHelpAnchor() {
        return "#scmut-tool";
    }

    public String toString() {
        return "Sidechain mutator";
    }
}

