/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Suppose {
    Model model1 = null;
    Model model2 = null;
    AtomState[] ca1 = null;
    AtomState[] ca2 = null;
    String[] labels = null;
    final int nIter = 7;
    Triple[][] vdd12 = null;
    Triple[][] vdd21 = null;
    double[][] vdd_w = null;
    double[][] usdd = null;
    int nResToSuperpos = -1;
    double fracToSuperpos = -1.0;
    File file1 = null;
    File file2 = null;
    InputStream input1 = null;
    InputStream input2 = null;
    PrintStream output = System.out;

    public static double[] computeUSDD(Triple[] tripleArray, Triple[] tripleArray2, double[] dArray) {
        int n;
        if (tripleArray.length != tripleArray2.length || tripleArray.length != dArray.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        int n2 = tripleArray.length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray2[n] = 0.0;
        }
        n = 0;
        while (n < n2) {
            for (int i = 0; i < n2; ++i) {
                double d = tripleArray[n].distance(tripleArray[i]) - tripleArray2[n].distance(tripleArray2[i]);
                double d2 = dArray[n] / (dArray[n] + dArray[i]);
                int n3 = n;
                dArray2[n3] = dArray2[n3] + Math.abs(d2 * d);
            }
            int n4 = n++;
            dArray2[n4] = dArray2[n4] * (2.5 / (double)n2);
        }
        return dArray2;
    }

    public static Triple[] computeVDD(Triple[] tripleArray, Triple[] tripleArray2, double[] dArray) {
        int n;
        if (tripleArray.length != tripleArray2.length || tripleArray.length != dArray.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        int n2 = tripleArray.length;
        Triple triple = new Triple();
        Triple[] tripleArray3 = new Triple[n2];
        for (n = 0; n < n2; ++n) {
            tripleArray3[n] = new Triple(0.0, 0.0, 0.0);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n2; ++i) {
                double d = tripleArray[n].distance(tripleArray[i]) - tripleArray2[n].distance(tripleArray2[i]);
                double d2 = dArray[n] / (dArray[n] + dArray[i]);
                triple.likeVector(tripleArray[n], tripleArray[i]);
                triple.unit().mult(d2 * d);
                tripleArray3[n].add(triple);
            }
            tripleArray3[n].mult(3.0 / (double)n2);
        }
        return tripleArray3;
    }

    public static void kin3dVDD(OutputStream outputStream, Triple[] tripleArray, Triple[] tripleArray2) {
        Suppose.kin3dVDD(new OutputStreamWriter(outputStream), tripleArray, tripleArray2);
    }

    public static void kin3dVDD(Writer writer, Triple[] tripleArray, Triple[] tripleArray2) {
        PrintWriter printWriter = new PrintWriter(writer);
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        Triple triple = new Triple();
        if (tripleArray.length != tripleArray2.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        for (int i = 0; i < tripleArray.length; ++i) {
            triple.like(tripleArray[i]);
            printWriter.print("{}P " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
            triple.add(tripleArray2[i]);
            printWriter.println("{} " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
        }
        printWriter.flush();
    }

    public static void kin2dStdDD(OutputStream outputStream, Triple[] tripleArray, Triple[] tripleArray2, String[] stringArray) {
        Suppose.kin2dStdDD(new OutputStreamWriter(outputStream), tripleArray, tripleArray2, stringArray);
    }

    public static void kin2dStdDD(Writer writer, Triple[] tripleArray, Triple[] tripleArray2, String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(writer);
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        if (tripleArray.length != tripleArray2.length || tripleArray.length != stringArray.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        double[] dArray = new double[]{-1.0, 0.025, 0.05, 0.075, 0.1, 0.2, 0.3, 0.6, 1.0, 1.5, 2.0, 3.5, 5.0, Double.POSITIVE_INFINITY};
        String[] stringArray2 = new String[]{"gray", "purple", "blue", "sky", "cyan", "sea", "green", "lime", "yellow", "gold", "orange", "red", "hotpink"};
        String string = "deadwhite";
        for (int i = 0; i < tripleArray.length; ++i) {
            for (int j = 0; j < tripleArray2.length; ++j) {
                double d = Math.abs(tripleArray[i].distance(tripleArray[j]) - tripleArray2[i].distance(tripleArray2[j]));
                int n = 0;
                while (d > dArray[n]) {
                    string = stringArray2[n];
                    ++n;
                }
                printWriter.println("{" + decimalFormat.format(d) + ": " + stringArray[i] + "," + stringArray[j] + "}P " + string + " " + decimalFormat.format(i) + " " + decimalFormat.format(j) + " 0.0");
            }
        }
        printWriter.flush();
    }

    public static void kin1dVDD(OutputStream outputStream, String[] stringArray, double[] dArray, double d) {
        Suppose.kin1dVDD(new OutputStreamWriter(outputStream), stringArray, dArray, d);
    }

    public static void kin1dVDD(Writer writer, String[] stringArray, double[] dArray, double d) {
        PrintWriter printWriter = new PrintWriter(writer);
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            printWriter.print("{" + stringArray[i] + "}P " + decimalFormat.format(0.2 * (double)i) + " 0.0 " + decimalFormat.format(d));
            printWriter.println("{\"} " + decimalFormat.format(0.2 * (double)i) + " " + decimalFormat.format(dArray[i]) + " " + decimalFormat.format(d));
        }
        printWriter.flush();
    }

    public static SortItem[] sortByDD(Tuple3[] tuple3Array, Tuple3[] tuple3Array2, double[] dArray, String[] stringArray) {
        if (tuple3Array.length != tuple3Array2.length || tuple3Array.length != dArray.length) {
            throw new IllegalArgumentException("Lengths of inputs must match");
        }
        Object[] objectArray = new SortItem[tuple3Array.length];
        for (int i = 0; i < tuple3Array.length; ++i) {
            objectArray[i] = new SortItem(tuple3Array[i], tuple3Array2[i], dArray[i], stringArray[i]);
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static SortItem[] sortByLeskSieve(Tuple3[] tuple3Array, Tuple3[] tuple3Array2, String[] stringArray) {
        int n;
        int n2 = tuple3Array.length;
        Tuple3[] tuple3Array3 = new Tuple3[tuple3Array.length];
        Tuple3[] tuple3Array4 = new Tuple3[tuple3Array2.length];
        String[] stringArray2 = new String[stringArray.length];
        for (n = 0; n < n2; ++n) {
            tuple3Array3[n] = tuple3Array[n];
            tuple3Array4[n] = tuple3Array2[n];
            stringArray2[n] = stringArray[n];
        }
        SortItem[] sortItemArray = new SortItem[n2];
        SuperPoser superPoser = new SuperPoser(tuple3Array3, tuple3Array4);
        Triple triple = new Triple();
        while (n2 > 0) {
            superPoser.reset(tuple3Array3, 0, tuple3Array4, 0, n2);
            Transform transform = superPoser.superpos();
            double d = superPoser.calcRMSD(transform);
            int n3 = -1;
            double d2 = -1.0;
            for (n = 0; n < n2; ++n) {
                transform.transform(tuple3Array4[n], triple);
                double d3 = triple.sqDistance(tuple3Array3[n]);
                if (!(d3 > d2)) continue;
                d2 = d3;
                n3 = n;
            }
            sortItemArray[sortItemArray.length - n2] = new SortItem(tuple3Array3[n3], tuple3Array4[n3], d, stringArray2[n3]);
            Tuple3 tuple3 = tuple3Array3[n2 - 1];
            tuple3Array3[n2 - 1] = tuple3Array3[n3];
            tuple3Array3[n3] = tuple3;
            tuple3 = tuple3Array4[n2 - 1];
            tuple3Array4[n2 - 1] = tuple3Array4[n3];
            tuple3Array4[n3] = tuple3;
            String string = stringArray2[n2 - 1];
            stringArray2[n2 - 1] = stringArray2[n3];
            stringArray2[n3] = string;
            --n2;
        }
        return sortItemArray;
    }

    Model loadModel(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Must supply two input files");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        return coordinateFile.getFirstModel();
    }

    AtomState[] loadAtomStates(Model model) {
        Collection collection = model.getResidues();
        ModelState modelState = model.getState();
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (Residue residue : collection) {
            Atom atom = residue.getAtom(" CA ");
            try {
                if (atom == null) continue;
                arrayList.add(modelState.get(atom));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        AtomState[] atomStateArray = arrayList.toArray(new AtomState[arrayList.size()]);
        return atomStateArray;
    }

    public String makeLsqman(SortItem[] sortItemArray, int n) {
        int n2;
        int n3 = n;
        int n4 = sortItemArray.length - n3;
        Object[] objectArray = new Residue[n3];
        Object[] objectArray2 = new Residue[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n2] = ((AtomState)sortItemArray[n2 + n4].ca1).getResidue();
            objectArray2[n2] = ((AtomState)sortItemArray[n2 + n4].ca2).getResidue();
        }
        Arrays.sort(objectArray);
        Arrays.sort(objectArray2);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        Object object = objectArray[0];
        Object object2 = objectArray[0];
        stringBuffer.append(Suppose.printRes((Residue)objectArray[0], true));
        stringBuffer2.append(Suppose.printRes((Residue)objectArray2[0], true));
        for (n2 = 1; n2 < n3; ++n2) {
            if (objectArray[n2] != ((Residue)object2).getNext(this.model1)) {
                if (object2 != object) {
                    stringBuffer.append('-').append(Suppose.printRes((Residue)object2, false));
                }
                stringBuffer.append(' ');
                object = objectArray[n2];
                stringBuffer.append(Suppose.printRes((Residue)objectArray[n2], true));
                stringBuffer2.append(' ');
                stringBuffer2.append(Suppose.printRes((Residue)objectArray2[n2], true));
            }
            object2 = objectArray[n2];
        }
        if (object2 != object) {
            stringBuffer.append('-').append(Suppose.printRes((Residue)object2, false));
        }
        return "ex m1 \"" + stringBuffer + "\" m2 \"" + stringBuffer2 + "\"";
    }

    public static String printRes(Residue residue, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && !" ".equals(residue.getChain())) {
            stringBuffer.append(residue.getChain());
        }
        stringBuffer.append(residue.getSequenceNumber());
        if (!" ".equals(residue.getInsertionCode())) {
            stringBuffer.append(residue.getInsertionCode());
        }
        return stringBuffer.toString();
    }

    void plotDiffDist() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        AtomState[] atomStateArray = new AtomState[this.ca1.length];
        AtomState[] atomStateArray2 = new AtomState[this.ca2.length];
        String[] stringArray = new String[this.labels.length];
        this.output.println("@kinemage 1");
        this.output.println("@title {std diff dist}");
        this.output.println("@group {unsorted} dominant");
        this.output.println("@subgroup {diff dist}");
        this.output.println("@balllist {diff dist} nohighlight radius= 0.45");
        Suppose.kin2dStdDD(this.output, (Triple[])this.ca1, (Triple[])this.ca2, this.labels);
    }

    void plotMagnitudes() {
        this.output.println("@kinemage 2");
        this.output.println("@title {per-res DD}");
        for (int i = 0; i < 7; ++i) {
            this.output.println("@group {rd " + i + "} dominant animate");
            this.output.println("@subgroup {iterative-weighted}");
            this.output.println("@vectorlist {vdd-average (1->2, 2->1)} off master= {vector} color= red");
            Suppose.kin1dVDD(this.output, this.labels, this.vdd_w[i + 1], (double)(i + 1) / 10.0);
            this.output.println("@vectorlist {2.5*av unsigned sum} master= {unsigned sum} color= yellow");
            Suppose.kin1dVDD(this.output, this.labels, this.usdd[i + 1], (double)(-(i + 1)) / 10.0);
        }
    }

    void plotVectors3D() {
        this.output.println("@kinemage 3");
        this.output.println("@title {vector DD}");
        for (int i = 0; i < 7; ++i) {
            this.output.println("@group {rd " + i + "} dominant animate");
            this.output.println("@subgroup {iterative-weighted}");
            this.output.println("@vectorlist {1->2} color= magenta master= {1->2}");
            Suppose.kin3dVDD(this.output, (Triple[])this.ca1, this.vdd12[i]);
            this.output.println("@vectorlist {2->1} color= magenta master= {2->1}");
            Suppose.kin3dVDD(this.output, (Triple[])this.ca2, this.vdd21[i]);
        }
    }

    void plotLesk() {
        SortItem sortItem;
        int n;
        int n2 = this.ca1.length;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        SortItem[] sortItemArray = Suppose.sortByLeskSieve(this.ca1, this.ca2, this.labels);
        SortItem[] sortItemArray2 = Suppose.sortByDD(this.ca1, this.ca2, this.usdd[7], this.labels);
        Tuple3[] tuple3Array = new AtomState[n2];
        Tuple3[] tuple3Array2 = new AtomState[n2];
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            tuple3Array[n] = (AtomState)sortItemArray2[n].ca1;
            tuple3Array2[n] = (AtomState)sortItemArray2[n].ca2;
            stringArray[n] = sortItemArray2[n].label;
        }
        int n3 = n2 - this.nResToSuperpos;
        SuperPoser superPoser = new SuperPoser(tuple3Array, n3, tuple3Array2, n3, this.nResToSuperpos);
        Transform transform = superPoser.superpos();
        double d = superPoser.calcRMSD(transform);
        this.output.println("@kinemage 4");
        this.output.println("@title {Lesk plot}");
        this.output.println("@text");
        this.output.println("LSQMAN script:");
        this.output.println("chain_mode original");
        this.output.println("hydrogens keep");
        this.output.println("hetatm keep");
        this.output.println("atom_types ca");
        this.output.println("read m1 " + this.file1);
        this.output.println("read m2 " + this.file2);
        this.output.println("### 'ex' line from below goes here ###");
        this.output.println("apply_operator m1 m2");
        this.output.println("write m2 superpos" + this.file2);
        this.output.println();
        this.output.println();
        this.output.println("Ca RMSD for Lesk's sieve = " + decimalFormat.format(sortItemArray[sortItemArray.length - this.nResToSuperpos].score));
        this.output.println("Selection covers " + this.nResToSuperpos + " residues (" + Math.round(100.0 * (double)this.nResToSuperpos / (double)this.ca1.length) + "%)");
        this.output.println(this.makeLsqman(sortItemArray, this.nResToSuperpos));
        this.output.println();
        this.output.println();
        this.output.println("Ca RMSD for IWUSDD = " + decimalFormat.format(d));
        this.output.println("Selection covers " + this.nResToSuperpos + " residues (" + Math.round(100.0 * (double)this.nResToSuperpos / (double)this.ca1.length) + "%)");
        this.output.println(this.makeLsqman(sortItemArray2, this.nResToSuperpos));
        double d2 = sortItemArray[0].score / (double)n2;
        this.output.println("@vectorlist {IWUSDD vs. rmsd} color= sky");
        for (n = 0; n < n2; ++n) {
            superPoser.reset(tuple3Array, n, tuple3Array2, n, n2 - n);
            transform = superPoser.superpos();
            d = superPoser.calcRMSD(transform);
            sortItem = sortItemArray2[n];
            this.output.println("{rmsd " + decimalFormat.format(d) + " for " + (n2 - n) + " res; worst=" + sortItem.label + "} " + decimalFormat.format((double)(n2 - n - 1) * d2) + " " + decimalFormat.format(d) + " 0.0");
        }
        this.output.println("@vectorlist {Lesk plot} color= sea");
        for (n = 0; n < n2; ++n) {
            sortItem = sortItemArray[n];
            this.output.println("{rmsd " + decimalFormat.format(sortItem.score) + " for " + (n2 - n) + " res; worst=" + sortItem.label + "} " + decimalFormat.format((double)(n2 - n - 1) * d2) + " " + decimalFormat.format(sortItem.score) + " 0.0");
        }
        this.output.println("@vectorlist {axes} color= white");
        this.output.println("{} 0 0 0 {} " + decimalFormat.format((double)n * d2) + " 0 0 {} " + decimalFormat.format((double)n * d2) + " " + decimalFormat.format(sortItemArray[0].score) + " 0");
    }

    void initData() throws IOException {
        int n;
        this.model1 = this.loadModel(this.input1);
        this.ca1 = this.loadAtomStates(this.model1);
        this.model2 = this.loadModel(this.input2);
        this.ca2 = this.loadAtomStates(this.model2);
        if (this.ca1.length != this.ca2.length) {
            throw new IllegalArgumentException("Selections must have same number of C-alphas");
        }
        this.labels = new String[this.ca1.length];
        for (n = 0; n < this.ca1.length; ++n) {
            this.labels[n] = this.ca1[n].getResidue().toString();
        }
        this.vdd12 = new Triple[7][];
        this.vdd21 = new Triple[7][];
        this.vdd_w = new double[8][this.ca1.length];
        for (n = 0; n < this.vdd_w[0].length; ++n) {
            this.vdd_w[0][n] = 1.0;
        }
        for (n = 0; n < 7; ++n) {
            this.vdd12[n] = Suppose.computeVDD(this.ca1, this.ca2, this.vdd_w[n]);
            this.vdd21[n] = Suppose.computeVDD(this.ca2, this.ca1, this.vdd_w[n]);
            for (int i = 0; i < this.vdd_w[n + 1].length; ++i) {
                this.vdd_w[n + 1][i] = (this.vdd12[n][i].mag() + this.vdd21[n][i].mag()) / 2.0;
            }
        }
        this.usdd = new double[8][this.ca1.length];
        for (n = 0; n < this.usdd[0].length; ++n) {
            this.usdd[0][n] = 1.0;
        }
        for (n = 0; n < 7; ++n) {
            this.usdd[n + 1] = Suppose.computeUSDD(this.ca1, this.ca2, this.usdd[n]);
        }
        if (this.fracToSuperpos > 0.0) {
            if (this.fracToSuperpos > 1.0 && this.fracToSuperpos <= 100.0) {
                this.nResToSuperpos = (int)Math.round(this.fracToSuperpos / 100.0 * (double)this.ca1.length);
            } else if (this.fracToSuperpos <= 1.0) {
                this.nResToSuperpos = (int)Math.round(this.fracToSuperpos * (double)this.ca1.length);
            }
        }
        if (this.nResToSuperpos < 3) {
            this.nResToSuperpos = this.ca1.length;
        }
    }

    public void Main() throws IOException {
        this.initData();
        this.plotDiffDist();
        this.plotMagnitudes();
        this.plotVectors3D();
        this.plotLesk();
        try {
            this.input1.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.input2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.output.close();
    }

    public static void main(String[] stringArray) {
        Suppose suppose = new Suppose();
        try {
            suppose.showHelp(false);
            suppose.parseArguments(stringArray);
            suppose.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            suppose.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println();
            System.err.println("*** I/O error: " + iOException.getMessage());
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Suppose.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Suppose.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.Suppose");
        System.err.println("Copyright (C) 2003 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        try {
            if (file.exists()) {
                if (this.input1 == null) {
                    this.file1 = file;
                    this.input1 = new BufferedInputStream(new FileInputStream(file));
                } else if (this.input2 == null) {
                    this.file2 = file;
                    this.input2 = new BufferedInputStream(new FileInputStream(file));
                } else {
                    this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
                }
            } else if (this.input1 != null && this.input2 != null) {
                this.output = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            } else {
                System.err.println("*** WARNING: file '" + file + "' was not found");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("*** WARNING: file '" + file + "' was not found");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-n")) {
            try {
                this.nResToSuperpos = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** '" + string2 + "' is not a number");
            }
        } else if (string.equals("-f")) {
            try {
                this.fracToSuperpos = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** '" + string2 + "' is not a number");
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    public static class SortItem
    implements Comparable {
        public Tuple3 ca1;
        public Tuple3 ca2;
        public double score;
        public String label;

        public SortItem(Tuple3 tuple3, Tuple3 tuple32, double d, String string) {
            this.ca1 = tuple3;
            this.ca2 = tuple32;
            this.score = d;
            this.label = string;
        }

        public int compareTo(Object object) {
            SortItem sortItem = (SortItem)object;
            if (this.score > sortItem.score) {
                return -1;
            }
            if (this.score < sortItem.score) {
                return 1;
            }
            return 0;
        }
    }
}

