/*
 * Decompiled with CFR 0.152.
 */
package driftwood.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class Strings {
    static final DecimalFormat df0 = new DecimalFormat("0");
    static final DecimalFormat df1 = new DecimalFormat("0.0");

    public static String justifyLeft(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.ensureCapacity(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String justifyRight(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.ensureCapacity(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public static String justifyCenter(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.ensureCapacity(n);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append(' ');
            if (++i >= n) continue;
            stringBuffer.insert(0, ' ');
        }
        return stringBuffer.toString();
    }

    public static String forceLeft(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(0, n);
        }
        if (n2 == n) {
            return string;
        }
        return Strings.justifyLeft(string, n);
    }

    public static String forceRight(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            return string.substring(n2 - n, n2);
        }
        if (n2 == n) {
            return string;
        }
        return Strings.justifyRight(string, n);
    }

    public static String formatMemory(long l) {
        if (l < 1000L) {
            return l + " b";
        }
        if (l < 10000L) {
            return df1.format((double)l / 1000.0) + " kb";
        }
        if (l < 1000000L) {
            return df0.format((double)l / 1000.0) + " kb";
        }
        if (l < 10000000L) {
            return df1.format((double)l / 1000000.0) + " Mb";
        }
        if (l < 1000000000L) {
            return df0.format((double)l / 1000000.0) + " Mb";
        }
        if (l < 10000000000L) {
            return df1.format((double)l / 1.0E9) + " Gb";
        }
        if (l < 1000000000000L) {
            return df0.format((double)l / 1.0E9) + " Gb";
        }
        if (l < 10000000000000L) {
            return df1.format((double)l / 1.0E12) + " Tb";
        }
        return df0.format((double)l / 1.0E12) + " Tb";
    }

    public static String[] tokenizeCommandLine(String string) {
        int n = 0;
        int n2 = string.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        char c = '\u0000';
        for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            if (c == '\'' || c == '\"') {
                if (c2 == c) {
                    arrayList.add(stringBuffer.toString());
                    stringBuffer = null;
                    c = '\u0000';
                    continue;
                }
                stringBuffer.append(c2);
                continue;
            }
            if (c2 == '\'' || c2 == '\"') {
                if (stringBuffer != null) {
                    arrayList.add(stringBuffer.toString());
                }
                stringBuffer = new StringBuffer();
                c = c2;
                continue;
            }
            if (Character.isWhitespace(c2)) {
                if (stringBuffer == null) continue;
                arrayList.add(stringBuffer.toString());
                stringBuffer = null;
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(c2);
        }
        if (stringBuffer != null) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static File jarUrlToFile(URL uRL) throws IOException {
        if (!uRL.getProtocol().equals("jar")) {
            throw new IllegalArgumentException("URL must be a jar: type URL");
        }
        JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
        if (!(uRL = jarURLConnection.getJarFileURL()).getProtocol().equals("file")) {
            throw new IllegalArgumentException("URL must be a jar:file: type URL");
        }
        File file = new File(URLDecoder.decode(uRL.getFile()));
        if (!file.exists()) {
            throw new IOException("Specified JAR file does not exist");
        }
        return file;
    }

    public static String[] explode(String string, char c, boolean bl, boolean bl2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.length();
        try {
            String string2;
            int n2 = -1;
            int n3 = string.indexOf(c);
            while (n3 < n && n3 != -1) {
                string2 = string.substring(n2 + 1, n3);
                if (bl2) {
                    string2 = string2.trim();
                }
                if (string2.length() != 0 || bl) {
                    arrayList.add(string2);
                }
                n2 = n3;
                n3 = string.indexOf(c, n3 + 1);
            }
            string2 = string.substring(n2 + 1);
            if (bl2) {
                string2 = string2.trim();
            }
            if (string2.length() != 0 || bl) {
                arrayList.add(string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] explode(String string, char c) {
        if (Character.isWhitespace(c)) {
            return Strings.explode(string, c, false, true);
        }
        return Strings.explode(string, c, true, false);
    }

    public static int[] explodeInts(String string, char c) throws NumberFormatException {
        String[] stringArray = Strings.explode(string, c, false, true);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    public static double[] explodeDoubles(String string, char c) throws NumberFormatException {
        String[] stringArray = Strings.explode(string, c, false, true);
        double[] dArray = new double[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            dArray[i] = Double.parseDouble(stringArray[i]);
        }
        return dArray;
    }

    public static String expandVariables(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = "{" + i + "}";
            int n = 0;
            while ((n = string.indexOf(string2, n)) != -1) {
                string = string.substring(0, n) + stringArray[i] + string.substring(n + string2.length());
            }
        }
        return string;
    }

    public static String expandVariables(String string, String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Length of keys[] and fillins[] must match");
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            String string2 = "{" + stringArray[i] + "}";
            int n = 0;
            while ((n = string.indexOf(string2, n)) != -1) {
                string = string.substring(0, n) + stringArray2[i] + string.substring(n + string2.length());
            }
        }
        return string;
    }

    public static int compareVersions(String string, String string2) {
        String[] stringArray = Strings.explode(string, '.');
        String[] stringArray2 = Strings.explode(string2, '.');
        int n = Math.max(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2;
            if (i > stringArray.length) {
                return -1;
            }
            if (i > stringArray2.length) {
                return 1;
            }
            try {
                int n3 = Integer.parseInt(stringArray[i]);
                n2 = Integer.parseInt(stringArray2[i]);
                if (n3 == n2) continue;
                return n3 - n2;
            }
            catch (NumberFormatException numberFormatException) {
                n2 = stringArray[i].compareTo(stringArray2[i]);
                if (n2 == 0) continue;
                return n2;
            }
        }
        return 0;
    }

    public static DecimalFormat usDecimalFormat(String string) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.US);
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            decimalFormat.applyPattern(string);
            return decimalFormat;
        }
        return new DecimalFormat(string);
    }
}

