/*
 * Decompiled with CFR 0.152.
 */
package jiffiloop;

import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Tuple3;
import java.text.DecimalFormat;
import java.util.ArrayList;
import jiffiloop.Framer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProteinGap {
    static final DecimalFormat df = new DecimalFormat("0.000");
    Residue zeroRes;
    Residue oneRes;
    Residue nRes;
    Residue n1Res;
    ArrayList<AtomState> states;
    ArrayList<Double> frame;
    String sourceModName;
    String sourceChain;

    public ProteinGap(Model model, String string, Residue residue, Residue residue2, Residue residue3, Residue residue4) {
        this.sourceModName = model.getName();
        this.sourceChain = string;
        ModelState modelState = model.getState();
        this.zeroRes = residue;
        this.oneRes = residue2;
        this.nRes = residue3;
        this.n1Res = residue4;
        try {
            AtomState atomState = modelState.get(this.zeroRes.getAtom(" CA "));
            AtomState atomState2 = modelState.get(this.oneRes.getAtom(" CA "));
            AtomState atomState3 = modelState.get(this.nRes.getAtom(" CA "));
            AtomState atomState4 = modelState.get(this.n1Res.getAtom(" CA "));
            AtomState atomState5 = modelState.get(this.zeroRes.getAtom(" O  "));
            AtomState atomState6 = modelState.get(this.nRes.getAtom(" O  "));
            this.states = new ArrayList();
            this.states.add(atomState);
            this.states.add(atomState2);
            this.states.add(atomState3);
            this.states.add(atomState4);
            this.states.add(atomState5);
            this.states.add(atomState6);
            this.frame = Framer.calphaAnalyzeList(atomState, atomState2, atomState3, atomState4, atomState5, atomState6);
        }
        catch (AtomException atomException) {
            System.err.println("Problem with atom " + atomException.getMessage());
        }
    }

    public ArrayList<Double> getParameters() {
        return this.frame;
    }

    public ArrayList<AtomState> getAtomStates() {
        return this.states;
    }

    public int getSize() {
        return this.nRes.getSequenceInteger() - this.oneRes.getSequenceInteger();
    }

    public int getOneNum() {
        return this.oneRes.getSequenceInteger();
    }

    public int getNNum() {
        return this.nRes.getSequenceInteger();
    }

    public String getSourceString() {
        return (this.sourceModName + this.sourceChain).trim();
    }

    public Tuple3[] getTupleArray() {
        Tuple3[] tuple3Array = new Tuple3[]{this.states.get(0), this.states.get(1), this.states.get(2), this.states.get(3)};
        return tuple3Array;
    }

    public Tuple3[] getNtermTuples() {
        Tuple3[] tuple3Array = new Tuple3[]{this.states.get(0), this.states.get(4), this.states.get(1)};
        return tuple3Array;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ProteinGap)) {
            return false;
        }
        ProteinGap proteinGap = (ProteinGap)object;
        return this.frame.equals(proteinGap.getParameters()) && this.states.equals(proteinGap.getAtomStates());
    }

    public int hashCode() {
        return this.frame.hashCode() ^ this.states.hashCode();
    }
}

