#!/usr/bin/perl
##################################################################################################################################################
#ProbingPROBE Script
#Gary Kapral 4/11/05
#For use with PROBE unformatted data
#The variables are as follows:
#$name = title of probe data	$pat = interaction type e.g., "1-->2"	$type = type of interaction e.g., hb or "H-bond"
#$srcAtom = source atom	$targAtom = target atom	$mingap = minimum gap b/t atoms
#$gap = distance b/t atom centers	$spX, $spY, $spZ = coordinates in space of spike	$spikLen = length of spike
#$score = score assigned by probe	$stype = starting atom type	$ttype = target atom type
#$x, $y, $z = coordinates in space of spike	$sBval, $tBval = values attached to starting and target atoms
#This program allows a search of user-specified interactions between 2 atoms. The results are shown in tabular form with info
#on the type of bond interaction, source and target atoms, and the number of dots generated by probe to represent the interaction
#
# IWD 3 Nov 05: Modified for use with MolProbity.
#   Now uses stdin/stdout and does all bonds passed in.
#   Bond types can be selected during Probe cmd setup.
##################################################################################################################################################

$count = 0;								#initialize the count 
$tracker = 0;

while ($line = <STDIN>) {						#create a loop to cycle through each line of the input file
    ($name, $pat, $type, $srcAtom, $targAtom, $mingap, $gap, $spX, $spY, $spZ, $spikeLen, $score, $stype, $ttype ,$x ,$y ,$z, $sBval, $tBval) = split(":", $line); 	#splits the matched lines by colons into vars
  	
    
    
    $alist{$srcAtom} .= $targAtom .":    $type    ;\t";		#if all the criteria matches, store in a hash
}


#sort the keys in %dist and split by colon into an array, then print the starting atom and its reference in the hash dist

#print "Results For All Contacts\n";
foreach $srcAtom (sort keys %alist) {					#sort and print the src and targ atoms with the number of dots and area
    $number = 0;
    @alist = split("\t", $alist{$srcAtom});
    
    
    foreach $targAtom (@alist) {
        $number++;
        $tracker++;
    }
    
    %seen = ();
    @uniq = ();
    
    foreach $targAtom (@alist) {
        unless ($seen{$targAtom}) {
            $seen{$targAtom} = 1;
            push(@uniq, $targAtom);
            
        }
    }
    
    $number = $number-1;
    $array{$numberfile} .= $number ."\t";
    @array = split("\t", $array{$numberfile});
    $total = $array[$count];
    $Area = $total / 16;
    print "\n$srcAtom : @uniq : Dots = $number : Area covered =  $Area sq A\n";
    $count++;
}
