/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.attachment;

import java.io.InputStream;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.SignalWebSocket;
import org.whispersystems.signalservice.api.attachment.AttachmentApi;
import org.whispersystems.signalservice.api.attachment.AttachmentUploadResult;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentStream;
import org.whispersystems.signalservice.internal.crypto.AttachmentDigest;
import org.whispersystems.signalservice.internal.crypto.PaddingInputStream;
import org.whispersystems.signalservice.internal.push.AttachmentUploadForm;
import org.whispersystems.signalservice.internal.push.PushAttachmentData;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.push.http.AttachmentCipherOutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.CancelationSignal;
import org.whispersystems.signalservice.internal.push.http.OutputStreamFactory;
import org.whispersystems.signalservice.internal.push.http.ResumableUploadSpec;
import org.whispersystems.signalservice.internal.websocket.WebSocketRequestMessage;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\tJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/whispersystems/signalservice/api/attachment/AttachmentApi;", "", "signalWebSocket", "Lorg/whispersystems/signalservice/api/SignalWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "(Lorg/whispersystems/signalservice/api/SignalWebSocket;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "getAttachmentV4UploadForm", "Lorg/whispersystems/signalservice/api/NetworkResult;", "Lorg/whispersystems/signalservice/internal/push/AttachmentUploadForm;", "getResumableUploadSpec", "Lorg/whispersystems/signalservice/internal/push/http/ResumableUploadSpec;", "key", "", "iv", "uploadForm", "getResumableUploadUrl", "", "uploadAttachmentV4", "Lorg/whispersystems/signalservice/api/attachment/AttachmentUploadResult;", "attachmentStream", "Lorg/whispersystems/signalservice/api/messages/SignalServiceAttachmentStream;", "Companion", "signal-service-java"})
public final class AttachmentApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SignalWebSocket signalWebSocket;
    @NotNull
    private final PushServiceSocket pushServiceSocket;

    public AttachmentApi(@NotNull SignalWebSocket signalWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.signalWebSocket = signalWebSocket;
        this.pushServiceSocket = pushServiceSocket;
    }

    @NotNull
    public final NetworkResult<AttachmentUploadForm> getAttachmentV4UploadForm() {
        long l = new SecureRandom().nextLong();
        WebSocketRequestMessage request = new WebSocketRequestMessage("GET", "/v4/attachments/form/upload", null, null, l, null, 44, null);
        return NetworkResult.Companion.fromWebSocketRequest(this.signalWebSocket, request, Reflection.getOrCreateKotlinClass(AttachmentUploadForm.class)).fallbackToFetch(getAttachmentV4UploadForm.1.INSTANCE, () -> AttachmentApi.getAttachmentV4UploadForm$lambda$0(this));
    }

    @NotNull
    public final NetworkResult<ResumableUploadSpec> getResumableUploadSpec(@NotNull byte[] key, @NotNull byte[] iv, @NotNull AttachmentUploadForm uploadForm) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)uploadForm, (String)"uploadForm");
        return this.getResumableUploadUrl(uploadForm).map((Function1)new Function1<String, ResumableUploadSpec>(key, iv, uploadForm){
            final /* synthetic */ byte[] $key;
            final /* synthetic */ byte[] $iv;
            final /* synthetic */ AttachmentUploadForm $uploadForm;
            {
                this.$key = $key;
                this.$iv = $iv;
                this.$uploadForm = $uploadForm;
                super(1);
            }

            @NotNull
            public final ResumableUploadSpec invoke(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new ResumableUploadSpec(this.$key, this.$iv, this.$uploadForm.key, this.$uploadForm.cdn, url, System.currentTimeMillis() + PushServiceSocket.CDN2_RESUMABLE_LINK_LIFETIME_MILLIS, this.$uploadForm.headers);
            }
        });
    }

    @NotNull
    public final NetworkResult<AttachmentUploadResult> uploadAttachmentV4(@NotNull SignalServiceAttachmentStream attachmentStream) {
        Intrinsics.checkNotNullParameter((Object)attachmentStream, (String)"attachmentStream");
        if (attachmentStream.getResumableUploadSpec().isEmpty()) {
            throw new IllegalStateException("Attachment must have a resumable upload spec!");
        }
        return NetworkResult.Companion.fromFetch(() -> AttachmentApi.uploadAttachmentV4$lambda$1(attachmentStream, this));
    }

    private final NetworkResult<String> getResumableUploadUrl(AttachmentUploadForm uploadForm) {
        return NetworkResult.Companion.fromFetch(() -> AttachmentApi.getResumableUploadUrl$lambda$2(this, uploadForm));
    }

    private static final AttachmentUploadForm getAttachmentV4UploadForm$lambda$0(AttachmentApi this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AttachmentUploadForm attachmentUploadForm = this$0.pushServiceSocket.getAttachmentV4UploadAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attachmentUploadForm, (String)"getAttachmentV4UploadAttributes(...)");
        return attachmentUploadForm;
    }

    private static final AttachmentUploadResult uploadAttachmentV4$lambda$1(SignalServiceAttachmentStream $attachmentStream, AttachmentApi this$0) {
        Intrinsics.checkNotNullParameter((Object)$attachmentStream, (String)"$attachmentStream");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ResumableUploadSpec resumableUploadSpec = $attachmentStream.getResumableUploadSpec().get();
        Intrinsics.checkNotNullExpressionValue((Object)resumableUploadSpec, (String)"get(...)");
        ResumableUploadSpec resumableUploadSpec2 = resumableUploadSpec;
        long paddedLength = PaddingInputStream.getPaddedSize($attachmentStream.getLength());
        InputStream dataStream = new PaddingInputStream($attachmentStream.getInputStream(), $attachmentStream.getLength());
        long ciphertextLength = AttachmentCipherStreamUtil.getCiphertextLength(paddedLength);
        String string = $attachmentStream.getContentType();
        boolean bl = $attachmentStream.isFaststart();
        OutputStreamFactory outputStreamFactory = new AttachmentCipherOutputStreamFactory(resumableUploadSpec2.getAttachmentKey(), resumableUploadSpec2.getAttachmentIv());
        SignalServiceAttachment.ProgressListener progressListener = $attachmentStream.getListener();
        CancelationSignal cancelationSignal = $attachmentStream.getCancelationSignal();
        ResumableUploadSpec resumableUploadSpec3 = $attachmentStream.getResumableUploadSpec().get();
        Intrinsics.checkNotNullExpressionValue((Object)resumableUploadSpec3, (String)"get(...)");
        PushAttachmentData attachmentData = new PushAttachmentData(string, dataStream, ciphertextLength, bl, outputStreamFactory, progressListener, cancelationSignal, resumableUploadSpec3);
        AttachmentDigest digestInfo = this$0.pushServiceSocket.uploadAttachment(attachmentData);
        SignalServiceAttachmentRemoteId.V4 v4 = new SignalServiceAttachmentRemoteId.V4(attachmentData.getResumableUploadSpec().getCdnKey());
        int n = attachmentData.getResumableUploadSpec().getCdnNumber();
        byte[] byArray = resumableUploadSpec2.getAttachmentKey();
        byte[] byArray2 = resumableUploadSpec2.getAttachmentIv();
        byte[] byArray3 = digestInfo.getDigest();
        byte[] byArray4 = digestInfo.getIncrementalDigest();
        int n2 = digestInfo.getIncrementalMacChunkSize();
        long l = $attachmentStream.getUploadTimestamp();
        long l2 = $attachmentStream.getLength();
        return new AttachmentUploadResult(v4, n, byArray, byArray2, byArray3, byArray4, n2, l2, l);
    }

    private static final String getResumableUploadUrl$lambda$2(AttachmentApi this$0, AttachmentUploadForm $uploadForm) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$uploadForm, (String)"$uploadForm");
        String string = this$0.pushServiceSocket.getResumableUploadUrl($uploadForm);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getResumableUploadUrl(...)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final AttachmentApi create(@NotNull SignalWebSocket signalWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
        return Companion.create(signalWebSocket, pushServiceSocket);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/api/attachment/AttachmentApi$Companion;", "", "()V", "create", "Lorg/whispersystems/signalservice/api/attachment/AttachmentApi;", "signalWebSocket", "Lorg/whispersystems/signalservice/api/SignalWebSocket;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AttachmentApi create(@NotNull SignalWebSocket signalWebSocket, @NotNull PushServiceSocket pushServiceSocket) {
            Intrinsics.checkNotNullParameter((Object)signalWebSocket, (String)"signalWebSocket");
            Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
            return new AttachmentApi(signalWebSocket, pushServiceSocket);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

