/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.storage;

import com.squareup.wire.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import okio.ByteString;
import org.signal.core.util.ProtoUtil;
import org.signal.libsignal.protocol.logging.Log;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.whispersystems.signalservice.api.storage.SignalRecord;
import org.whispersystems.signalservice.api.storage.SignalStorageRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.GroupV2Record;

public final class SignalGroupV2Record
implements SignalRecord {
    private static final String TAG = SignalGroupV2Record.class.getSimpleName();
    private final StorageId id;
    private final GroupV2Record proto;
    private final byte[] masterKey;
    private final boolean hasUnknownFields;

    public SignalGroupV2Record(StorageId id, GroupV2Record proto) {
        this.id = id;
        this.proto = proto;
        this.hasUnknownFields = ProtoUtil.hasUnknownFields((Message)proto);
        this.masterKey = proto.masterKey.toByteArray();
    }

    @Override
    public StorageId getId() {
        return this.id;
    }

    @Override
    public SignalStorageRecord asStorageRecord() {
        return SignalStorageRecord.forGroupV2(this);
    }

    @Override
    public String describeDiff(SignalRecord other) {
        if (other instanceof SignalGroupV2Record) {
            SignalGroupV2Record that = (SignalGroupV2Record)other;
            LinkedList<String> diff = new LinkedList<String>();
            if (!Arrays.equals(this.id.getRaw(), that.id.getRaw())) {
                diff.add("ID");
            }
            if (!Arrays.equals(this.getMasterKeyBytes(), that.getMasterKeyBytes())) {
                diff.add("MasterKey");
            }
            if (!Objects.equals(this.isBlocked(), that.isBlocked())) {
                diff.add("Blocked");
            }
            if (!Objects.equals(this.isProfileSharingEnabled(), that.isProfileSharingEnabled())) {
                diff.add("ProfileSharing");
            }
            if (!Objects.equals(this.isArchived(), that.isArchived())) {
                diff.add("Archived");
            }
            if (!Objects.equals(this.isForcedUnread(), that.isForcedUnread())) {
                diff.add("ForcedUnread");
            }
            if (!Objects.equals(this.getMuteUntil(), that.getMuteUntil())) {
                diff.add("MuteUntil");
            }
            if (!Objects.equals(this.notifyForMentionsWhenMuted(), that.notifyForMentionsWhenMuted())) {
                diff.add("NotifyForMentionsWhenMuted");
            }
            if (this.shouldHideStory() != that.shouldHideStory()) {
                diff.add("HideStory");
            }
            if (!Objects.equals((Object)this.getStorySendMode(), (Object)that.getStorySendMode())) {
                diff.add("StorySendMode");
            }
            if (!Objects.equals(this.hasUnknownFields(), that.hasUnknownFields())) {
                diff.add("UnknownFields");
            }
            return ((Object)diff).toString();
        }
        return "Different class. " + this.getClass().getSimpleName() + " | " + other.getClass().getSimpleName();
    }

    public boolean hasUnknownFields() {
        return this.hasUnknownFields;
    }

    public byte[] serializeUnknownFields() {
        return this.hasUnknownFields ? this.proto.encode() : null;
    }

    public byte[] getMasterKeyBytes() {
        return this.masterKey;
    }

    public GroupMasterKey getMasterKeyOrThrow() {
        try {
            return new GroupMasterKey(this.masterKey);
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isBlocked() {
        return this.proto.blocked;
    }

    public boolean isProfileSharingEnabled() {
        return this.proto.whitelisted;
    }

    public boolean isArchived() {
        return this.proto.archived;
    }

    public boolean isForcedUnread() {
        return this.proto.markedUnread;
    }

    public long getMuteUntil() {
        return this.proto.mutedUntilTimestamp;
    }

    public boolean notifyForMentionsWhenMuted() {
        return !this.proto.dontNotifyForMentionsIfMuted;
    }

    public boolean shouldHideStory() {
        return this.proto.hideStory;
    }

    public GroupV2Record.StorySendMode getStorySendMode() {
        return this.proto.storySendMode;
    }

    public GroupV2Record toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignalGroupV2Record that = (SignalGroupV2Record)o;
        return this.id.equals(that.id) && this.proto.equals((Object)that.proto);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.proto});
    }

    public static final class Builder {
        private StorageId id;
        private final GroupV2Record.Builder builder;

        public Builder(byte[] rawId, GroupMasterKey masterKey, byte[] serializedUnknowns) {
            this(rawId, masterKey.serialize(), serializedUnknowns);
        }

        public Builder(byte[] rawId, byte[] masterKey, byte[] serializedUnknowns) {
            this.id = StorageId.forGroupV2(rawId);
            this.builder = serializedUnknowns != null ? Builder.parseUnknowns(serializedUnknowns) : new GroupV2Record.Builder();
            this.builder.masterKey(ByteString.of((byte[])masterKey));
        }

        public Builder setId(byte[] rawId) {
            this.id = StorageId.forGroupV2(rawId);
            return this;
        }

        public Builder setBlocked(boolean blocked) {
            this.builder.blocked(blocked);
            return this;
        }

        public Builder setProfileSharingEnabled(boolean profileSharingEnabled) {
            this.builder.whitelisted(profileSharingEnabled);
            return this;
        }

        public Builder setArchived(boolean archived) {
            this.builder.archived(archived);
            return this;
        }

        public Builder setForcedUnread(boolean forcedUnread) {
            this.builder.markedUnread(forcedUnread);
            return this;
        }

        public Builder setMuteUntil(long muteUntil) {
            this.builder.mutedUntilTimestamp(muteUntil);
            return this;
        }

        public Builder setNotifyForMentionsWhenMuted(boolean value) {
            this.builder.dontNotifyForMentionsIfMuted(!value);
            return this;
        }

        public Builder setHideStory(boolean hideStory) {
            this.builder.hideStory(hideStory);
            return this;
        }

        public Builder setStorySendMode(GroupV2Record.StorySendMode storySendMode) {
            this.builder.storySendMode(storySendMode);
            return this;
        }

        private static GroupV2Record.Builder parseUnknowns(byte[] serializedUnknowns) {
            try {
                return ((GroupV2Record)((Object)GroupV2Record.ADAPTER.decode(serializedUnknowns))).newBuilder();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to combine unknown fields!", (Throwable)e);
                return new GroupV2Record.Builder();
            }
        }

        public SignalGroupV2Record build() {
            return new SignalGroupV2Record(this.id, this.builder.build());
        }
    }
}

