/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.util;

import java.io.IOException;

public class Hex {
    private static final int HEX_DIGITS_START = 10;
    private static final int ASCII_TEXT_START = 50;
    static final String EOL = System.getProperty("line.separator");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toString(byte[] bytes) {
        return Hex.toString(bytes, 0, bytes.length);
    }

    public static String toString(byte[] bytes, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            Hex.appendHexChar(buf, bytes[offset + i]);
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String toStringCondensed(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            Hex.appendHexChar(buf, bytes[i]);
        }
        return buf.toString();
    }

    public static byte[] fromStringCondensed(String encoded) throws IOException {
        char[] data = encoded.toCharArray();
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IOException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = Character.digit(data[j], 16) << 4;
            f |= Character.digit(data[++j], 16);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static String dump(byte[] bytes) {
        return Hex.dump(bytes, 0, bytes.length);
    }

    public static String dump(byte[] bytes, int offset, int length) {
        StringBuffer buf = new StringBuffer();
        int lines = (length - 1) / 16 + 1;
        for (int i = 0; i < lines; ++i) {
            int lineOffset = i * 16 + offset;
            int lineLength = Math.min(16, length - i * 16);
            Hex.appendDumpLine(buf, i, bytes, lineOffset, lineLength);
            buf.append(EOL);
        }
        return buf.toString();
    }

    private static void appendDumpLine(StringBuffer buf, int line, byte[] bytes, int lineOffset, int lineLength) {
        byte b;
        int idx;
        int i;
        buf.append(HEX_DIGITS[line >> 28 & 0xF]);
        buf.append(HEX_DIGITS[line >> 24 & 0xF]);
        buf.append(HEX_DIGITS[line >> 20 & 0xF]);
        buf.append(HEX_DIGITS[line >> 16 & 0xF]);
        buf.append(HEX_DIGITS[line >> 12 & 0xF]);
        buf.append(HEX_DIGITS[line >> 8 & 0xF]);
        buf.append(HEX_DIGITS[line >> 4 & 0xF]);
        buf.append(HEX_DIGITS[line & 0xF]);
        buf.append(": ");
        for (i = 0; i < 16; ++i) {
            idx = i + lineOffset;
            if (i < lineLength) {
                b = bytes[idx];
                Hex.appendHexChar(buf, b);
            } else {
                buf.append("  ");
            }
            if (i % 2 != 1) continue;
            buf.append(' ');
        }
        for (i = 0; i < 16 && i < lineLength; ++i) {
            idx = i + lineOffset;
            b = bytes[idx];
            if (b >= 32 && b <= 126) {
                buf.append((char)b);
                continue;
            }
            buf.append('.');
        }
    }

    private static void appendHexChar(StringBuffer buf, int b) {
        buf.append(HEX_DIGITS[b >> 4 & 0xF]);
        buf.append(HEX_DIGITS[b & 0xF]);
    }
}

