/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.Channels;
import java.util.List;
import java.util.function.Supplier;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentType;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.OutputType;
import org.asamk.signal.Shutdown;
import org.asamk.signal.commands.LocalCommand;
import org.asamk.signal.commands.MultiLocalCommand;
import org.asamk.signal.commands.ReceiveMode;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.jsonrpc.SignalJsonRpcDispatcherHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;
import org.asamk.signal.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcDispatcherCommand
implements LocalCommand,
MultiLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(JsonRpcDispatcherCommand.class);

    @Override
    public String getName() {
        return "jsonRpc";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Take commands from standard input as line-delimited JSON RPC while receiving messages.");
        subparser.addArgument(new String[]{"--ignore-attachments"}).help("Don\u2019t download attachments of received messages.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--ignore-stories"}).help("Don\u2019t receive story messages from the server.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--send-read-receipts"}).help("Send read receipts for all incoming data messages (in addition to the default delivery receipts)").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--receive-mode"}).help("Specify when to start receiving messages.").type((ArgumentType)Arguments.enumStringType(ReceiveMode.class)).setDefault((Object)ReceiveMode.ON_START);
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.JSON);
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        Shutdown.installHandler();
        ReceiveMode receiveMode = (ReceiveMode)((Object)ns.get("receive-mode"));
        ReceiveConfig receiveConfig = CommandUtil.getReceiveConfig(ns);
        m.setReceiveConfig(receiveConfig);
        JsonWriter jsonOutputWriter = (JsonWriter)outputWriter;
        Supplier<String> lineSupplier = JsonRpcDispatcherCommand.getLineSupplier();
        SignalJsonRpcDispatcherHandler handler = new SignalJsonRpcDispatcherHandler(jsonOutputWriter, lineSupplier, receiveMode == ReceiveMode.MANUAL);
        Thread thread = Thread.currentThread();
        Shutdown.registerShutdownListener(thread::interrupt);
        handler.handleConnection(m);
    }

    @Override
    public void handleCommand(Namespace ns, MultiAccountManager c, OutputWriter outputWriter) throws CommandException {
        Shutdown.installHandler();
        ReceiveMode receiveMode = (ReceiveMode)((Object)ns.get("receive-mode"));
        ReceiveConfig receiveConfig = CommandUtil.getReceiveConfig(ns);
        c.getManagers().forEach(m -> m.setReceiveConfig(receiveConfig));
        c.addOnManagerAddedHandler(m -> m.setReceiveConfig(receiveConfig));
        JsonWriter jsonOutputWriter = (JsonWriter)outputWriter;
        Supplier<String> lineSupplier = JsonRpcDispatcherCommand.getLineSupplier();
        SignalJsonRpcDispatcherHandler handler = new SignalJsonRpcDispatcherHandler(jsonOutputWriter, lineSupplier, receiveMode == ReceiveMode.MANUAL);
        Thread thread = Thread.currentThread();
        Shutdown.registerShutdownListener(thread::interrupt);
        handler.handleConnection(c);
    }

    private static Supplier<String> getLineSupplier() {
        InputStream stdInCh = Channels.newInputStream(new FileInputStream(FileDescriptor.in).getChannel());
        return IOUtils.getLineSupplier(new InputStreamReader(stdInCh, IOUtils.getConsoleCharset()));
    }
}

