/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.Device;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDevicesCommand
implements JsonRpcLocalCommand {
    private static final Logger logger = LoggerFactory.getLogger(ListDevicesCommand.class);

    @Override
    public String getName() {
        return "listDevices";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Show a list of linked devices.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        List devices;
        try {
            devices = m.getLinkedDevices();
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to get linked devices: " + e.getMessage(), e);
        }
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                for (Device d2 : devices) {
                    writer.println("- Device {}{}:", d2.id(), d2.isThisDevice() ? " (this device)" : "");
                    writer.indent(w -> {
                        w.println("Name: {}", d2.name());
                        w.println("Created: {}", DateUtils.formatTimestamp(d2.created()));
                        w.println("Last seen: {}", DateUtils.formatTimestamp(d2.lastSeen()));
                    });
                }
                break;
            }
            case 1: {
                JsonWriter writer = (JsonWriter)outputWriter3;
                List<JsonDevice> jsonDevices = devices.stream().map(d -> new JsonDevice(d.id(), d.name(), d.created(), d.lastSeen())).toList();
                writer.write(jsonDevices);
            }
        }
    }

    private record JsonDevice(long id, String name, long createdTimestamp, long lastSeenTimestamp) {
    }
}

