/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.ecc;

import java.util.Arrays;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;

public class ECPublicKey
implements Comparable<ECPublicKey>,
NativeHandleGuard.Owner {
    public static final int KEY_SIZE = 33;
    private final long unsafeHandle;

    public ECPublicKey(byte[] serialized, int offset) throws InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.ECPublicKey_Deserialize(serialized, offset));
    }

    public ECPublicKey(byte[] serialized) throws InvalidKeyException {
        this.unsafeHandle = FilterExceptions.filterExceptions(InvalidKeyException.class, () -> Native.ECPublicKey_Deserialize(serialized, 0));
    }

    public static ECPublicKey fromPublicKeyBytes(byte[] key) throws InvalidKeyException {
        if (key.length != 32) {
            throw new InvalidKeyException("invalid number of public key bytes (expected 32, was " + key.length + ")");
        }
        byte[] with_type = new byte[33];
        with_type[0] = 5;
        System.arraycopy(key, 0, with_type, 1, 32);
        return new ECPublicKey(FilterExceptions.filterExceptions(() -> Native.ECPublicKey_Deserialize(with_type, 0)));
    }

    public ECPublicKey(long nativeHandle) {
        if (nativeHandle == 0L) {
            throw new NullPointerException();
        }
        this.unsafeHandle = nativeHandle;
    }

    protected void finalize() {
        Native.ECPublicKey_Destroy(this.unsafeHandle);
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            boolean bl = FilterExceptions.filterExceptions(() -> Native.ECPublicKey_Verify(guard.nativeHandle(), message, signature));
            return bl;
        }
    }

    public byte[] serialize() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPublicKey_Serialize(guard.nativeHandle()));
            return byArray;
        }
    }

    public byte[] getPublicKeyBytes() {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            byte[] byArray = FilterExceptions.filterExceptions(() -> Native.ECPublicKey_GetPublicKeyBytes(guard.nativeHandle()));
            return byArray;
        }
    }

    public int getType() {
        byte[] serialized = this.serialize();
        return serialized[0];
    }

    @Override
    public long unsafeNativeHandleWithoutGuard() {
        return this.unsafeHandle;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ECPublicKey)) {
            return false;
        }
        try (NativeHandleGuard thisGuard = new NativeHandleGuard(this);){
            NativeHandleGuard thatGuard = new NativeHandleGuard((ECPublicKey)other);
            try {
                boolean bl = Native.ECPublicKey_Equals(thisGuard.nativeHandle(), thatGuard.nativeHandle());
                thatGuard.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    thatGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.serialize());
    }

    @Override
    public int compareTo(ECPublicKey another) {
        try (NativeHandleGuard guard = new NativeHandleGuard(this);){
            NativeHandleGuard otherGuard = new NativeHandleGuard(another);
            try {
                int n = Native.ECPublicKey_Compare(guard.nativeHandle(), otherGuard.nativeHandle());
                otherGuard.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    otherGuard.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

