/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.asamk.signal.manager.api.AlreadyReceivingException;
import org.asamk.signal.manager.api.AttachmentInvalidException;
import org.asamk.signal.manager.api.CaptchaRejectedException;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.Configuration;
import org.asamk.signal.manager.api.Device;
import org.asamk.signal.manager.api.DeviceLimitExceededException;
import org.asamk.signal.manager.api.DeviceLinkUrl;
import org.asamk.signal.manager.api.Group;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.GroupNotFoundException;
import org.asamk.signal.manager.api.GroupSendingNotAllowedException;
import org.asamk.signal.manager.api.Identity;
import org.asamk.signal.manager.api.IdentityVerificationCode;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.InvalidDeviceLinkException;
import org.asamk.signal.manager.api.InvalidStickerException;
import org.asamk.signal.manager.api.InvalidUsernameException;
import org.asamk.signal.manager.api.LastGroupAdminException;
import org.asamk.signal.manager.api.Message;
import org.asamk.signal.manager.api.MessageEnvelope;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.NotAGroupMemberException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PendingAdminApprovalException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.Recipient;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.manager.api.SendMessageResults;
import org.asamk.signal.manager.api.StickerPack;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.api.StickerPackInvalidException;
import org.asamk.signal.manager.api.StickerPackUrl;
import org.asamk.signal.manager.api.TypingAction;
import org.asamk.signal.manager.api.UnregisteredRecipientException;
import org.asamk.signal.manager.api.UpdateGroup;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.manager.api.UserStatus;
import org.asamk.signal.manager.api.UsernameLinkUrl;
import org.asamk.signal.manager.api.UsernameStatus;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.signal.libsignal.internal.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.util.PhoneNumberFormatter;

public interface Manager
extends Closeable {
    public static boolean isValidNumber(String e164Number, String countryCode) {
        return PhoneNumberFormatter.isValidNumber((String)e164Number, (String)countryCode);
    }

    public static boolean isSignalClientAvailable() {
        Logger logger = LoggerFactory.getLogger(Manager.class);
        try {
            try {
                Native.UuidCiphertext_CheckValidContents((byte[])new byte[0]);
            }
            catch (Exception e) {
                logger.trace("Expected exception when checking libsignal-client: {}", (Object)e.getMessage());
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("Failed to call libsignal-client: {}", (Object)e.getMessage());
            return false;
        }
    }

    public String getSelfNumber();

    public Map<String, UserStatus> getUserStatus(Set<String> var1) throws IOException, RateLimitException;

    public Map<String, UsernameStatus> getUsernameStatus(Set<String> var1);

    public void updateAccountAttributes(String var1, Boolean var2, Boolean var3, Boolean var4) throws IOException;

    public Configuration getConfiguration();

    public void updateConfiguration(Configuration var1) throws NotPrimaryDeviceException;

    public void updateProfile(UpdateProfile var1) throws IOException;

    public String getUsername();

    public UsernameLinkUrl getUsernameLink();

    public void setUsername(String var1) throws IOException, InvalidUsernameException;

    public void deleteUsername() throws IOException;

    public void startChangeNumber(String var1, boolean var2, String var3) throws RateLimitException, IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException, NotPrimaryDeviceException, VerificationMethodNotAvailableException;

    public void finishChangeNumber(String var1, String var2, String var3) throws IncorrectPinException, PinLockedException, IOException, NotPrimaryDeviceException;

    public void unregister() throws IOException;

    public void deleteAccount() throws IOException;

    public void submitRateLimitRecaptchaChallenge(String var1, String var2) throws IOException, CaptchaRejectedException;

    public List<Device> getLinkedDevices() throws IOException;

    public void removeLinkedDevices(int var1) throws IOException, NotPrimaryDeviceException;

    public void addDeviceLink(DeviceLinkUrl var1) throws IOException, InvalidDeviceLinkException, NotPrimaryDeviceException, DeviceLimitExceededException;

    public void setRegistrationLockPin(Optional<String> var1) throws IOException, NotPrimaryDeviceException;

    public List<Group> getGroups();

    public SendGroupMessageResults quitGroup(GroupId var1, Set<RecipientIdentifier.Single> var2) throws GroupNotFoundException, IOException, NotAGroupMemberException, LastGroupAdminException, UnregisteredRecipientException;

    public void deleteGroup(GroupId var1) throws IOException;

    public Pair<GroupId, SendGroupMessageResults> createGroup(String var1, Set<RecipientIdentifier.Single> var2, String var3) throws IOException, AttachmentInvalidException, UnregisteredRecipientException;

    public SendGroupMessageResults updateGroup(GroupId var1, UpdateGroup var2) throws IOException, GroupNotFoundException, AttachmentInvalidException, NotAGroupMemberException, GroupSendingNotAllowedException, UnregisteredRecipientException;

    public Pair<GroupId, SendGroupMessageResults> joinGroup(GroupInviteLinkUrl var1) throws IOException, InactiveGroupLinkException, PendingAdminApprovalException;

    public SendMessageResults sendTypingMessage(TypingAction var1, Set<RecipientIdentifier> var2) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException;

    public SendMessageResults sendReadReceipt(RecipientIdentifier.Single var1, List<Long> var2);

    public SendMessageResults sendViewedReceipt(RecipientIdentifier.Single var1, List<Long> var2);

    public SendMessageResults sendMessage(Message var1, Set<RecipientIdentifier> var2, boolean var3) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException, InvalidStickerException;

    public SendMessageResults sendEditMessage(Message var1, Set<RecipientIdentifier> var2, long var3) throws IOException, AttachmentInvalidException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException, InvalidStickerException;

    public SendMessageResults sendRemoteDeleteMessage(long var1, Set<RecipientIdentifier> var3) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException;

    public SendMessageResults sendMessageReaction(String var1, boolean var2, RecipientIdentifier.Single var3, long var4, Set<RecipientIdentifier> var6, boolean var7) throws IOException, NotAGroupMemberException, GroupNotFoundException, GroupSendingNotAllowedException, UnregisteredRecipientException;

    public SendMessageResults sendPaymentNotificationMessage(byte[] var1, String var2, RecipientIdentifier.Single var3) throws IOException;

    public SendMessageResults sendEndSessionMessage(Set<RecipientIdentifier.Single> var1) throws IOException;

    public SendMessageResults sendMessageRequestResponse(MessageEnvelope.Sync.MessageRequestResponse.Type var1, Set<RecipientIdentifier> var2);

    public void hideRecipient(RecipientIdentifier.Single var1);

    public void deleteRecipient(RecipientIdentifier.Single var1);

    public void deleteContact(RecipientIdentifier.Single var1);

    public void setContactName(RecipientIdentifier.Single var1, String var2, String var3) throws NotPrimaryDeviceException, UnregisteredRecipientException;

    public void setContactsBlocked(Collection<RecipientIdentifier.Single> var1, boolean var2) throws NotPrimaryDeviceException, IOException, UnregisteredRecipientException;

    public void setGroupsBlocked(Collection<GroupId> var1, boolean var2) throws GroupNotFoundException, IOException, NotPrimaryDeviceException;

    public void setExpirationTimer(RecipientIdentifier.Single var1, int var2) throws IOException, UnregisteredRecipientException;

    public StickerPackUrl uploadStickerPack(File var1) throws IOException, StickerPackInvalidException;

    public void installStickerPack(StickerPackUrl var1) throws IOException;

    public List<StickerPack> getStickerPacks();

    public void requestAllSyncData() throws IOException;

    default public void addReceiveHandler(ReceiveMessageHandler handler) {
        this.addReceiveHandler(handler, false);
    }

    public void addReceiveHandler(ReceiveMessageHandler var1, boolean var2);

    public void removeReceiveHandler(ReceiveMessageHandler var1);

    public boolean isReceiving();

    public void receiveMessages(Optional<Duration> var1, Optional<Integer> var2, ReceiveMessageHandler var3) throws IOException, AlreadyReceivingException;

    public void stopReceiveMessages();

    public void setReceiveConfig(ReceiveConfig var1);

    public boolean isContactBlocked(RecipientIdentifier.Single var1);

    public void sendContacts() throws IOException;

    public List<Recipient> getRecipients(boolean var1, Optional<Boolean> var2, Collection<RecipientIdentifier.Single> var3, Optional<String> var4);

    public String getContactOrProfileName(RecipientIdentifier.Single var1);

    public Group getGroup(GroupId var1);

    public List<Identity> getIdentities();

    public List<Identity> getIdentities(RecipientIdentifier.Single var1);

    public boolean trustIdentityVerified(RecipientIdentifier.Single var1, IdentityVerificationCode var2) throws UnregisteredRecipientException;

    public boolean trustIdentityAllKeys(RecipientIdentifier.Single var1) throws UnregisteredRecipientException;

    public void addAddressChangedListener(Runnable var1);

    public void addClosedListener(Runnable var1);

    public InputStream retrieveAttachment(String var1) throws IOException;

    public InputStream retrieveContactAvatar(RecipientIdentifier.Single var1) throws IOException, UnregisteredRecipientException;

    public InputStream retrieveProfileAvatar(RecipientIdentifier.Single var1) throws IOException, UnregisteredRecipientException;

    public InputStream retrieveGroupAvatar(GroupId var1) throws IOException;

    public InputStream retrieveSticker(StickerPackId var1, int var2) throws IOException;

    @Override
    public void close();

    public static interface ReceiveMessageHandler {
        public static final ReceiveMessageHandler EMPTY = (envelope, e) -> {};

        public void handleMessage(MessageEnvelope var1, Throwable var2);
    }
}

