/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.internal.SignalWebSocketHealthMonitor;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.whispersystems.signalservice.api.SignalServiceAccountManager;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalServiceMessageReceiver;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.SignalWebSocket;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.groupsv2.ClientZkOperations;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Api;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.services.ProfileService;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.SleepTimer;
import org.whispersystems.signalservice.api.util.UptimeSleepTimer;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.WebSocketFactory;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.ProvisioningSocket;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.websocket.OkHttpWebSocketConnection;
import org.whispersystems.signalservice.internal.websocket.WebSocketConnection;

public class SignalDependencies {
    private final Object LOCK = new Object();
    private final ServiceEnvironmentConfig serviceEnvironmentConfig;
    private final String userAgent;
    private final CredentialsProvider credentialsProvider;
    private final SignalServiceDataStore dataStore;
    private final ExecutorService executor;
    private final SignalSessionLock sessionLock;
    private boolean allowStories = true;
    private SignalServiceAccountManager accountManager;
    private GroupsV2Api groupsV2Api;
    private RegistrationApi registrationApi;
    private GroupsV2Operations groupsV2Operations;
    private ClientZkOperations clientZkOperations;
    private PushServiceSocket pushServiceSocket;
    private ProvisioningSocket provisioningSocket;
    private Network libSignalNetwork;
    private SignalWebSocket signalWebSocket;
    private SignalServiceMessageReceiver messageReceiver;
    private SignalServiceMessageSender messageSender;
    private List<SecureValueRecovery> secureValueRecovery;
    private ProfileService profileService;

    SignalDependencies(ServiceEnvironmentConfig serviceEnvironmentConfig, String userAgent, CredentialsProvider credentialsProvider, SignalServiceDataStore dataStore, ExecutorService executor, SignalSessionLock sessionLock) {
        this.serviceEnvironmentConfig = serviceEnvironmentConfig;
        this.userAgent = userAgent;
        this.credentialsProvider = credentialsProvider;
        this.dataStore = dataStore;
        this.executor = executor;
        this.sessionLock = sessionLock;
    }

    public void resetAfterAddressChange() {
        if (this.pushServiceSocket != null) {
            this.pushServiceSocket.close();
            this.pushServiceSocket = null;
            this.accountManager = null;
            this.messageReceiver = null;
            this.messageSender = null;
            this.profileService = null;
            this.groupsV2Api = null;
            this.registrationApi = null;
            this.secureValueRecovery = null;
        }
        this.getSignalWebSocket().forceNewWebSockets();
    }

    public void setAllowStories(boolean allowStories) {
        this.allowStories = allowStories;
    }

    public ServiceEnvironmentConfig getServiceEnvironmentConfig() {
        return this.serviceEnvironmentConfig;
    }

    public SignalSessionLock getSessionLock() {
        return this.sessionLock;
    }

    public PushServiceSocket getPushServiceSocket() {
        return this.getOrCreate(() -> this.pushServiceSocket, () -> {
            this.pushServiceSocket = new PushServiceSocket(this.serviceEnvironmentConfig.signalServiceConfiguration(), this.credentialsProvider, this.userAgent, this.getClientZkProfileOperations(), true);
        });
    }

    public ProvisioningSocket getProvisioningSocket() {
        return this.getOrCreate(() -> this.provisioningSocket, () -> {
            this.provisioningSocket = new ProvisioningSocket(this.getServiceEnvironmentConfig().signalServiceConfiguration(), this.userAgent);
        });
    }

    public Network getLibSignalNetwork() {
        return this.getOrCreate(() -> this.libSignalNetwork, () -> {
            this.libSignalNetwork = new Network(this.serviceEnvironmentConfig.netEnvironment(), this.userAgent);
        });
    }

    public SignalServiceAccountManager getAccountManager() {
        return this.getOrCreate(() -> this.accountManager, () -> {
            this.accountManager = new SignalServiceAccountManager(this.getPushServiceSocket(), this.getProvisioningSocket(), this.getGroupsV2Operations());
        });
    }

    public SignalServiceAccountManager createUnauthenticatedAccountManager(String number, String password) {
        return SignalServiceAccountManager.createWithStaticCredentials((SignalServiceConfiguration)this.getServiceEnvironmentConfig().signalServiceConfiguration(), null, null, (String)number, (int)1, (String)password, (String)this.userAgent, (boolean)true, (int)1001);
    }

    public GroupsV2Api getGroupsV2Api() {
        return this.getOrCreate(() -> this.groupsV2Api, () -> {
            this.groupsV2Api = this.getAccountManager().getGroupsV2Api();
        });
    }

    public RegistrationApi getRegistrationApi() {
        return this.getOrCreate(() -> this.registrationApi, () -> {
            this.registrationApi = this.getAccountManager().getRegistrationApi();
        });
    }

    public GroupsV2Operations getGroupsV2Operations() {
        return this.getOrCreate(() -> this.groupsV2Operations, () -> {
            this.groupsV2Operations = new GroupsV2Operations(ClientZkOperations.create((SignalServiceConfiguration)this.serviceEnvironmentConfig.signalServiceConfiguration()), 1001);
        });
    }

    private ClientZkOperations getClientZkOperations() {
        return this.getOrCreate(() -> this.clientZkOperations, () -> {
            this.clientZkOperations = ClientZkOperations.create((SignalServiceConfiguration)this.serviceEnvironmentConfig.signalServiceConfiguration());
        });
    }

    private ClientZkProfileOperations getClientZkProfileOperations() {
        ClientZkOperations clientZkOperations = this.getClientZkOperations();
        return clientZkOperations.getProfileOperations();
    }

    public SignalWebSocket getSignalWebSocket() {
        return this.getOrCreate(() -> this.signalWebSocket, () -> {
            UptimeSleepTimer timer = new UptimeSleepTimer();
            final SignalWebSocketHealthMonitor healthMonitor = new SignalWebSocketHealthMonitor((SleepTimer)timer);
            WebSocketFactory webSocketFactory = new WebSocketFactory(){

                public WebSocketConnection createWebSocket() {
                    return new OkHttpWebSocketConnection("normal", SignalDependencies.this.serviceEnvironmentConfig.signalServiceConfiguration(), Optional.of(SignalDependencies.this.credentialsProvider), SignalDependencies.this.userAgent, (HealthMonitor)healthMonitor, SignalDependencies.this.allowStories);
                }

                public WebSocketConnection createUnidentifiedWebSocket() {
                    return new OkHttpWebSocketConnection("unidentified", SignalDependencies.this.serviceEnvironmentConfig.signalServiceConfiguration(), Optional.empty(), SignalDependencies.this.userAgent, (HealthMonitor)healthMonitor, SignalDependencies.this.allowStories);
                }
            };
            this.signalWebSocket = new SignalWebSocket(webSocketFactory);
            healthMonitor.monitor(this.signalWebSocket);
        });
    }

    public SignalServiceMessageReceiver getMessageReceiver() {
        return this.getOrCreate(() -> this.messageReceiver, () -> {
            this.messageReceiver = new SignalServiceMessageReceiver(this.getPushServiceSocket());
        });
    }

    public SignalServiceMessageSender getMessageSender() {
        return this.getOrCreate(() -> this.messageSender, () -> {
            this.messageSender = new SignalServiceMessageSender(this.getPushServiceSocket(), this.dataStore, this.sessionLock, this.getSignalWebSocket(), Optional.empty(), this.executor, 0L);
        });
    }

    public List<SecureValueRecovery> getSecureValueRecovery() {
        return this.getOrCreate(() -> this.secureValueRecovery, () -> {
            this.secureValueRecovery = this.serviceEnvironmentConfig.svr2Mrenclaves().stream().map(mr -> this.getAccountManager().getSecureValueRecoveryV2(mr)).toList();
        });
    }

    public ProfileService getProfileService() {
        return this.getOrCreate(() -> this.profileService, () -> {
            this.profileService = new ProfileService(this.getClientZkProfileOperations(), this.getMessageReceiver(), this.getSignalWebSocket());
        });
    }

    public SignalServiceCipher getCipher(ServiceIdType serviceIdType) {
        CertificateValidator certificateValidator = new CertificateValidator(this.serviceEnvironmentConfig.unidentifiedSenderTrustRoot());
        SignalServiceAddress address = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        int deviceId = this.credentialsProvider.getDeviceId();
        return new SignalServiceCipher(address, deviceId, serviceIdType == ServiceIdType.ACI ? this.dataStore.aci() : this.dataStore.pni(), this.sessionLock, certificateValidator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreate(Supplier<T> supplier, Callable creator) {
        T value = supplier.get();
        if (value != null) {
            return value;
        }
        Object object = this.LOCK;
        synchronized (object) {
            value = supplier.get();
            if (value != null) {
                return value;
            }
            creator.call();
            return supplier.get();
        }
    }

    private static interface Callable {
        public void call();
    }
}

