/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.groups;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.storage.recipients.RecipientIdCreator;
import org.asamk.signal.manager.storage.recipients.RecipientResolver;
import org.asamk.signal.manager.util.KeyUtils;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.signal.libsignal.zkgroup.groups.GroupSecretParams;
import org.signal.storageservice.protos.groups.local.DecryptedGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.DistributionId;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.UuidUtil;

public class GroupStore {
    private static final Logger logger = LoggerFactory.getLogger(GroupStore.class);
    private static final String TABLE_GROUP_V2 = "group_v2";
    private static final String TABLE_GROUP_V1 = "group_v1";
    private static final String TABLE_GROUP_V1_MEMBER = "group_v1_member";
    private final Database database;
    private final RecipientResolver recipientResolver;
    private final RecipientIdCreator recipientIdCreator;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE group_v2 (\n  _id INTEGER PRIMARY KEY,\n  storage_id BLOB UNIQUE,\n  storage_record BLOB,\n  group_id BLOB UNIQUE NOT NULL,\n  master_key BLOB NOT NULL,\n  group_data BLOB,\n  distribution_id BLOB UNIQUE NOT NULL,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  profile_sharing INTEGER NOT NULL DEFAULT FALSE,\n  permission_denied INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\nCREATE TABLE group_v1 (\n  _id INTEGER PRIMARY KEY,\n  storage_id BLOB UNIQUE,\n  storage_record BLOB,\n  group_id BLOB UNIQUE NOT NULL,\n  group_id_v2 BLOB UNIQUE,\n  name TEXT,\n  color TEXT,\n  expiration_time INTEGER NOT NULL DEFAULT 0,\n  blocked INTEGER NOT NULL DEFAULT FALSE,\n  archived INTEGER NOT NULL DEFAULT FALSE\n) STRICT;\nCREATE TABLE group_v1_member (\n  _id INTEGER PRIMARY KEY,\n  group_id INTEGER NOT NULL REFERENCES group_v1 (_id) ON DELETE CASCADE,\n  recipient_id INTEGER NOT NULL REFERENCES recipient (_id) ON DELETE CASCADE,\n  UNIQUE(group_id, recipient_id)\n) STRICT;\n");
        }
    }

    public GroupStore(Database database, RecipientResolver recipientResolver, RecipientIdCreator recipientIdCreator) {
        this.database = database;
        this.recipientResolver = recipientResolver;
        this.recipientIdCreator = recipientIdCreator;
    }

    public void updateGroup(GroupInfo group) {
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            this.updateGroup(connection, group);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update recipient store", e);
        }
    }

    public void updateGroup(Connection connection, GroupInfo group) throws SQLException {
        Long internalId;
        String sql = "SELECT g._id\nFROM %s g\nWHERE g.group_id = ?\n".formatted(group instanceof GroupInfoV1 ? TABLE_GROUP_V1 : TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, group.getGroupId().serialize());
            internalId = Utils.executeQueryForOptional(statement, res -> res.getLong("_id")).orElse(null);
        }
        this.insertOrReplaceGroup(connection, internalId, group);
    }

    public void storeStorageRecord(Connection connection, GroupId groupId, StorageId storageId, byte[] storageRecord) throws SQLException {
        String groupTable = groupId instanceof GroupIdV1 ? TABLE_GROUP_V1 : TABLE_GROUP_V2;
        String deleteSql = "UPDATE %s\nSET storage_id = NULL\nWHERE storage_id = ?\n".formatted(groupTable);
        try (PreparedStatement statement = connection.prepareStatement(deleteSql);){
            statement.setBytes(1, storageId.getRaw());
            statement.executeUpdate();
        }
        String sql = "UPDATE %s\nSET storage_id = ?, storage_record = ?\nWHERE group_id = ?\n".formatted(groupTable);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, storageId.getRaw());
            if (storageRecord == null) {
                statement.setNull(2, 2004);
            } else {
                statement.setBytes(2, storageRecord);
            }
            statement.setBytes(3, groupId.serialize());
            statement.executeUpdate();
        }
    }

    public void deleteGroup(GroupId groupId) {
        if (groupId instanceof GroupIdV1) {
            GroupIdV1 groupIdV1 = (GroupIdV1)groupId;
            this.deleteGroup(groupIdV1);
        } else if (groupId instanceof GroupIdV2) {
            GroupIdV2 groupIdV2 = (GroupIdV2)groupId;
            this.deleteGroup(groupIdV2);
        }
    }

    public void deleteGroup(GroupIdV1 groupIdV1) {
        try (Connection connection = this.database.getConnection();){
            this.deleteGroup(connection, groupIdV1);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update group store", e);
        }
    }

    private void deleteGroup(Connection connection, GroupIdV1 groupIdV1) throws SQLException {
        String sql = "DELETE FROM %s\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV1.serialize());
            statement.executeUpdate();
        }
    }

    public void deleteGroup(GroupIdV2 groupIdV2) {
        try (Connection connection = this.database.getConnection();){
            String sql = "DELETE FROM %s\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V2);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setBytes(1, groupIdV2.serialize());
                statement.executeUpdate();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update group store", e);
        }
    }

    public GroupInfo getGroup(GroupId groupId) {
        GroupInfo groupInfo;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                groupInfo = this.getGroup(connection, groupId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from group store", e);
                }
            }
            connection.close();
        }
        return groupInfo;
    }

    public GroupInfo getGroup(Connection connection, GroupId groupId) throws SQLException {
        GroupId groupId2 = groupId;
        Objects.requireNonNull(groupId2);
        GroupId groupId3 = groupId2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupIdV1.class, GroupIdV2.class}, (Object)groupId3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GroupIdV1 groupIdV1 = (GroupIdV1)groupId3;
                GroupInfoV1 group = this.getGroup(connection, groupIdV1);
                if (group != null) {
                    return group;
                }
                return this.getGroupV2ByV1Id(connection, groupIdV1);
            }
            case 1: 
        }
        GroupIdV2 groupIdV2 = (GroupIdV2)groupId3;
        GroupInfoV2 group = this.getGroup(connection, groupIdV2);
        if (group != null) {
            return group;
        }
        return this.getGroupV1ByV2Id(connection, groupIdV2);
    }

    public GroupInfoV1 getOrCreateGroupV1(GroupIdV1 groupId) {
        GroupInfoV1 groupInfoV1;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                groupInfoV1 = this.getOrCreateGroupV1(connection, groupId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from group store", e);
                }
            }
            connection.close();
        }
        return groupInfoV1;
    }

    public GroupInfoV1 getOrCreateGroupV1(Connection connection, GroupIdV1 groupId) throws SQLException {
        GroupInfoV1 group = this.getGroup(connection, groupId);
        if (group != null) {
            return group;
        }
        if (this.getGroupV2ByV1Id(connection, groupId) == null) {
            return new GroupInfoV1(groupId);
        }
        return null;
    }

    public GroupInfoV2 getGroupOrPartialMigrate(Connection connection, GroupMasterKey groupMasterKey) throws SQLException {
        GroupSecretParams groupSecretParams = GroupSecretParams.deriveFromMasterKey((GroupMasterKey)groupMasterKey);
        GroupIdV2 groupId = GroupUtils.getGroupIdV2(groupSecretParams);
        return this.getGroupOrPartialMigrate(connection, groupMasterKey, groupId);
    }

    public GroupInfoV2 getGroupOrPartialMigrate(GroupMasterKey groupMasterKey, GroupIdV2 groupId) {
        GroupInfoV2 groupInfoV2;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                groupInfoV2 = this.getGroupOrPartialMigrate(connection, groupMasterKey, groupId);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from group store", e);
                }
            }
            connection.close();
        }
        return groupInfoV2;
    }

    private GroupInfoV2 getGroupOrPartialMigrate(Connection connection, GroupMasterKey groupMasterKey, GroupIdV2 groupId) throws SQLException {
        GroupInfo groupInfo = this.getGroup(connection, (GroupId)groupId);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupInfoV1.class, GroupInfoV2.class}, (Object)groupInfo, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GroupInfoV1 groupInfoV1 = (GroupInfoV1)groupInfo;
                this.deleteGroup(connection, groupInfoV1.getGroupId());
                GroupInfoV2 groupInfoV2 = new GroupInfoV2(groupId, groupMasterKey, this.recipientResolver);
                groupInfoV2.setBlocked(groupInfoV1.isBlocked());
                this.updateGroup(connection, groupInfoV2);
                logger.debug("Locally migrated group {} to group v2, id: {}", (Object)groupInfoV1.getGroupId().toBase64(), (Object)groupInfoV2.getGroupId().toBase64());
                return groupInfoV2;
            }
            case 1: {
                GroupInfoV2 groupInfoV2 = (GroupInfoV2)groupInfo;
                return groupInfoV2;
            }
            case -1: 
        }
        return new GroupInfoV2(groupId, groupMasterKey, this.recipientResolver);
    }

    public List<GroupInfo> getGroups() {
        return Stream.concat(this.getGroupsV2().stream(), this.getGroupsV1().stream()).toList();
    }

    public List<GroupIdV1> getGroupV1Ids(Connection connection) throws SQLException {
        String sql = "SELECT g.group_id\nFROM %s g\n".formatted(TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            List<GroupIdV1> list = Utils.executeQueryForStream(statement, this::getGroupIdV1FromResultSet).filter(Objects::nonNull).toList();
            return list;
        }
    }

    public List<GroupIdV2> getGroupV2Ids(Connection connection) throws SQLException {
        String sql = "SELECT g.group_id\nFROM %s g\n".formatted(TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            List<GroupIdV2> list = Utils.executeQueryForStream(statement, this::getGroupIdV2FromResultSet).filter(Objects::nonNull).toList();
            return list;
        }
    }

    public void mergeRecipients(Connection connection, RecipientId recipientId, RecipientId toBeMergedRecipientId) throws SQLException {
        String sql = "UPDATE OR REPLACE %s\nSET recipient_id = ?\nWHERE recipient_id = ?\n".formatted(TABLE_GROUP_V1_MEMBER);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, recipientId.id());
            statement.setLong(2, toBeMergedRecipientId.id());
            int updatedRows = statement.executeUpdate();
            if (updatedRows > 0) {
                logger.debug("Updated {} group members when merging recipients", (Object)updatedRows);
            }
        }
    }

    public List<StorageId> getStorageIds(Connection connection) throws SQLException {
        ArrayList<StorageId> storageIds = new ArrayList<StorageId>();
        String sql = "SELECT g.storage_id\nFROM %s g WHERE g.storage_id IS NOT NULL\n";
        try (PreparedStatement statement = connection.prepareStatement("SELECT g.storage_id\nFROM %s g WHERE g.storage_id IS NOT NULL\n".formatted(TABLE_GROUP_V1));){
            Utils.executeQueryForStream(statement, this::getGroupV1StorageIdFromResultSet).forEach(storageIds::add);
        }
        statement = connection.prepareStatement("SELECT g.storage_id\nFROM %s g WHERE g.storage_id IS NOT NULL\n".formatted(TABLE_GROUP_V2));
        try {
            Utils.executeQueryForStream(statement, this::getGroupV2StorageIdFromResultSet).forEach(storageIds::add);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return storageIds;
    }

    public void updateStorageIds(Connection connection, Map<GroupIdV1, StorageId> storageIdV1Map, Map<GroupIdV2, StorageId> storageIdV2Map) throws SQLException {
        String sql = "UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n";
        try (PreparedStatement statement = connection.prepareStatement("UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V1));){
            for (Map.Entry<GroupIdV1, StorageId> entry : storageIdV1Map.entrySet()) {
                statement.setBytes(1, entry.getValue().getRaw());
                statement.setBytes(2, entry.getKey().serialize());
                statement.executeUpdate();
            }
        }
        statement = connection.prepareStatement("UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V2));
        try {
            for (Map.Entry<GroupId, StorageId> entry : storageIdV2Map.entrySet()) {
                statement.setBytes(1, entry.getValue().getRaw());
                statement.setBytes(2, ((GroupIdV2)entry.getKey()).serialize());
                statement.executeUpdate();
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public void updateStorageId(Connection connection, GroupId groupId, StorageId storageId) throws SQLException {
        String sqlV1 = "UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n".formatted(groupId instanceof GroupIdV1 ? TABLE_GROUP_V1 : TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sqlV1);){
            statement.setBytes(1, storageId.getRaw());
            statement.setBytes(2, groupId.serialize());
            statement.executeUpdate();
        }
    }

    public void setMissingStorageIds() {
        String selectSql = "SELECT g.group_id\nFROM %s g\nWHERE g.storage_id IS NULL\n";
        String updateSql = "UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n";
        try (Connection connection = this.database.getConnection();){
            PreparedStatement updateStmt;
            List<GroupId> groupIds;
            connection.setAutoCommit(false);
            try (PreparedStatement selectStmt = connection.prepareStatement("SELECT g.group_id\nFROM %s g\nWHERE g.storage_id IS NULL\n".formatted(TABLE_GROUP_V1));){
                groupIds = Utils.executeQueryForStream(selectStmt, this::getGroupIdV1FromResultSet).toList();
                updateStmt = connection.prepareStatement("UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V1));
                try {
                    for (GroupId groupId : groupIds) {
                        updateStmt.setBytes(1, KeyUtils.createRawStorageId());
                        updateStmt.setBytes(2, groupId.serialize());
                    }
                }
                finally {
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
            }
            selectStmt = connection.prepareStatement("SELECT g.group_id\nFROM %s g\nWHERE g.storage_id IS NULL\n".formatted(TABLE_GROUP_V2));
            try {
                groupIds = Utils.executeQueryForStream(selectStmt, this::getGroupIdV2FromResultSet).toList();
                updateStmt = connection.prepareStatement("UPDATE %s\nSET storage_id = ?\nWHERE group_id = ?\n".formatted(TABLE_GROUP_V2));
                try {
                    for (GroupId groupId : groupIds) {
                        updateStmt.setBytes(1, KeyUtils.createRawStorageId());
                        updateStmt.setBytes(2, groupId.serialize());
                        updateStmt.executeUpdate();
                    }
                }
                finally {
                    if (updateStmt != null) {
                        updateStmt.close();
                    }
                }
            }
            finally {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update group store", e);
        }
    }

    void addLegacyGroups(Collection<GroupInfo> groups) {
        logger.debug("Migrating legacy groups to database");
        long start = System.nanoTime();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (GroupInfo group : groups) {
                this.insertOrReplaceGroup(connection, null, group);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update group store", e);
        }
        logger.debug("Complete groups migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private void insertOrReplaceGroup(Connection connection, Long internalId, GroupInfo group) throws SQLException {
        if (group instanceof GroupInfoV1) {
            GroupInfoV1 groupV1;
            block37: {
                PreparedStatement statement;
                groupV1 = (GroupInfoV1)group;
                if (internalId != null) {
                    String sqlDeleteMembers = "DELETE FROM %s where group_id = ?".formatted(TABLE_GROUP_V1_MEMBER);
                    statement = connection.prepareStatement(sqlDeleteMembers);
                    try {
                        statement.setLong(1, internalId);
                        statement.executeUpdate();
                    }
                    finally {
                        if (statement != null) {
                            statement.close();
                        }
                    }
                }
                String sql = "INSERT OR REPLACE INTO %s (_id, group_id, group_id_v2, name, color, expiration_time, blocked, archived, storage_id)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\nRETURNING _id\n".formatted(TABLE_GROUP_V1);
                statement = connection.prepareStatement(sql);
                try {
                    if (internalId == null) {
                        statement.setNull(1, 2);
                    } else {
                        statement.setLong(1, internalId);
                    }
                    statement.setBytes(2, groupV1.getGroupId().serialize());
                    statement.setBytes(3, groupV1.getExpectedV2Id().serialize());
                    statement.setString(4, groupV1.getTitle());
                    statement.setString(5, groupV1.color);
                    statement.setLong(6, groupV1.getMessageExpirationTimer());
                    statement.setBoolean(7, groupV1.isBlocked());
                    statement.setBoolean(8, groupV1.archived);
                    statement.setBytes(9, KeyUtils.createRawStorageId());
                    Optional<Long> generatedKey = Utils.executeQueryForOptional(statement, Utils::getIdMapper);
                    if (internalId != null) break block37;
                    if (generatedKey.isPresent()) {
                        internalId = generatedKey.get();
                        break block37;
                    }
                    throw new RuntimeException("Failed to add new group to database");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            String sqlInsertMember = "INSERT OR REPLACE INTO %s (group_id, recipient_id)\nVALUES (?, ?)\n".formatted(TABLE_GROUP_V1_MEMBER);
            try (PreparedStatement statement = connection.prepareStatement(sqlInsertMember);){
                for (RecipientId recipient : groupV1.getMembers()) {
                    statement.setLong(1, internalId);
                    statement.setLong(2, recipient.id());
                    statement.executeUpdate();
                }
            }
        }
        if (group instanceof GroupInfoV2) {
            GroupInfoV2 groupV2 = (GroupInfoV2)group;
            String sql = "INSERT OR REPLACE INTO %s (_id, group_id, master_key, group_data, distribution_id, blocked, permission_denied, storage_id, profile_sharing)\nVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n".formatted(TABLE_GROUP_V2);
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                if (internalId == null) {
                    statement.setNull(1, 2);
                } else {
                    statement.setLong(1, internalId);
                }
                statement.setBytes(2, groupV2.getGroupId().serialize());
                statement.setBytes(3, groupV2.getMasterKey().serialize());
                if (groupV2.getGroup() == null) {
                    statement.setNull(4, 2);
                } else {
                    statement.setBytes(4, groupV2.getGroup().encode());
                }
                statement.setBytes(5, UuidUtil.toByteArray((UUID)groupV2.getDistributionId().asUuid()));
                statement.setBoolean(6, groupV2.isBlocked());
                statement.setBoolean(7, groupV2.isPermissionDenied());
                statement.setBytes(8, KeyUtils.createRawStorageId());
                statement.setBoolean(9, groupV2.isProfileSharingEnabled());
                statement.executeUpdate();
            }
        } else {
            throw new AssertionError((Object)"Invalid group id type");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<GroupInfoV2> getGroupsV2() {
        String sql = "SELECT g.group_id, g.master_key, g.group_data, g.distribution_id, g.blocked, g.profile_sharing, g.permission_denied, g.storage_record\nFROM %s g\n".formatted(TABLE_GROUP_V2);
        try (Connection connection = this.database.getConnection();){
            List<GroupInfoV2> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    list = Utils.executeQueryForStream(statement, this::getGroupInfoV2FromResultSet).filter(Objects::nonNull).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from group store", e);
        }
    }

    public GroupInfoV2 getGroup(Connection connection, GroupIdV2 groupIdV2) throws SQLException {
        String sql = "SELECT g.group_id, g.master_key, g.group_data, g.distribution_id, g.blocked, g.profile_sharing, g.permission_denied, g.storage_record\nFROM %s g\nWHERE g.group_id = ?\n".formatted(TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV2.serialize());
            GroupInfoV2 groupInfoV2 = Utils.executeQueryForOptional(statement, this::getGroupInfoV2FromResultSet).orElse(null);
            return groupInfoV2;
        }
    }

    public StorageId getGroupStorageId(Connection connection, GroupIdV2 groupIdV2) throws SQLException {
        String sql = "SELECT g.storage_id\nFROM %s g\nWHERE g.group_id = ?\n".formatted(TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV2.serialize());
            Optional<StorageId> storageId = Utils.executeQueryForOptional(statement, this::getGroupV2StorageIdFromResultSet);
            if (storageId.isPresent()) {
                StorageId storageId2 = storageId.get();
                return storageId2;
            }
        }
        StorageId newStorageId = StorageId.forGroupV2((byte[])KeyUtils.createRawStorageId());
        this.updateStorageId(connection, groupIdV2, newStorageId);
        return newStorageId;
    }

    public GroupInfoV2 getGroupV2(Connection connection, StorageId storageId) throws SQLException {
        String sql = "SELECT g.group_id, g.master_key, g.group_data, g.distribution_id, g.blocked, g.profile_sharing, g.permission_denied, g.storage_record\nFROM %s g\nWHERE g.storage_id = ?\n".formatted(TABLE_GROUP_V2);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, storageId.getRaw());
            GroupInfoV2 groupInfoV2 = Utils.executeQueryForOptional(statement, this::getGroupInfoV2FromResultSet).orElse(null);
            return groupInfoV2;
        }
    }

    private GroupIdV2 getGroupIdV2FromResultSet(ResultSet resultSet) throws SQLException {
        byte[] groupId = resultSet.getBytes("group_id");
        return GroupId.v2(groupId);
    }

    private GroupInfoV2 getGroupInfoV2FromResultSet(ResultSet resultSet) throws SQLException {
        try {
            byte[] groupId = resultSet.getBytes("group_id");
            byte[] masterKey = resultSet.getBytes("master_key");
            byte[] groupData = resultSet.getBytes("group_data");
            byte[] distributionId = resultSet.getBytes("distribution_id");
            boolean blocked = resultSet.getBoolean("blocked");
            boolean profileSharingEnabled = resultSet.getBoolean("profile_sharing");
            boolean permissionDenied = resultSet.getBoolean("permission_denied");
            byte[] storageRecord = resultSet.getBytes("storage_record");
            return new GroupInfoV2(GroupId.v2(groupId), new GroupMasterKey(masterKey), groupData == null ? null : (DecryptedGroup)DecryptedGroup.ADAPTER.decode(groupData), DistributionId.from((UUID)UuidUtil.parseOrThrow((byte[])distributionId)), blocked, profileSharingEnabled, permissionDenied, storageRecord, this.recipientResolver);
        }
        catch (IOException | InvalidInputException e) {
            return null;
        }
    }

    private StorageId getGroupV1StorageIdFromResultSet(ResultSet resultSet) throws SQLException {
        byte[] storageId = resultSet.getBytes("storage_id");
        return storageId == null ? StorageId.forGroupV1((byte[])KeyUtils.createRawStorageId()) : StorageId.forGroupV1((byte[])storageId);
    }

    private StorageId getGroupV2StorageIdFromResultSet(ResultSet resultSet) throws SQLException {
        byte[] storageId = resultSet.getBytes("storage_id");
        return storageId == null ? StorageId.forGroupV2((byte[])KeyUtils.createRawStorageId()) : StorageId.forGroupV2((byte[])storageId);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<GroupInfoV1> getGroupsV1() {
        String sql = "SELECT g.group_id, g.group_id_v2, g.name, g.color, (select group_concat(gm.recipient_id) from %s gm where gm.group_id = g._id) as members, g.expiration_time, g.blocked, g.archived, g.storage_record\nFROM %s g\n".formatted(TABLE_GROUP_V1_MEMBER, TABLE_GROUP_V1);
        try (Connection connection = this.database.getConnection();){
            List<GroupInfoV1> list;
            block14: {
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    list = Utils.executeQueryForStream(statement, this::getGroupInfoV1FromResultSet).filter(Objects::nonNull).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from group store", e);
        }
    }

    public GroupInfoV1 getGroup(Connection connection, GroupIdV1 groupIdV1) throws SQLException {
        String sql = "SELECT g.group_id, g.group_id_v2, g.name, g.color, (select group_concat(gm.recipient_id) from %s gm where gm.group_id = g._id) as members, g.expiration_time, g.blocked, g.archived, g.storage_record\nFROM %s g\nWHERE g.group_id = ?\n".formatted(TABLE_GROUP_V1_MEMBER, TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV1.serialize());
            GroupInfoV1 groupInfoV1 = Utils.executeQueryForOptional(statement, this::getGroupInfoV1FromResultSet).orElse(null);
            return groupInfoV1;
        }
    }

    public StorageId getGroupStorageId(Connection connection, GroupIdV1 groupIdV1) throws SQLException {
        String sql = "SELECT g.storage_id\nFROM %s g\nWHERE g.group_id = ?\n".formatted(TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV1.serialize());
            Optional<StorageId> storageId = Utils.executeQueryForOptional(statement, this::getGroupV1StorageIdFromResultSet);
            if (storageId.isPresent()) {
                StorageId storageId2 = storageId.get();
                return storageId2;
            }
        }
        StorageId newStorageId = StorageId.forGroupV1((byte[])KeyUtils.createRawStorageId());
        this.updateStorageId(connection, groupIdV1, newStorageId);
        return newStorageId;
    }

    public GroupInfoV1 getGroupV1(Connection connection, StorageId storageId) throws SQLException {
        String sql = "SELECT g.group_id, g.group_id_v2, g.name, g.color, (select group_concat(gm.recipient_id) from %s gm where gm.group_id = g._id) as members, g.expiration_time, g.blocked, g.archived, g.storage_record\nFROM %s g\nWHERE g.storage_id = ?\n".formatted(TABLE_GROUP_V1_MEMBER, TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, storageId.getRaw());
            GroupInfoV1 groupInfoV1 = Utils.executeQueryForOptional(statement, this::getGroupInfoV1FromResultSet).orElse(null);
            return groupInfoV1;
        }
    }

    private GroupIdV1 getGroupIdV1FromResultSet(ResultSet resultSet) throws SQLException {
        byte[] groupId = resultSet.getBytes("group_id");
        return GroupId.v1(groupId);
    }

    private GroupInfoV1 getGroupInfoV1FromResultSet(ResultSet resultSet) throws SQLException {
        byte[] groupId = resultSet.getBytes("group_id");
        byte[] groupIdV2 = resultSet.getBytes("group_id_v2");
        String name = resultSet.getString("name");
        String color = resultSet.getString("color");
        String membersString = resultSet.getString("members");
        Set<RecipientId> members = membersString == null ? Set.of() : Arrays.stream(membersString.split(",")).map(Integer::valueOf).map(this.recipientIdCreator::create).collect(Collectors.toSet());
        int expirationTime = resultSet.getInt("expiration_time");
        boolean blocked = resultSet.getBoolean("blocked");
        boolean archived = resultSet.getBoolean("archived");
        byte[] storageRecord = resultSet.getBytes("storage_record");
        return new GroupInfoV1(GroupId.v1(groupId), groupIdV2 == null ? null : GroupId.v2(groupIdV2), name, members, color, expirationTime, blocked, archived, storageRecord);
    }

    private GroupInfoV2 getGroupV2ByV1Id(Connection connection, GroupIdV1 groupId) throws SQLException {
        return this.getGroup(connection, GroupUtils.getGroupIdV2(groupId));
    }

    private GroupInfoV1 getGroupV1ByV2Id(Connection connection, GroupIdV2 groupIdV2) throws SQLException {
        String sql = "SELECT g.group_id, g.group_id_v2, g.name, g.color, (select group_concat(gm.recipient_id) from %s gm where gm.group_id = g._id) as members, g.expiration_time, g.blocked, g.archived, g.storage_record\nFROM %s g\nWHERE g.group_id_v2 = ?\n".formatted(TABLE_GROUP_V1_MEMBER, TABLE_GROUP_V1);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, groupIdV2.serialize());
            GroupInfoV1 groupInfoV1 = Utils.executeQueryForOptional(statement, this::getGroupInfoV1FromResultSet).orElse(null);
            return groupInfoV1;
        }
    }
}

