/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.stickers;

import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.asamk.signal.manager.api.StickerPackId;
import org.asamk.signal.manager.storage.stickers.StickerPack;
import org.asamk.signal.manager.storage.stickers.StickerStore;

public class LegacyStickerStore {
    public static void migrate(Storage storage, StickerStore stickerStore) {
        HashSet packIds = new HashSet();
        List<StickerPack> stickers = storage.stickers.stream().map(s -> {
            StickerPackId packId = StickerPackId.deserialize(Base64.getDecoder().decode(s.packId));
            if (packIds.contains(packId)) {
                return null;
            }
            packIds.add(packId);
            byte[] packKey = Base64.getDecoder().decode(s.packKey);
            boolean installed = s.installed;
            return new StickerPack(-1L, packId, packKey, installed);
        }).filter(Objects::nonNull).toList();
        stickerStore.addLegacyStickers(stickers);
    }

    public record Storage(List<Sticker> stickers) {

        public record Sticker(String packId, String packKey, boolean installed) {
        }
    }
}

