/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCTemplate;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "VISIBLE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCTemplate template, String value) {
        Visibility vis;
        if (value.equals("DISPLAY")) {
            vis = Visibility.DISPLAY_ONLY;
        } else if (value.equals("EXPORT")) {
            vis = Visibility.OUTPUT_ONLY;
        } else if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else if (value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else {
            return new ParseResult.Fail("Can't understand Visibility: " + value, context);
        }
        context.getObjectContext().put((CDOMObject)template, ObjectKey.VISIBILITY, (Object)vis);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate template) {
        String visString;
        Visibility vis = (Visibility)context.getObjectContext().getObject((CDOMObject)template, ObjectKey.VISIBILITY);
        if (vis == null) {
            return null;
        }
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.DISPLAY_ONLY)) {
            visString = "DISPLAY";
        } else if (vis.equals((Object)Visibility.OUTPUT_ONLY)) {
            visString = "EXPORT";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + vis + " is not a valid Visibility for a PCTemplate");
            return null;
        }
        return new String[]{visString};
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

