/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.base.util.WrappedMapSet;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.DisplayLocation;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMAllRef;
import pcgen.cdom.reference.CDOMCategorizedSingleRef;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CDOMTypeRef;
import pcgen.cdom.reference.CategorizedCreator;
import pcgen.cdom.reference.ManufacturableFactory;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.LastGroupSeparator;
import pcgen.facade.core.AbilityCategoryFacade;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;
import pcgen.util.enumeration.Visibility;

public class AbilityCategory
implements Category<Ability>,
Loadable,
ManufacturableFactory<Ability>,
CategorizedCreator<Ability>,
AbilityCategoryFacade {
    private URI sourceURI;
    private String keyName;
    private String displayName;
    private String pluralName;
    private CDOMSingleRef<AbilityCategory> parentCategory;
    private Set<CDOMSingleRef<Ability>> containedAbilities = null;
    private DisplayLocation displayLocation;
    private boolean isAllAbilityTypes = false;
    private Set<Type> types = null;
    private Formula poolFormula = FormulaFactory.ZERO;
    private Visibility visibility = Visibility.DEFAULT;
    private boolean isEditable = true;
    private boolean isPoolModifiable = true;
    private boolean isPoolFractional = false;
    private boolean isInternal = false;
    public static final AbilityCategory FEAT = new AbilityCategory("FEAT", "in_feat");
    public static final AbilityCategory LANGBONUS = new AbilityCategory("*LANGBONUS");
    public static final AbilityCategory ANY = new AbilityCategory("ANY");

    public AbilityCategory() {
        this.keyName = "";
        this.parentCategory = CDOMDirectSingleRef.getRef(this);
    }

    public void copyFields(AbilityCategory srcCat) {
        this.sourceURI = srcCat.sourceURI;
        this.keyName = srcCat.keyName;
        this.displayName = srcCat.displayName;
        this.pluralName = srcCat.pluralName;
        this.parentCategory = srcCat.getParentCategory() == srcCat ? CDOMDirectSingleRef.getRef(this) : srcCat.parentCategory;
        this.displayLocation = srcCat.displayLocation;
        this.isAllAbilityTypes = srcCat.isAllAbilityTypes;
        this.types = srcCat.types == null ? null : new HashSet<Type>(srcCat.types);
        this.poolFormula = srcCat.poolFormula;
        this.visibility = srcCat.visibility;
        this.isEditable = srcCat.isEditable;
        this.isPoolModifiable = srcCat.isPoolModifiable;
        this.isPoolFractional = srcCat.isPoolFractional;
        this.isInternal = srcCat.isInternal;
    }

    public AbilityCategory(String aKeyName, String aDisplayName) {
        this.keyName = aKeyName;
        this.setName(aDisplayName);
        this.setPluralName(aDisplayName);
        this.parentCategory = CDOMDirectSingleRef.getRef(this);
        this.displayLocation = DisplayLocation.getConstant(aDisplayName);
    }

    public AbilityCategory(String aKeyName) {
        this(aKeyName, aKeyName);
    }

    public void setAbilityCategory(CDOMSingleRef<AbilityCategory> category) {
        if (this.isInternal) {
            if (!category.getLSTformat(false).equals(this.getKeyName())) {
                throw new IllegalArgumentException("Cannot set CATEGORY on an internal AbilityCategory");
            }
        } else {
            this.parentCategory = category;
        }
    }

    public CDOMSingleRef<AbilityCategory> getAbilityCatRef() {
        return this.parentCategory;
    }

    public void addAbilityType(Type type) {
        if (this.types == null) {
            this.types = new TreeSet<Type>();
        }
        this.types.add(type);
    }

    public Set<Type> getTypes() {
        if (this.types == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.types);
    }

    public boolean isAllAbilityTypes() {
        return this.isAllAbilityTypes;
    }

    public void setAllAbilityTypes(boolean allAbilityTypes) {
        this.isAllAbilityTypes = allAbilityTypes;
    }

    public void addAbilityKey(CDOMSingleRef<Ability> key) {
        if (this.containedAbilities == null) {
            this.containedAbilities = new HashSet<CDOMSingleRef<Ability>>();
        }
        this.containedAbilities.add(key);
    }

    public Formula getPoolFormula() {
        return this.poolFormula;
    }

    public void setPoolFormula(Formula formula) {
        this.poolFormula = formula;
    }

    public void setPluralName(String aName) {
        this.pluralName = aName;
    }

    public String getPluralName() {
        String name = this.pluralName;
        if (name == null) {
            name = this.displayName;
        }
        if (name.startsWith("in_")) {
            return LanguageBundle.getString(name);
        }
        return name;
    }

    public String getRawPluralName() {
        return this.pluralName;
    }

    public DisplayLocation getDisplayLocation() {
        if (this.displayLocation == null) {
            this.displayLocation = DisplayLocation.getConstant(this.getPluralName());
        }
        return this.displayLocation;
    }

    public void setDisplayLocation(DisplayLocation location) {
        this.displayLocation = location;
    }

    public void setVisible(Visibility visible) {
        this.visibility = visible;
    }

    public boolean isVisibleTo(View v) {
        return this.isVisibleTo(null, v);
    }

    public boolean isVisibleTo(PlayerCharacter pc, View v) {
        if (this.visibility.equals((Object)Visibility.QUALIFY)) {
            return pc == null || (double)pc.getTotalAbilityPool(this).floatValue() != 0.0 || pc.hasAbilityInPool(this);
        }
        return this.visibility.isVisibleTo(v);
    }

    public void setEditable(boolean yesNo) {
        this.isEditable = yesNo;
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public void setModPool(boolean yesNo) {
        this.isPoolModifiable = yesNo;
    }

    @Override
    public boolean allowPoolMod() {
        return this.isPoolModifiable;
    }

    public void setAllowFractionalPool(boolean yesNo) {
        this.isPoolFractional = yesNo;
    }

    public boolean allowFractionalPool() {
        return this.isPoolFractional;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName.startsWith("in_")) {
            return LanguageBundle.getString(this.displayName);
        }
        return this.displayName;
    }

    public String getRawDisplayName() {
        return this.displayName;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public void setName(String aName) {
        if ("".equals(this.keyName)) {
            this.keyName = aName;
        }
        this.displayName = aName;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbilityCategory other = (AbilityCategory)obj;
        return !(this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName));
    }

    @Override
    public Category<Ability> getParentCategory() {
        return this.parentCategory.resolvesTo();
    }

    public Collection<CDOMSingleRef<Ability>> getAbilityRefs() {
        if (this.containedAbilities == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.containedAbilities);
    }

    public boolean hasDirectReferences() {
        return this.containedAbilities != null && !this.containedAbilities.isEmpty();
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public URI getSourceURI() {
        return this.sourceURI;
    }

    @Override
    public void setSourceURI(URI source) {
        this.sourceURI = source;
    }

    @Override
    public String getLSTformat() {
        return this.getKeyName();
    }

    public void setInternal(boolean internal) {
        this.isInternal = internal;
    }

    @Override
    public boolean isInternal() {
        return this.isInternal;
    }

    @Override
    public boolean isType(String type) {
        return false;
    }

    @Override
    public CDOMGroupRef<Ability> getAllReference() {
        return new CDOMAllRef<Ability>(Ability.class);
    }

    @Override
    public CDOMGroupRef<Ability> getTypeReference(String ... types) {
        return new CDOMTypeRef<Ability>(Ability.class, types);
    }

    @Override
    public CDOMSingleRef<Ability> getReference(String ident) {
        return new CDOMCategorizedSingleRef<Ability>(Ability.class, this, ident);
    }

    @Override
    public Ability newInstance() {
        Ability a = new Ability();
        a.setCDOMCategory(this);
        return a;
    }

    @Override
    public boolean isMember(Ability item) {
        if (item == null) {
            return false;
        }
        Category<Ability> itemCategory = item.getCDOMCategory();
        return this.equals(itemCategory) || this.getParentCategory().equals(itemCategory);
    }

    @Override
    public Class<Ability> getReferenceClass() {
        return Ability.class;
    }

    @Override
    public String getReferenceDescription() {
        return "Ability Category " + this.getKeyName();
    }

    @Override
    public boolean resolve(ReferenceManufacturer<Ability> rm, String name, CDOMSingleRef<Ability> reference, UnconstructedValidator validator) {
        if (this.containedAbilities != null && this.containedAbilities.contains(reference)) {
            return true;
        }
        return this.doResolve(rm, name, reference, validator);
    }

    private boolean doResolve(ReferenceManufacturer<Ability> rm, String name, CDOMSingleRef<Ability> reference, UnconstructedValidator validator) {
        boolean returnGood = true;
        Ability activeObj = rm.getObject(name);
        if (activeObj == null) {
            ArrayList<String> choices = new ArrayList<String>();
            try {
                String reduced = AbilityUtilities.getUndecoratedName(name, choices);
                activeObj = rm.getObject(reduced);
            }
            catch (LastGroupSeparator.GroupingMismatchException e) {
                Logging.log(Logging.LST_ERROR, e.getMessage());
            }
            if (activeObj == null) {
                if (name.charAt(0) != '*' && !this.report(validator, name)) {
                    Logging.errorPrint("Unconstructed Reference: " + this.getReferenceDescription() + " " + name);
                    rm.fireUnconstuctedEvent(reference);
                    returnGood = false;
                }
                activeObj = rm.buildObject(name);
            } else {
                reference.addResolution(activeObj);
                if (choices.size() == 1) {
                    reference.setChoice((String)choices.get(0));
                } else if (choices.size() > 1) {
                    Logging.errorPrint("Invalid use of multiple items in parenthesis (comma prohibited) in " + activeObj + " " + ((Object)choices).toString());
                    returnGood = false;
                }
            }
        } else {
            ChooseInformation<?> ci;
            reference.addResolution(activeObj);
            if (reference.requiresTarget() && activeObj.getSafe(ObjectKey.MULTIPLE_ALLOWED).booleanValue() && (ci = activeObj.get(ObjectKey.CHOOSE_INFO)) != null && !"No Choice".equals(ci.getName())) {
                Logging.errorPrint("Invalid use of MULT:YES Ability " + activeObj + " where a target [parens] is required");
                Logging.errorPrint("PLEASE TAKE NOTE: If usage locations are reported, not all usages are necessary illegal (at least one is)");
                rm.fireUnconstuctedEvent(reference);
                returnGood = false;
            }
        }
        return returnGood;
    }

    private boolean report(UnconstructedValidator validator, String key) {
        return validator != null && validator.allow(this.getReferenceClass(), this, key);
    }

    @Override
    public boolean populate(ReferenceManufacturer<Ability> parentCrm, ReferenceManufacturer<Ability> rm, UnconstructedValidator validator) {
        if (parentCrm == null) {
            return true;
        }
        Collection<Ability> allObjects = parentCrm.getAllObjects();
        WrappedMapSet added = new WrappedMapSet(IdentityHashMap.class);
        for (Ability ability : allObjects) {
            boolean use = this.isAllAbilityTypes;
            if (!use && this.types != null) {
                for (Type type : this.types) {
                    if (!ability.isType(type.toString())) continue;
                    use = true;
                    break;
                }
            }
            if (!use) continue;
            added.add(ability);
            rm.addObject(ability, ability.getKeyName());
        }
        boolean returnGood = true;
        if (this.containedAbilities != null) {
            for (CDOMSingleRef<Ability> ref : this.containedAbilities) {
                Ability ability;
                boolean res = this.doResolve(parentCrm, ref.getLSTformat(false), ref, validator);
                if (res && added.add(ability = ref.resolvesTo())) {
                    rm.addObject(ability, ability.getKeyName());
                }
                returnGood &= res;
            }
        }
        return returnGood;
    }

    @Override
    public ManufacturableFactory<Ability> getParent() {
        AbilityCategory parent = this.parentCategory.resolvesTo();
        if (this.equals(parent)) {
            return null;
        }
        return parent;
    }

    @Override
    public Category<Ability> getCategory() {
        return this;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getType() {
        return String.valueOf(this.getDisplayLocation());
    }

    static {
        AbilityCategory.FEAT.pluralName = LanguageBundle.getString("in_feats");
        AbilityCategory.FEAT.displayLocation = DisplayLocation.getConstant(LanguageBundle.getString("in_feats"));
        FEAT.setInternal(true);
        LANGBONUS.setPoolFormula(FormulaFactory.getFormulaFor("BONUSLANG"));
        LANGBONUS.setInternal(true);
    }
}

