/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SizeAdjustment;
import pcgen.core.SpecialProperty;
import pcgen.core.analysis.EqModSpellInfo;
import pcgen.core.spell.Spell;
import pcgen.facade.core.AbilityFacade;
import pcgen.facade.core.EquipModFacade;
import pcgen.facade.core.EquipmentBuilderFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.InfoFacade;
import pcgen.facade.core.SizeAdjustmentFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.gui2.facade.SpellBuilderFacadeImpl;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.View;

public class EquipmentBuilderFacadeImpl
implements EquipmentBuilderFacade {
    private final UIDelegate delegate;
    private final Equipment equip;
    private final Map<EquipmentBuilderFacade.EquipmentHead, DefaultListFacade<EquipModFacade>> availListMap;
    private final Map<EquipmentBuilderFacade.EquipmentHead, DefaultListFacade<EquipModFacade>> selectedListMap;
    private final PlayerCharacter character;
    private final Equipment baseEquipment;
    private final EnumSet<EquipmentBuilderFacade.EquipmentHead> equipHeads;
    private DefaultReferenceFacade<SizeAdjustmentFacade> sizeRef;

    EquipmentBuilderFacadeImpl(Equipment equip, PlayerCharacter character, UIDelegate delegate) {
        this.equip = equip;
        this.character = character;
        this.delegate = delegate;
        this.sizeRef = new DefaultReferenceFacade<SizeAdjustment>(equip.getSizeAdjustment());
        String sBaseKey = equip.getBaseItemKeyName();
        this.baseEquipment = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(Equipment.class, sBaseKey);
        this.equipHeads = equip.isDouble() ? EnumSet.range(EquipmentBuilderFacade.EquipmentHead.PRIMARY, EquipmentBuilderFacade.EquipmentHead.SECONDARY) : EnumSet.of(EquipmentBuilderFacade.EquipmentHead.PRIMARY);
        this.availListMap = new HashMap<EquipmentBuilderFacade.EquipmentHead, DefaultListFacade<EquipModFacade>>();
        this.selectedListMap = new HashMap<EquipmentBuilderFacade.EquipmentHead, DefaultListFacade<EquipModFacade>>();
        for (EquipmentBuilderFacade.EquipmentHead head : this.equipHeads) {
            this.availListMap.put(head, new DefaultListFacade());
            DefaultListFacade<EquipmentModifier> selectedList = new DefaultListFacade<EquipmentModifier>();
            selectedList.setContents(equip.getEqModifierList(head.isPrimary()));
            this.selectedListMap.put(head, selectedList);
        }
        this.refreshAvailList();
    }

    @Override
    public boolean addModToEquipment(EquipModFacade modifier, EquipmentBuilderFacade.EquipmentHead head) {
        if (modifier == null || !(modifier instanceof EquipmentModifier) || head == null) {
            return false;
        }
        EquipmentModifier equipMod = (EquipmentModifier)modifier;
        this.equip.setCostMod("0");
        if (equipMod.getSafe(StringKey.CHOICE_STRING).startsWith("EQBUILDER.SPELL") && !this.getSpellChoiceForEqMod(equipMod)) {
            return false;
        }
        this.equip.addEqModifier(equipMod, head.isPrimary(), this.character);
        if (this.equip.isDouble() && equipMod.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue()) {
            this.equip.addEqModifier(equipMod, !head.isPrimary(), this.character);
        }
        this.equip.nameItemFromModifiers(this.character);
        this.refreshAvailList();
        this.refreshSelectedList();
        return true;
    }

    @Override
    public boolean removeModFromEquipment(EquipModFacade modifier, EquipmentBuilderFacade.EquipmentHead head) {
        if (modifier == null || !(modifier instanceof EquipmentModifier)) {
            return false;
        }
        EquipmentModifier equipMod = (EquipmentModifier)modifier;
        if (this.baseEquipment.getEqModifierList(true).contains(equipMod)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_eqCust_RemoveBaseErr", equipMod));
            return false;
        }
        this.equip.setCostMod("0");
        this.equip.removeEqModifier(equipMod, head.isPrimary(), this.character);
        this.equip.nameItemFromModifiers(this.character);
        this.refreshAvailList();
        this.refreshSelectedList();
        return true;
    }

    @Override
    public boolean setName(String name) {
        if (StringUtils.isEmpty(name)) {
            return false;
        }
        String aString = name.trim();
        if (aString.indexOf(124) >= 0 || aString.indexOf(58) >= 0 || aString.indexOf(59) >= 0 || aString.indexOf(44) >= 0) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_InvalidNameChar"));
            return false;
        }
        String oldName = "(" + this.equip.getItemNameFromModifiers() + ")";
        if (!(oldName = oldName.replaceAll(";:\\|,", "@")).toString().toUpperCase().startsWith("GENERIC ITEM")) {
            this.equip.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(oldName.toString()));
        }
        this.equip.setName(aString);
        return true;
    }

    @Override
    public boolean setSProp(String sprop) {
        String aString = StringUtils.trimToEmpty(sprop);
        if (aString.indexOf(124) >= 0 || aString.indexOf(58) >= 0 || aString.indexOf(59) >= 0) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_InvalidSpropChar"));
            return false;
        }
        this.equip.removeListFor(ListKey.SPECIAL_PROPERTIES);
        if (!aString.equals("")) {
            this.equip.addToListFor(ListKey.SPECIAL_PROPERTIES, SpecialProperty.createFromLst(aString));
        }
        return true;
    }

    @Override
    public boolean setCost(String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            return false;
        }
        String aString = newValue.trim();
        try {
            BigDecimal newCost = new BigDecimal(aString);
            if (newCost.doubleValue() < 0.0) {
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_CostNegativeErr"));
                return false;
            }
            this.equip.setCostMod("0");
            this.equip.setCostMod(newCost.subtract(this.equip.getCost(this.character)));
            return true;
        }
        catch (Exception e) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_InvalidNumberErr"));
            return false;
        }
    }

    @Override
    public boolean setWeight(String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            return false;
        }
        String aString = newValue.trim();
        try {
            BigDecimal newWeight = new BigDecimal(aString);
            if (newWeight.doubleValue() < 0.0) {
                this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_WeightNegativeErr"));
                return false;
            }
            this.equip.put(ObjectKey.WEIGHT_MOD, BigDecimal.ZERO);
            this.equip.put(ObjectKey.WEIGHT_MOD, newWeight.subtract(new BigDecimal(this.equip.getWeightAsDouble(this.character))));
            return true;
        }
        catch (Exception e) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getString("in_eqCust_InvalidNumberErr"));
            return false;
        }
    }

    @Override
    public boolean setDamage(String newValue) {
        if (StringUtils.isEmpty(newValue)) {
            return false;
        }
        String aString = newValue.trim();
        this.equip.put(StringKey.DAMAGE_OVERRIDE, aString);
        return true;
    }

    @Override
    public ListFacade<EquipModFacade> getAvailList(EquipmentBuilderFacade.EquipmentHead head) {
        return this.availListMap.get((Object)head);
    }

    @Override
    public ListFacade<EquipModFacade> getSelectedList(EquipmentBuilderFacade.EquipmentHead head) {
        return this.selectedListMap.get((Object)head);
    }

    @Override
    public EquipmentFacade getEquipment() {
        return this.equip;
    }

    private void refreshAvailList() {
        List<String> aFilter = this.equip.typeList();
        for (EquipmentBuilderFacade.EquipmentHead head : this.equipHeads) {
            ArrayList<EquipmentModifier> newEqMods = new ArrayList<EquipmentModifier>();
            block1: for (EquipmentModifier aEqMod : Globals.getContext().getReferenceContext().getConstructedCDOMObjects(EquipmentModifier.class)) {
                if (!this.equip.isVisible(aEqMod, head.isPrimary(), View.VISIBLE_DISPLAY)) continue;
                if (aEqMod.isType("ALL")) {
                    newEqMods.add(aEqMod);
                    continue;
                }
                for (String aType : aFilter) {
                    if (!aEqMod.isType(aType)) continue;
                    newEqMods.add(aEqMod);
                    continue block1;
                }
            }
            this.availListMap.get((Object)head).updateContents(newEqMods);
        }
    }

    private void refreshSelectedList() {
        for (EquipmentBuilderFacade.EquipmentHead eqHead : this.equipHeads) {
            this.selectedListMap.get((Object)eqHead).updateContents(this.equip.getEqModifierList(eqHead.isPrimary()));
        }
    }

    @Override
    public boolean canAddModifier(EquipModFacade eqModFacade, EquipmentBuilderFacade.EquipmentHead head) {
        if (!(eqModFacade instanceof EquipmentModifier)) {
            return false;
        }
        EquipmentModifier eqMod = (EquipmentModifier)eqModFacade;
        return this.equip.canAddModifier(eqMod, head.isPrimary());
    }

    @Override
    public boolean isResizable() {
        return Globals.canResizeHaveEffect(this.character, this.equip, this.equip.typeList());
    }

    @Override
    public void setSize(SizeAdjustmentFacade newSize) {
        if (newSize == null || !(newSize instanceof SizeAdjustment)) {
            return;
        }
        this.equip.resizeItem(this.character, (SizeAdjustment)newSize);
        this.equip.nameItemFromModifiers(this.character);
        this.sizeRef.setReference(newSize);
    }

    @Override
    public ReferenceFacade<SizeAdjustmentFacade> getSizeRef() {
        return this.sizeRef;
    }

    @Override
    public EnumSet<EquipmentBuilderFacade.EquipmentHead> getEquipmentHeads() {
        return this.equipHeads;
    }

    private boolean getSpellChoiceForEqMod(EquipmentModifier eqMod) {
        String choiceValue = eqMod.getSafe(StringKey.CHOICE_STRING).substring(15);
        SpellBuilderFacadeImpl spellBuilderFI = new SpellBuilderFacadeImpl(choiceValue, this.character, this.equip);
        if (!this.delegate.showCustomSpellDialog(spellBuilderFI)) {
            return false;
        }
        InfoFacade castingClass = spellBuilderFI.getClassRef().getReference();
        Spell theSpell = (Spell)spellBuilderFI.getSpellRef().getReference();
        String variant = spellBuilderFI.getVariantRef().getReference();
        if (variant == null) {
            variant = "";
        }
        String spellType = spellBuilderFI.getSpellTypeRef().getReference();
        int baseSpellLevel = spellBuilderFI.getSpellLevelRef().getReference();
        int casterLevel = spellBuilderFI.getCasterLevelRef().getReference();
        ListFacade<AbilityFacade> metamagicFeatsList = spellBuilderFI.getSelectedMetamagicFeats();
        Object[] metamagicFeats = new Object[metamagicFeatsList.getSize()];
        for (int i = 0; i < metamagicFeats.length; ++i) {
            metamagicFeats[i] = metamagicFeatsList.getElementAt(i);
        }
        int charges = this.getNumCharges(eqMod);
        EquipmentModifier existingEqMod = this.equip.getEqModifierKeyed(eqMod.getKeyName(), true);
        if (existingEqMod == null) {
            this.equip.addEqModifier(eqMod, true, this.character);
        }
        existingEqMod = this.equip.getEqModifierKeyed(eqMod.getKeyName(), true);
        EqModSpellInfo.setSpellInfo(this.equip, existingEqMod, (PObject)((Object)castingClass), theSpell, variant, spellType, baseSpellLevel, casterLevel, metamagicFeats, charges);
        return true;
    }

    private int getNumCharges(EquipmentModifier eqMod) {
        int charges = -1;
        Integer min = eqMod.get(IntegerKey.MIN_CHARGES);
        if (min != null && min > 0) {
            Integer max = eqMod.get(IntegerKey.MAX_CHARGES);
            while (true) {
                String selectedValue;
                if ((selectedValue = this.delegate.showInputDialog("PCGen", LanguageBundle.getFormattedString("in_csdChargesMessage", min, max), Integer.toString(max))) == null) {
                    continue;
                }
                try {
                    String aString = selectedValue.trim();
                    charges = Integer.parseInt(aString);
                    if (charges < min) continue;
                    if (charges <= max) break;
                }
                catch (NumberFormatException exc) {}
            }
        }
        return charges;
    }

    @Override
    public String getBaseItemName() {
        return this.equip.getBaseItemName();
    }

    @Override
    public boolean isWeapon() {
        return this.equip.isWeapon();
    }

    @Override
    public String getDamage() {
        return this.equip.getDamage(this.character);
    }
}

