/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.Equipment;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.util.AbstractListFacade;

public class EquipmentListFacadeImpl
extends AbstractListFacade<EquipmentFacade>
implements EquipmentListFacade {
    private ArrayList<EquipmentFacade> equipmentList;
    private Map<EquipmentFacade, Integer> quantityMap;

    public EquipmentListFacadeImpl() {
        this.equipmentList = new ArrayList();
        this.quantityMap = new HashMap<EquipmentFacade, Integer>();
    }

    public EquipmentListFacadeImpl(List<Equipment> list) {
        this.equipmentList = new ArrayList<Equipment>(list);
        this.quantityMap = new HashMap<EquipmentFacade, Integer>();
        for (Equipment equipment : list) {
            this.quantityMap.put(equipment, equipment.getQty().intValue());
        }
    }

    public void refresh(List<Equipment> list) {
        this.equipmentList = new ArrayList<Equipment>(list);
        this.quantityMap = new HashMap<EquipmentFacade, Integer>();
        for (Equipment equipment : list) {
            this.quantityMap.put(equipment, equipment.getQty().intValue());
        }
        this.fireElementsChanged(this);
    }

    @Override
    public void addEquipmentListListener(EquipmentListFacade.EquipmentListListener listener) {
        this.listenerList.add(EquipmentListFacade.EquipmentListListener.class, listener);
    }

    @Override
    public void removeEquipmentListListener(EquipmentListFacade.EquipmentListListener listener) {
        this.listenerList.remove(EquipmentListFacade.EquipmentListListener.class, listener);
    }

    private void fireQuantityChangedEvent(Object source, EquipmentFacade equipment, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        EquipmentListFacade.EquipmentListEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EquipmentListFacade.EquipmentListListener.class) continue;
            if (e == null) {
                e = new EquipmentListFacade.EquipmentListEvent(source, equipment, index);
            }
            ((EquipmentListFacade.EquipmentListListener)listeners[i + 1]).quantityChanged(e);
        }
    }

    public void addElement(EquipmentFacade equipment, int quantity) {
        this.equipmentList.add(equipment);
        this.quantityMap.put(equipment, quantity);
        this.fireElementAdded(this, equipment, this.equipmentList.size() - 1);
    }

    public void removeElement(EquipmentFacade equipment) {
        int index = this.equipmentList.indexOf(equipment);
        if (index != -1) {
            this.equipmentList.remove(equipment);
            this.quantityMap.remove(equipment);
            this.fireElementRemoved(this, equipment, index);
        }
    }

    @Override
    public int getQuantity(EquipmentFacade equipment) {
        if (this.quantityMap.containsKey(equipment)) {
            return this.quantityMap.get(equipment);
        }
        return 0;
    }

    public void setQuantity(EquipmentFacade equipment, int quantity) {
        this.quantityMap.put(equipment, quantity);
        this.fireQuantityChangedEvent(this, equipment, this.equipmentList.indexOf(equipment));
    }

    @Override
    public EquipmentFacade getElementAt(int index) {
        return this.equipmentList.get(index);
    }

    @Override
    public int getSize() {
        return this.equipmentList.size();
    }

    @Override
    public void modifyElement(EquipmentFacade equipment) {
        this.fireElementModified(this, equipment, this.equipmentList.indexOf(equipment));
    }
}

