/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import pcgen.gui2.util.ComboSelectionDialog;

public class ComboSelectionBox
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 4240590146578106112L;
    private ComboSelectionDialog dialog;
    private MutableComboBoxModel model;
    private JComboBox comboBox;
    private JButton button;

    public ComboSelectionBox() {
        super(new BorderLayout());
        this.initComponents();
    }

    private void initComponents() {
        this.comboBox = new JComboBox();
        this.setBorder(this.comboBox.getBorder());
        this.comboBox.setBorder(BorderFactory.createEmptyBorder());
        this.button = new JButton(new ButtonAction());
        this.button.setEnabled(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.add((Component)this.comboBox, "Center");
        this.add((Component)this.button, "After");
    }

    private void checkButton() {
        if (this.dialog != null && this.model != null) {
            this.dialog.setModel(this.model);
            this.button.setEnabled(true);
        } else {
            this.button.setEnabled(false);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.comboBox.setEnabled(enabled);
        if (enabled) {
            this.checkButton();
        } else {
            this.button.setEnabled(false);
        }
    }

    public void setModel(MutableComboBoxModel model) {
        this.model = model;
        this.comboBox.setModel(model);
        this.checkButton();
    }

    public void setDialog(ComboSelectionDialog dialog) {
        this.dialog = dialog;
        this.checkButton();
    }

    public Object getSelectedItem() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public Object[] getSelectedObjects() {
        return this.comboBox.getSelectedObjects();
    }

    @Override
    public void addItemListener(ItemListener l) {
        this.comboBox.addItemListener(l);
    }

    @Override
    public void removeItemListener(ItemListener l) {
        this.comboBox.removeItemListener(l);
    }

    private class ButtonAction
    extends AbstractAction {
        public ButtonAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComboSelectionBox.this.dialog.display();
                }
            });
        }
    }
}

