/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.core.AbilityCategory;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.LstLineFileLoader;
import pcgen.persistence.lst.OverlapLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;

public class AbilityCategoryLoader
extends LstLineFileLoader {
    private OverlapLoader<AbilityCategory> loader = new OverlapLoader<AbilityCategory>(AbilityCategory.class);

    @Override
    public void parseLine(LoadContext context, String lstLine, URI sourceURI) throws PersistenceLayerException {
        int colonLoc = lstLine.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Line - does not contain a colon: '" + lstLine + "' in " + sourceURI);
            return;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Line - starts with a colon: '" + lstLine + "' in " + sourceURI);
            return;
        }
        if (colonLoc == lstLine.length() - 1) {
            Logging.errorPrint("Invalid Line - ends with a colon: '" + lstLine + "' in " + sourceURI);
            return;
        }
        String key = lstLine.substring(0, colonLoc);
        String value = lstLine.substring(colonLoc + 1);
        if (!"ABILITYCATEGORY".equals(key)) {
            Logging.errorPrint("Invalid Line - expected 'ABILITYCATEGORY' key to start the line: '" + lstLine + "' in " + sourceURI);
            return;
        }
        this.loader.parseLine(context, value, sourceURI);
    }
}

