/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Equipment;
import pcgen.core.PCTemplate;
import pcgen.core.Race;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteOperator;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreTypeTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    @Override
    public String kindHandled() {
        return "TYPE";
    }

    @Override
    public int passes(Prerequisite prereq, Equipment equipment, CharacterDisplay display) throws PrerequisiteException {
        String requiredType = prereq.getKey();
        int runningTotal = 0;
        if (prereq.getOperator().equals((Object)PrerequisiteOperator.EQ)) {
            if (equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else if (prereq.getOperator().equals((Object)PrerequisiteOperator.NEQ)) {
            if (!equipment.isPreType(requiredType)) {
                ++runningTotal;
            }
        } else {
            throw new PrerequisiteException(LanguageBundle.getFormattedString("PreType.error.invalidComparison", prereq.getOperator().toString(), prereq.toString()));
        }
        runningTotal = this.countedTotal(prereq, runningTotal);
        return runningTotal;
    }

    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) {
        Logging.errorPrint("PRETYPE has been deprecated for non-Equipment Prerequisites.\n  Please use PRERACE as an alternative");
        if (display == null) {
            return 0;
        }
        String requiredType = prereq.getKey();
        Logging.errorPrint("  PRETYPE value was: " + requiredType + "\n");
        int numRequired = Integer.parseInt(prereq.getOperand());
        int runningTotal = 0;
        for (String element : PreTypeTester.getTypes(display)) {
            if (!element.equalsIgnoreCase(requiredType)) continue;
            ++runningTotal;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, numRequired);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String toHtmlString(Prerequisite prereq) {
        return LanguageBundle.getFormattedString("PreType.toHtml", prereq.getOperator().toDisplayString(), prereq.getKey());
    }

    @Deprecated
    private static List<String> getTypes(CharacterDisplay display) {
        ArrayList<String> list = new ArrayList<String>();
        Race race = display.getRace();
        if (race != null) {
            list.add(race.getType());
        } else {
            list.add("Humanoid");
        }
        for (PCTemplate t : display.getTemplateSet()) {
            list.add(t.getType());
        }
        return list;
    }
}

