
// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest C++ Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
#pragma once

#include <azure/core/case_insensitive_containers.hpp>
#include <azure/core/context.hpp>
#include <azure/core/datetime.hpp>
#include <azure/core/etag.hpp>
#include <azure/core/http/http.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/internal/http/pipeline.hpp>
#include <azure/core/io/body_stream.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/response.hpp>
#include <azure/core/url.hpp>
#include <azure/storage/common/storage_common.hpp>
#include <azure/storage/files/shares/dll_import_export.hpp>

#include <cstdint>
#include <map>
#include <memory>
#include <string>
#include <type_traits>
#include <vector>

namespace Azure { namespace Storage { namespace Files { namespace Shares {
  namespace _detail {
    /**
     * The version used for the operations to Azure storage services.
     */
    constexpr static const char* ApiVersion = "2026-02-06";
  } // namespace _detail
  namespace Models {
    /**
     * @brief The retention policy.
     */
    struct RetentionPolicy final
    {
      /**
       * Indicates whether a retention policy is enabled for the File service. If false, metrics
       * data is retained, and the user is responsible for deleting it.
       */
      bool Enabled = bool();
      /**
       * Indicates the number of days that metrics data should be retained. All data older than this
       * value will be deleted. Metrics data is deleted on a best-effort basis after the retention
       * period expires.
       */
      Nullable<std::int32_t> Days;
    };
    /**
     * @brief Storage Analytics metrics for file service.
     */
    struct Metrics final
    {
      /**
       * The version of Storage Analytics to configure.
       */
      std::string Version;
      /**
       * Indicates whether metrics are enabled for the File service.
       */
      bool Enabled = bool();
      /**
       * Indicates whether metrics should generate summary statistics for called API operations.
       */
      Nullable<bool> IncludeApis;
      /**
       * The retention policy.
       */
      Models::RetentionPolicy RetentionPolicy;
    };
    /**
     * @brief CORS is an HTTP feature that enables a web application running under one domain to
     * access resources in another domain. Web browsers implement a security restriction known as
     * same-origin policy that prevents a web page from calling APIs in a different domain; CORS
     * provides a secure way to allow one domain (the origin domain) to call APIs in another domain.
     */
    struct CorsRule final
    {
      /**
       * The origin domains that are permitted to make a request against the storage service via
       * CORS. The origin domain is the domain from which the request originates. Note that the
       * origin must be an exact case-sensitive match with the origin that the user age sends to the
       * service. You can also use the wildcard character '*' to allow all origin domains to make
       * requests via CORS.
       */
      std::string AllowedOrigins;
      /**
       * The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma
       * separated).
       */
      std::string AllowedMethods;
      /**
       * The request headers that the origin domain may specify on the CORS request.
       */
      std::string AllowedHeaders;
      /**
       * The response headers that may be sent in the response to the CORS request and exposed by
       * the browser to the request issuer.
       */
      std::string ExposedHeaders;
      /**
       * The maximum amount time that a browser should cache the preflight OPTIONS request.
       */
      std::int32_t MaxAgeInSeconds = std::int32_t();
    };
    /**
     * @brief Settings for SMB multichannel.
     */
    struct SmbMultichannel final
    {
      /**
       * If SMB multichannel is enabled.
       */
      bool Enabled = bool();
    };
    /**
     * @brief Enable or disable encryption in transit.
     */
    struct SmbEncryptionInTransit final
    {
      /**
       * If encryption in transit is required.
       */
      bool Required = bool();
    };
    /**
     * @brief Settings for SMB protocol.
     */
    struct SmbSettings final
    {
      /**
       * Settings for SMB Multichannel.
       */
      Nullable<SmbMultichannel> Multichannel;
      /**
       * Enable or disable encryption in transit.
       */
      Nullable<SmbEncryptionInTransit> EncryptionInTransit;
    };
    /**
     * @brief Enable or disable encryption in transit.
     */
    struct NfsEncryptionInTransit final
    {
      /**
       * If encryption in transit is required.
       */
      bool Required = bool();
    };
    /**
     * @brief Settings for SMB protocol.
     */
    struct NfsSettings final
    {
      /**
       * Enable or disable encryption in transit.
       */
      Nullable<NfsEncryptionInTransit> EncryptionInTransit;
    };
    /**
     * @brief Protocol settings.
     */
    struct ProtocolSettings final
    {
      /**
       * Settings for SMB protocol.
       */
      Nullable<SmbSettings> Settings;
      /**
       * Settings for NFS protocol.
       */
      Nullable<Models::NfsSettings> NfsSettings;
    };
    /**
     * @brief Valid value is backup.
     */
    class ShareTokenIntent final : public Core::_internal::ExtendableEnumeration<ShareTokenIntent> {
    public:
      /** Constructs a new ShareTokenIntent instance */
      ShareTokenIntent() = default;
      /** Constructs a new ShareTokenIntent from a string. */
      explicit ShareTokenIntent(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type ShareTokenIntent: Backup */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareTokenIntent Backup;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareServiceClient::SetProperties.
     */
    struct SetServicePropertiesResult final
    {
    };
    /**
     * @brief Storage service properties.
     */
    struct ShareServiceProperties final
    {
      /**
       * A summary of request statistics grouped by API in hourly aggregates for files.
       */
      Metrics HourMetrics;
      /**
       * A summary of request statistics grouped by API in minute aggregates for files.
       */
      Metrics MinuteMetrics;
      /**
       * The set of CORS rules.
       */
      std::vector<CorsRule> Cors;
      /**
       * Protocol settings.
       */
      Nullable<ProtocolSettings> Protocol;
    };
    /**
     * @brief Specifies the access tier of the share.
     */
    class AccessTier final : public Core::_internal::ExtendableEnumeration<AccessTier> {
    public:
      /** Constructs a new AccessTier instance */
      AccessTier() = default;
      /** Constructs a new AccessTier from a string. */
      explicit AccessTier(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type AccessTier: TransactionOptimized */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessTier TransactionOptimized;
      /** Constant value of type AccessTier: Hot */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessTier Hot;
      /** Constant value of type AccessTier: Cool */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessTier Cool;
      /** Constant value of type AccessTier: Premium */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessTier Premium;
    };
    /**
     * @brief The current lease status of the share.
     */
    class LeaseStatus final : public Core::_internal::ExtendableEnumeration<LeaseStatus> {
    public:
      /** Constructs a new LeaseStatus instance */
      LeaseStatus() = default;
      /** Constructs a new LeaseStatus from a string. */
      explicit LeaseStatus(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type LeaseStatus: Locked */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseStatus Locked;
      /** Constant value of type LeaseStatus: Unlocked */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseStatus Unlocked;
    };
    /**
     * @brief Lease state of the share.
     */
    class LeaseState final : public Core::_internal::ExtendableEnumeration<LeaseState> {
    public:
      /** Constructs a new LeaseState instance */
      LeaseState() = default;
      /** Constructs a new LeaseState from a string. */
      explicit LeaseState(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type LeaseState: Available */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseState Available;
      /** Constant value of type LeaseState: Leased */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseState Leased;
      /** Constant value of type LeaseState: Expired */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseState Expired;
      /** Constant value of type LeaseState: Breaking */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseState Breaking;
      /** Constant value of type LeaseState: Broken */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseState Broken;
    };
    /**
     * @brief When a share is leased, specifies whether the lease is of infinite or fixed duration.
     */
    class LeaseDurationType final
        : public Core::_internal::ExtendableEnumeration<LeaseDurationType> {
    public:
      /** Constructs a new LeaseDurationType instance */
      LeaseDurationType() = default;
      /** Constructs a new LeaseDurationType from a string. */
      explicit LeaseDurationType(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type LeaseDurationType: Infinite */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseDurationType Infinite;
      /** Constant value of type LeaseDurationType: Fixed */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static LeaseDurationType Fixed;
    };
    /**
     * @brief The protocols that have been enabled on the share.
     */
    class ShareProtocols final : public Core::_internal::ExtendableEnumeration<ShareProtocols> {
    public:
      /** Constructs a new ShareProtocols instance */
      ShareProtocols() = default;
      /** Constructs a new ShareProtocols from a string. */
      explicit ShareProtocols(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type ShareProtocols: Smb */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareProtocols Smb;
      /** Constant value of type ShareProtocols: Nfs */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareProtocols Nfs;
    };
    /**
     * @brief Root squash to set on the share.  Only valid for NFS shares.
     */
    class ShareRootSquash final : public Core::_internal::ExtendableEnumeration<ShareRootSquash> {
    public:
      /** Constructs a new ShareRootSquash instance */
      ShareRootSquash() = default;
      /** Constructs a new ShareRootSquash from a string. */
      explicit ShareRootSquash(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type ShareRootSquash: NoRootSquash */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareRootSquash NoRootSquash;
      /** Constant value of type ShareRootSquash: RootSquash */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareRootSquash RootSquash;
      /** Constant value of type ShareRootSquash: AllSquash */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ShareRootSquash AllSquash;
    };
    /**
     * @brief Properties of a share.
     */
    struct ShareItemDetails final
    {
      /**
       * The date and time the share was last modified.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value which represents the version of the share, in quotes.
       */
      ETag Etag;
      /**
       * The Quota for the item.
       */
      std::int64_t Quota = std::int64_t();
      /**
       * Provisioned Iops.
       */
      Nullable<std::int32_t> ProvisionedIops;
      /**
       * Provisioned Ingress MBps.
       */
      Nullable<std::int32_t> ProvisionedIngressMBps;
      /**
       * Provisioned Egress MBps.
       */
      Nullable<std::int32_t> ProvisionedEgressMBps;
      /**
       * Provisioned Bandwidth MBps.
       */
      Nullable<std::int32_t> ProvisionedBandwidthMBps;
      /**
       * Next allowed Quota Downgrade Time.
       */
      Nullable<DateTime> NextAllowedQuotaDowngradeTime;
      /**
       * Time the item was deleted.
       */
      Nullable<DateTime> DeletedOn;
      /**
       * Remaining retention days.
       */
      std::int32_t RemainingRetentionDays = std::int32_t();
      /**
       * Specifies the access tier of the share.
       */
      Nullable<Models::AccessTier> AccessTier;
      /**
       * Indicates the time the access tier was last changed.
       */
      Nullable<DateTime> AccessTierChangedOn;
      /**
       * Indicates the access tier transition state.
       */
      Nullable<std::string> AccessTierTransitionState;
      /**
       * The current lease status of the share.
       */
      Models::LeaseStatus LeaseStatus;
      /**
       * Lease state of the share.
       */
      Models::LeaseState LeaseState;
      /**
       * When a share is leased, specifies whether the lease is of infinite or fixed duration.
       */
      LeaseDurationType LeaseDuration;
      /**
       * The protocols which have been enabled on the share.
       */
      Nullable<ShareProtocols> EnabledProtocols;
      /**
       * Root squash to set on the share.  Only valid for NFS shares.
       */
      Nullable<ShareRootSquash> RootSquash;
      /**
       * Version 2023-08-03 and newer. Specifies whether the snapshot virtual directory should be
       * accessible at the root of share mount point when NFS is enabled. This header is only
       * returned for shares, not for snapshots.
       */
      Nullable<bool> EnableSnapshotVirtualDirectoryAccess;
      /**
       * Optional. Boolean. Default if not specified is false. This property enables paid bursting.
       */
      Nullable<bool> PaidBurstingEnabled;
      /**
       * Optional. Integer. Default if not specified is the maximum IOPS the file share can support.
       * Current maximum for a file share is 102,400 IOPS.
       */
      Nullable<std::int64_t> PaidBurstingMaxIops;
      /**
       * Optional. Integer. Default if not specified is the maximum throughput the file share can
       * support. Current maximum for a file share is 10,340 MiB/sec.
       */
      Nullable<std::int64_t> PaidBurstingMaxBandwidthMibps;
      /**
       * Return the calculated burst IOPS of the share.
       */
      Nullable<std::int64_t> IncludedBurstIops;
      /**
       * Return the calculated maximum burst credits. This is not the current burst credit level,
       * but the maximum burst credits the share can have.
       */
      Nullable<std::int64_t> MaxBurstCreditsForIops;
      /**
       * Return timestamp for provisioned IOPS following existing rules for provisioned storage GiB.
       */
      Nullable<DateTime> NextAllowedProvisionedIopsDowngradeTime;
      /**
       * Return timestamp for provisioned throughput following existing rules for provisioned
       * storage GiB.
       */
      Nullable<DateTime> NextAllowedProvisionedBandwidthDowngradeTime;
    };
    /**
     * @brief A listed Azure Storage share item.
     */
    struct ShareItem final
    {
      /**
       * The name of the share.
       */
      std::string Name;
      /**
       * The snapshot of the share.
       */
      std::string Snapshot;
      /**
       * True if the share is deleted.
       */
      bool Deleted = bool();
      /**
       * The version of the share.
       */
      std::string Version;
      /**
       * A set of name-value pairs associated with the share or file.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * Properties of a share.
       */
      ShareItemDetails Details;
    };
    /**
     * @brief Include this parameter to specify one or more datasets to include in the response.
     */
    enum class ListSharesIncludeFlags
    {
      None = 0,
      Snapshots = 1,
      Metadata = 2,
      Deleted = 4,
    };
    inline ListSharesIncludeFlags operator|(ListSharesIncludeFlags lhs, ListSharesIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListSharesIncludeFlags>;
      return static_cast<ListSharesIncludeFlags>(static_cast<type>(lhs) | static_cast<type>(rhs));
    }
    inline ListSharesIncludeFlags& operator|=(
        ListSharesIncludeFlags& lhs,
        ListSharesIncludeFlags rhs)
    {
      lhs = lhs | rhs;
      return lhs;
    }
    inline ListSharesIncludeFlags operator&(ListSharesIncludeFlags lhs, ListSharesIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListSharesIncludeFlags>;
      return static_cast<ListSharesIncludeFlags>(static_cast<type>(lhs) & static_cast<type>(rhs));
    }
    inline ListSharesIncludeFlags& operator&=(
        ListSharesIncludeFlags& lhs,
        ListSharesIncludeFlags rhs)
    {
      lhs = lhs & rhs;
      return lhs;
    }
    namespace _detail {
      /**
       * @brief An enumeration of shares.
       */
      struct ListSharesResponse final
      {
        std::string ServiceEndpoint;
        Nullable<std::string> Prefix;
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        /**
         * Array of ShareItem.
         */
        std::vector<ShareItem> ShareItems;
        std::string NextMarker;
      };
      /**
       * @brief Key information.
       */
      struct KeyInfo final
      {
        /**
         * The date-time the key is active in ISO 8601 UTC time.
         */
        Nullable<std::string> Start;
        /**
         * The date-time the key expires in ISO 8601 UTC time.
         */
        std::string Expiry;
      };
    } // namespace _detail
    /**
     * @brief A user delegation key.
     */
    struct UserDelegationKey final
    {
      /**
       * The Azure Active Directory object ID in GUID format.
       */
      std::string SignedObjectId;
      /**
       * The Azure Active Directory tenant ID in GUID format.
       */
      std::string SignedTenantId;
      /**
       * The date-time the key is active.
       */
      DateTime SignedStartsOn;
      /**
       * The date-time the key expires.
       */
      DateTime SignedExpiresOn;
      /**
       * Abbreviation of the Azure Storage service that accepts the key.
       */
      std::string SignedService;
      /**
       * The service version that created the key.
       */
      std::string SignedVersion;
      /**
       * The key as a base64 string.
       */
      std::string Value;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::Create.
     */
    struct CreateShareResult final
    {
      /**
       * Indicates if the share was successfully created by this operation.
       */
      bool Created = true;
      /**
       * The ETag contains a value which represents the version of the share, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties or metadata updates the last modified time. Operations on files do
       * not affect the last modified time of the share.
       */
      DateTime LastModified;
      /**
       * Returns the current share quota in GB.
       */
      Nullable<std::int64_t> Quota;
      /**
       * The provisioned IOPS of the share.
       */
      Nullable<std::int64_t> ShareProvisionedIops;
      /**
       * The provisioned throughput of the share.
       */
      Nullable<std::int64_t> ShareProvisionedBandwidthMibps;
      /**
       * Returns the calculated burst IOPS of the share.
       */
      Nullable<std::int64_t> ShareIncludedBurstIops;
      /**
       * Returned the calculated maximum burst credits.
       */
      Nullable<std::int64_t> MaxBurstCreditsForIops;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::GetProperties.
     */
    struct ShareProperties final
    {
      /**
       * Specifies the access tier of the share.
       */
      Nullable<Models::AccessTier> AccessTier;
      /**
       * A set of name-value pairs that contain the user-defined metadata of the share.
       */
      Core::CaseInsensitiveMap Metadata;
      /**
       * The ETag contains a value that you can use to perform operations conditionally, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties updates the last modified time. Operations on files do not affect
       * the last modified time of the share.
       */
      DateTime LastModified;
      /**
       * Returns the current share quota in GB.
       */
      std::int64_t Quota = std::int64_t();
      /**
       * Returns the current share provisioned IOPS.
       */
      Nullable<std::int32_t> ProvisionedIops;
      /**
       * Returns the current share provisioned ingress in megabytes per second.
       */
      Nullable<std::int32_t> ProvisionedIngressMBps;
      /**
       * Returns the current share provisioned egress in megabytes per second.
       */
      Nullable<std::int32_t> ProvisionedEgressMBps;
      /**
       * Returns the current share next allowed quota downgrade time.
       */
      Nullable<DateTime> NextAllowedQuotaDowngradeTime;
      /**
       * Returns the current share provisioned bandwidth in mebibytes per second.
       */
      Nullable<std::int32_t> ProvisionedBandwidthMBps;
      /**
       * When a share is leased, specifies whether the lease is of infinite or fixed duration.
       */
      Nullable<LeaseDurationType> LeaseDuration;
      /**
       * Lease state of the share.
       */
      Nullable<Models::LeaseState> LeaseState;
      /**
       * The current lease status of the share.
       */
      Nullable<Models::LeaseStatus> LeaseStatus;
      /**
       * Returns the last modified time (in UTC) of the access tier of the share.
       */
      Nullable<DateTime> AccessTierChangedOn;
      /**
       * Returns the transition state between access tiers, when present.
       */
      Nullable<std::string> AccessTierTransitionState;
      /**
       * The protocols that have been enabled on the share.
       */
      Nullable<ShareProtocols> EnabledProtocols;
      /**
       * Valid for NFS shares only.
       */
      Nullable<ShareRootSquash> RootSquash;
      /**
       * Version 2023-08-03 and newer. Specifies whether the snapshot virtual directory should be
       * accessible at the root of share mount point when NFS is enabled. This header is only
       * returned for shares, not for snapshots.
       */
      Nullable<bool> EnableSnapshotVirtualDirectoryAccess;
      /**
       * Optional. Boolean. Default if not specified is false. This property enables paid bursting.
       */
      Nullable<bool> PaidBurstingEnabled;
      /**
       * Optional. Integer. Default if not specified is the maximum IOPS the file share can support.
       * Current maximum for a file share is 102,400 IOPS.
       */
      Nullable<std::int64_t> PaidBurstingMaxIops;
      /**
       * Optional. Integer. Default if not specified is the maximum throughput the file share can
       * support. Current maximum for a file share is 10,340 MiB/sec.
       */
      Nullable<std::int64_t> PaidBurstingMaxBandwidthMibps;
      /**
       * Return the calculated burst IOPS of the share.
       */
      Nullable<std::int64_t> IncludedBurstIops;
      /**
       * Returned the calculated maximum burst credits. This is not the current burst credit level,
       * but the maximum burst credits the share can have.
       */
      Nullable<std::int64_t> MaxBurstCreditsForIops;
      /**
       * Returns the current share next allowed provisioned iops downgrade time.
       */
      Nullable<DateTime> NextAllowedProvisionedIopsDowngradeTime;
      /**
       * Returns the current share next allowed provisioned bandwidth downgrade time.
       */
      Nullable<DateTime> NextAllowedProvisionedBandwidthDowngradeTime;
    };
    /**
     * @brief Specifies the option include to delete the base share and all of its snapshots.
     */
    class DeleteSnapshotsOption final
        : public Core::_internal::ExtendableEnumeration<DeleteSnapshotsOption> {
    public:
      /** Constructs a new DeleteSnapshotsOption instance */
      DeleteSnapshotsOption() = default;
      /** Constructs a new DeleteSnapshotsOption from a string. */
      explicit DeleteSnapshotsOption(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type DeleteSnapshotsOption: Include */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static DeleteSnapshotsOption Include;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::Delete.
     */
    struct DeleteShareResult final
    {
      /**
       * Indicates if the share was successfully deleted by this operation.
       */
      bool Deleted = true;
      /**
       * Returned only for provisioned v2 file shares. Returns an approximate used storage size of
       * the share, in bytes.
       */
      Nullable<std::int64_t> ShareUsageBytes;
      /**
       * Returned only for provisioned v2 file shares. Returns an approximate used snapshot storage
       * size of the share, in bytes.
       */
      Nullable<std::int64_t> ShareSnapshotUsageBytes;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::AcquireLease.
       */
      struct AcquireShareLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * share or its properties updates the last modified time. Operations on files do not affect
         * the last modified time of the share.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a share's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::ReleaseLease.
       */
      struct ReleaseShareLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * share or its properties updates the last modified time. Operations on files do not affect
         * the last modified time of the share.
         */
        DateTime LastModified;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::ChangeLease.
       */
      struct ChangeShareLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * share or its properties updates the last modified time. Operations on files do not affect
         * the last modified time of the share.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a share's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::RenewLease.
       */
      struct RenewShareLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * share or its properties updates the last modified time. Operations on files do not affect
         * the last modified time of the share.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a share's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::BreakLease.
       */
      struct BreakShareLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * share or its properties updates the last modified time. Operations on files do not affect
         * the last modified time of the share.
         */
        DateTime LastModified;
        /**
         * Approximate time remaining in the lease period, in seconds.
         */
        std::int32_t LeaseTime = std::int32_t();
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::CreateSnapshot.
     */
    struct CreateShareSnapshotResult final
    {
      /**
       * This header is a DateTime value that uniquely identifies the share snapshot. The value of
       * this header may be used in subsequent requests to access the share snapshot. This value is
       * opaque.
       */
      std::string Snapshot;
      /**
       * The ETag contains a value which represents the version of the share snapshot, in quotes. A
       * share snapshot cannot be modified, so the ETag of a given share snapshot never changes.
       * However, if new metadata was supplied with the Snapshot Share request then the ETag of the
       * share snapshot differs from that of the base share. If no metadata was specified with the
       * request, the ETag of the share snapshot is identical to that of the base share at the time
       * the share snapshot was taken.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. A share snapshot cannot be modified,
       * so the last modified time of a given share snapshot never changes. However, if new metadata
       * was supplied with the Snapshot Share request then the last modified time of the share
       * snapshot differs from that of the base share. If no metadata was specified with the
       * request, the last modified time of the share snapshot is identical to that of the base
       * share at the time the share snapshot was taken.
       */
      DateTime LastModified;
    };
    /**
     * @brief Optional. Available for version 2023-06-01 and later. Specifies the format in which
     * the permission is returned. Acceptable values are SDDL or binary. If
     * x-ms-file-permission-format is unspecified or explicitly set to SDDL, the permission is
     * returned in SDDL format. If x-ms-file-permission-format is explicitly set to binary, the
     * permission is returned as a base64 string representing the binary encoding of the permission.
     */
    class FilePermissionFormat final
        : public Core::_internal::ExtendableEnumeration<FilePermissionFormat> {
    public:
      /** Constructs a new FilePermissionFormat instance */
      FilePermissionFormat() = default;
      /** Constructs a new FilePermissionFormat from a string. */
      explicit FilePermissionFormat(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type FilePermissionFormat: Sddl */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FilePermissionFormat Sddl;
      /** Constant value of type FilePermissionFormat: Binary */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FilePermissionFormat Binary;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::CreatePermission.
     */
    struct CreateSharePermissionResult final
    {
      /**
       * Key of the permission set for the directory/file.
       */
      std::string FilePermissionKey;
    };
    namespace _detail {
      /**
       * @brief A permission (a security descriptor) at the share level.
       */
      struct SharePermission final
      {
        /**
         * The permission in the Security Descriptor Definition Language (SDDL).
         */
        std::string Permission;
        Nullable<FilePermissionFormat> Format;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::SetProperties.
     */
    struct SetSharePropertiesResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties updates the last modified time. Operations on files do not affect
       * the last modified time of the share.
       */
      DateTime LastModified;
      /**
       * Returns the current share quota in GB.
       */
      Nullable<std::int64_t> Quota;
      /**
       * Returns the current share provisioned IOPS.
       */
      Nullable<std::int64_t> ProvisionedIops;
      /**
       * Returns the current share provisioned bandwidth in mebibytes per second.
       */
      Nullable<std::int64_t> ProvisionedBandwidthMibps;
      /**
       * Return the calculated burst IOPS of the share.
       */
      Nullable<std::int64_t> IncludedBurstIops;
      /**
       * Returned the calculated maximum burst credits. This is not the current burst credit level,
       * but the maximum burst credits the share can have.
       */
      Nullable<std::int64_t> MaxBurstCreditsForIops;
      /**
       * Returns the current share next allowed quota downgrade time.
       */
      Nullable<DateTime> NextAllowedQuotaDowngradeTime;
      /**
       * Returns the current share next allowed provisioned iops downgrade time.
       */
      Nullable<DateTime> NextAllowedProvisionedIopsDowngradeTime;
      /**
       * Returns the current share next allowed provisioned bandwidth downgrade time.
       */
      Nullable<DateTime> NextAllowedProvisionedBandwidthDowngradeTime;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::SetMetadata.
     */
    struct SetShareMetadataResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties updates the last modified time. Operations on files do not affect
       * the last modified time of the share.
       */
      DateTime LastModified;
    };
    /**
     * @brief An Access policy.
     */
    struct AccessPolicy final
    {
      /**
       * The date-time the policy is active.
       */
      Nullable<DateTime> StartsOn;
      /**
       * The date-time the policy expires.
       */
      Nullable<DateTime> ExpiresOn;
      /**
       * The permissions for the ACL policy.
       */
      std::string Permission;
    };
    /**
     * @brief Signed identifier.
     */
    struct SignedIdentifier final
    {
      /**
       * A unique id.
       */
      std::string Id;
      /**
       * The access policy.
       */
      AccessPolicy Policy;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::GetAccessPolicy.
     */
    struct ShareAccessPolicy final
    {
      /**
       * A collection of signed identifiers.
       */
      std::vector<SignedIdentifier> SignedIdentifiers;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareClient::SetAccessPolicy.
     */
    struct SetShareAccessPolicyResult final
    {
      /**
       * The ETag contains a value that you can use to perform operations conditionally, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties updates the last modified time. Operations on files do not affect
       * the last modified time of the share.
       */
      DateTime LastModified;
    };
    /**
     * @brief Stats for the share.
     */
    struct ShareStatistics final
    {
      /**
       * The approximate size of the data stored in bytes. Note that this value may not include all
       * recently created or recently resized files.
       */
      std::int64_t ShareUsageInBytes = std::int64_t();
      /**
       * The ETag contains a value that you can use to perform operations conditionally, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the share was last modified. Any operation that modifies the
       * share or its properties updates the last modified time. Operations on files do not affect
       * the last modified time of the share.
       */
      DateTime LastModified;
    };
    /**
     * @brief Attributes for a file or directory.
     */
    class FileAttributes final {
    public:
      /** Constructs a new FileAttributes instance. */
      FileAttributes() = default;
      /** Constructs a new FileAttributes from a string. */
      explicit FileAttributes(const std::string& value);
      /** Compares with another FileAttributes. */
      bool operator==(const FileAttributes& other) const { return m_value == other.m_value; }
      /** Compares with another FileAttributes. */
      bool operator!=(const FileAttributes& other) const { return !(*this == other); }
      /** Converts this instance to its string representation. */
      std::string ToString() const;
      /** Returns the values as an array.*/
      const std::vector<std::string>& GetValues() const { return m_value; }
      /** Bitwise OR of two instances. */
      FileAttributes operator|(const FileAttributes& other) const;
      /** Bitwise AND of two instances. */
      FileAttributes operator&(const FileAttributes& other) const;
      /** Bitwise XOR of two instances. */
      FileAttributes operator^(const FileAttributes& other) const;
      /** Bitwise OR and assignment of two instances. */
      FileAttributes& operator|=(const FileAttributes& other)
      {
        *this = *this | other;
        return *this;
      }
      /** Bitwise AND and assignment of two instances. */
      FileAttributes& operator&=(const FileAttributes& other)
      {
        *this = *this & other;
        return *this;
      }
      /** Bitwise XOR and assignment of two instances. */
      FileAttributes& operator^=(const FileAttributes& other)
      {
        *this = *this ^ other;
        return *this;
      }

      /** Constant value of type FileAttributes: ReadOnly */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes ReadOnly;
      /** Constant value of type FileAttributes: Hidden */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes Hidden;
      /** Constant value of type FileAttributes: System */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes System;
      /** Constant value of type FileAttributes: None */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes None;
      /** Constant value of type FileAttributes: Directory */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes Directory;
      /** Constant value of type FileAttributes: Archive */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes Archive;
      /** Constant value of type FileAttributes: Temporary */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes Temporary;
      /** Constant value of type FileAttributes: Offline */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes Offline;
      /** Constant value of type FileAttributes: NotContentIndexed */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes NotContentIndexed;
      /** Constant value of type FileAttributes: NoScrubData */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileAttributes NoScrubData;

    private:
      std::vector<std::string> m_value;
    };
    /**
     * @brief The SMB related properties for the file.
     */
    struct FileSmbProperties final
    {
      /**
       * Permission key for the directory or file.
       */
      Nullable<std::string> PermissionKey;
      /**
       * Attributes for the file or directory.
       */
      FileAttributes Attributes;
      /**
       * Creation time for the file or directory.
       */
      Nullable<DateTime> CreatedOn;
      /**
       * Last write time for the file or directory.
       */
      Nullable<DateTime> LastWrittenOn;
      /**
       * Changed time for the file or directory.
       */
      Nullable<DateTime> ChangedOn;
      /**
       * The fileId of the file.
       */
      std::string FileId;
      /**
       * The parentId of the file.
       */
      std::string ParentFileId;
    };
    /**
     * @brief NFS only. Type of the file or directory.
     */
    class NfsFileType final : public Core::_internal::ExtendableEnumeration<NfsFileType> {
    public:
      /** Constructs a new NfsFileType instance */
      NfsFileType() = default;
      /** Constructs a new NfsFileType from a string. */
      explicit NfsFileType(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type NfsFileType: Regular */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static NfsFileType Regular;
      /** Constant value of type NfsFileType: Directory */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static NfsFileType Directory;
      /** Constant value of type NfsFileType: SymLink */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static NfsFileType SymLink;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareDirectoryClient::Create.
       */
      struct CreateDirectoryResult final
      {
        /**
         * Indicates if the directory was successfully created by this operation.
         */
        bool Created = true;
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the directory, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
        /**
         * NFS only. Type of the file or directory.
         */
        Nullable<Models::NfsFileType> NfsFileType;
      };
      /**
       * @brief Response type for
       * #Azure::Storage::Files::Shares::ShareDirectoryClient::GetProperties.
       */
      struct DirectoryProperties final
      {
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * A set of name-value pairs that contain metadata for the directory.
         */
        Core::CaseInsensitiveMap Metadata;
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the Directory was last modified. Operations on files within the
         * directory do not affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the directory metadata is completely encrypted
         * using the specified algorithm. Otherwise, the value is set to false.
         */
        bool IsServerEncrypted = bool();
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
        /**
         * NFS only. Type of the file or directory.
         */
        Nullable<Models::NfsFileType> NfsFileType;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareDirectoryClient::Delete.
     */
    struct DeleteDirectoryResult final
    {
      /**
       * Indicates if the directory was successfully deleted by this operation.
       */
      bool Deleted = true;
    };
    namespace _detail {
      /**
       * @brief Response type for
       * #Azure::Storage::Files::Shares::ShareDirectoryClient::SetProperties.
       */
      struct SetDirectoryPropertiesResult final
      {
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the directory was last modified. Any operation that modifies
         * the directory or its properties updates the last modified time. Operations on files do
         * not affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareDirectoryClient::SetMetadata.
     */
    struct SetDirectoryMetadataResult final
    {
      /**
       * The ETag contains a value which represents the version of the directory, in quotes.
       */
      Azure::ETag ETag;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
    };
    namespace _detail {
      struct StringEncoded final
      {
        bool Encoded = bool();
        std::string Content;
      };
    } // namespace _detail
    /**
     * @brief File properties.
     */
    struct DirectoryItemDetails final
    {
      /**
       * The time the directory was last accessed.
       */
      Nullable<DateTime> LastAccessedOn;
      /**
       * The date and time the directory was last modified.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value which represents the version of the directory, in quotes.
       */
      ETag Etag;
      /**
       * The SMB related properties for the file.
       */
      FileSmbProperties SmbProperties;
    };
    namespace _detail {
      /**
       * @brief A listed directory item.
       */
      struct DirectoryItem final
      {
        StringEncoded Name;
        /**
         * File properties.
         */
        DirectoryItemDetails Details;
      };
    } // namespace _detail
    /**
     * @brief File properties.
     */
    struct FileItemDetails final
    {
      /**
       * Content length of the file. This value may not be up-to-date since an SMB client may have
       * modified the file locally. The value of Content-Length may not reflect that fact until the
       * handle is closed or the op-lock is broken. To retrieve current property values, call Get
       * File Properties.
       */
      std::int64_t FileSize = std::int64_t();
      /**
       * The time the file was last accessed.
       */
      Nullable<DateTime> LastAccessedOn;
      /**
       * The date and time the file was last modified.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value which represents the version of the file, in quotes.
       */
      ETag Etag;
      /**
       * The SMB related properties for the file.
       */
      FileSmbProperties SmbProperties;
    };
    namespace _detail {
      /**
       * @brief A listed file item.
       */
      struct FileItem final
      {
        StringEncoded Name;
        /**
         * File properties.
         */
        FileItemDetails Details;
      };
      /**
       * @brief Abstract for entries that can be listed from Directory.
       */
      struct FilesAndDirectoriesListSegment final
      {
        /**
         * Array of DirectoryItem.
         */
        std::vector<DirectoryItem> DirectoryItems;
        /**
         * Array of FileItem.
         */
        std::vector<FileItem> FileItems;
      };
    } // namespace _detail
    /**
     * @brief Include this parameter to specify one or more datasets to include in the response.
     */
    enum class ListFilesIncludeFlags
    {
      None = 0,
      Timestamps = 1,
      ETag = 2,
      Attributes = 4,
      PermissionKey = 8,
    };
    inline ListFilesIncludeFlags operator|(ListFilesIncludeFlags lhs, ListFilesIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListFilesIncludeFlags>;
      return static_cast<ListFilesIncludeFlags>(static_cast<type>(lhs) | static_cast<type>(rhs));
    }
    inline ListFilesIncludeFlags& operator|=(ListFilesIncludeFlags& lhs, ListFilesIncludeFlags rhs)
    {
      lhs = lhs | rhs;
      return lhs;
    }
    inline ListFilesIncludeFlags operator&(ListFilesIncludeFlags lhs, ListFilesIncludeFlags rhs)
    {
      using type = std::underlying_type_t<ListFilesIncludeFlags>;
      return static_cast<ListFilesIncludeFlags>(static_cast<type>(lhs) & static_cast<type>(rhs));
    }
    inline ListFilesIncludeFlags& operator&=(ListFilesIncludeFlags& lhs, ListFilesIncludeFlags rhs)
    {
      lhs = lhs & rhs;
      return lhs;
    }
    namespace _detail {
      /**
       * @brief An enumeration of directories and files.
       */
      struct ListFilesAndDirectoriesSegmentResponse final
      {
        std::string ServiceEndpoint;
        std::string ShareName;
        Nullable<std::string> ShareSnapshot;
        Nullable<bool> Encoded;
        std::string DirectoryPath;
        StringEncoded Prefix;
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        /**
         * Abstract for entries that can be listed from Directory.
         */
        FilesAndDirectoriesListSegment Segment;
        std::string NextMarker;
        Nullable<std::string> DirectoryId;
      };
      /**
       * @brief Access rights of the access policy.
       */
      class AccessRight final : public Core::_internal::ExtendableEnumeration<AccessRight> {
      public:
        /** Constructs a new AccessRight instance */
        AccessRight() = default;
        /** Constructs a new AccessRight from a string. */
        explicit AccessRight(std::string value) : ExtendableEnumeration(std::move(value)) {}

        /** Constant value of type AccessRight: Read */
        AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessRight Read;
        /** Constant value of type AccessRight: Write */
        AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessRight Write;
        /** Constant value of type AccessRight: Delete */
        AZ_STORAGE_FILES_SHARES_DLLEXPORT const static AccessRight Delete;
      };
      /**
       * @brief A listed Azure Storage handle item.
       */
      struct HandleItem final
      {
        /**
         * XSMB service handle ID.
         */
        std::string HandleId;
        /**
         * File or directory name including full path starting from share root.
         */
        StringEncoded Path;
        /**
         * FileId uniquely identifies the file or directory.
         */
        std::string FileId;
        /**
         * ParentId uniquely identifies the parent directory of the object.
         */
        std::string ParentId;
        /**
         * SMB session ID in context of which the file handle was opened.
         */
        std::string SessionId;
        /**
         * Client IP that opened the handle.
         */
        std::string ClientIp;
        /**
         * Name of the client machine where the share is being mounted.
         */
        std::string ClientName;
        /**
         * Time when the session that previously opened the handle has last been reconnected. (UTC).
         */
        DateTime OpenedOn;
        /**
         * Time handle was last connected to (UTC).
         */
        DateTime LastReconnectedOn;
        /**
         * Array of AccessRight.
         */
        std::vector<AccessRight> AccessRightList;
      };
      /**
       * @brief Response type for
       * #Azure::Storage::Files::Shares::DirectoryClient::ForceCloseHandles.
       */
      struct ForceCloseDirectoryHandlesResult final
      {
        /**
         * A string describing next handle to be closed. It is returned when more handles need to be
         * closed to complete the request.
         */
        Nullable<std::string> ContinuationToken;
        /**
         * Contains count of number of handles closed.
         */
        std::int32_t NumberOfHandlesClosed = std::int32_t();
        /**
         * Contains count of number of handles that failed to close.
         */
        std::int32_t NumberOfHandlesFailedToClose = std::int32_t();
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::DirectoryClient::Rename.
       */
      struct RenameDirectoryResult final
      {
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * Key of the permission set for the file.
         */
        std::string FilePermissionKey;
        /**
         * Attributes set for the file.
         */
        std::string FileAttributes;
        /**
         * Creation time for the file.
         */
        DateTime FileCreationTime;
        /**
         * Last write time for the file.
         */
        DateTime FileLastWriteTime;
        /**
         * Change time for the file.
         */
        DateTime FileChangeTime;
        /**
         * The fileId of the file.
         */
        std::string FileId;
        /**
         * The parent fileId of the directory.
         */
        std::string FileParentId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::Create.
       */
      struct CreateFileResult final
      {
        /**
         * Indicates if the file was successfully created by this operation.
         */
        bool Created = true;
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
        /**
         * NFS only. Type of the file or directory.
         */
        Nullable<Models::NfsFileType> NfsFileType;
      };
    } // namespace _detail
    /**
     * @brief Standard HTTP properties supported files.
     */
    struct FileHttpHeaders final
    {
      /**
       * MIME content type of the file.
       */
      std::string ContentType;
      /**
       * Specifies which content encodings have been applied to the file.
       */
      std::string ContentEncoding;
      /**
       * Specifies the natural languages used by this file.
       */
      std::string ContentLanguage;
      /**
       * Hash of the file content.
       */
      Storage::ContentHash ContentHash;
      /**
       * Conveys additional information about how to process the resource payload, and also can be
       * used to attach additional metadata.
       */
      std::string ContentDisposition;
      /**
       * Specifies directives for caching mechanisms.
       */
      std::string CacheControl;
    };
    /**
     * @brief Status of a copy operation.
     */
    class CopyStatus final : public Core::_internal::ExtendableEnumeration<CopyStatus> {
    public:
      /** Constructs a new CopyStatus instance */
      CopyStatus() = default;
      /** Constructs a new CopyStatus from a string. */
      explicit CopyStatus(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type CopyStatus: Pending */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static CopyStatus Pending;
      /** Constant value of type CopyStatus: Success */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static CopyStatus Success;
      /** Constant value of type CopyStatus: Aborted */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static CopyStatus Aborted;
      /** Constant value of type CopyStatus: Failed */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static CopyStatus Failed;
    };
    namespace _detail {
      /**
       * @brief Detailed information of the downloaded file.
       */
      struct DownloadFileDetails final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the file was last modified. Any operation that modifies the
         * file, including an update of the file's metadata or properties, changes the last-modified
         * time of the file.
         */
        DateTime LastModified;
        /**
         * A set of name-value pairs associated with the share or file.
         */
        Core::CaseInsensitiveMap Metadata;
        /**
         * String identifier for this copy operation. Use with Get File Properties to check the
         * status of this copy operation, or pass to Abort Copy File to abort a pending copy.
         */
        Nullable<std::string> CopyId;
        /**
         * URL up to 2 KB in length that specifies the source file or file used in the last
         * attempted Copy File operation where this file was the destination file. This header does
         * not appear if this file has never been the destination in a Copy File operation, or if
         * this file has been modified after a concluded Copy File operation using Set File
         * Properties, Put File, or Put Block List.
         */
        Nullable<std::string> CopySource;
        /**
         * Status of a copy operation.
         */
        Nullable<Models::CopyStatus> CopyStatus;
        /**
         * Only appears when x-ms-copy-status is failed or pending. Describes the cause of the last
         * fatal or non-fatal copy operation failure. This header does not appear if this file has
         * never been the destination in a Copy File operation, or if this file has been modified
         * after a concluded Copy File operation using Set File Properties, Put File, or Put Block
         * List.
         */
        Nullable<std::string> CopyStatusDescription;
        /**
         * Contains the number of bytes copied and the total bytes in the source in the last
         * attempted Copy File operation where this file was the destination file. Can show between
         * 0 and Content-Length bytes copied. This header does not appear if this file has never
         * been the destination in a Copy File operation, or if this file has been modified after a
         * concluded Copy File operation using Set File Properties, Put File, or Put Block List.
         */
        Nullable<std::string> CopyProgress;
        /**
         * Conclusion time of the last attempted Copy File operation where this file was the
         * destination file. This value can specify the time of a completed, aborted, or failed copy
         * attempt. This header does not appear if a copy is pending, if this file has never been
         * the destination in a Copy File operation, or if this file has been modified after a
         * concluded Copy File operation using Set File Properties, Put File, or Put Block List.
         */
        Nullable<DateTime> CopyCompletedOn;
        /**
         * True if the file data and metadata are completely encrypted using the specified
         * algorithm. Otherwise, the value is set to false (when the file is unencrypted, or if only
         * parts of the file/application metadata are encrypted).
         */
        bool IsServerEncrypted = bool();
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * When a share is leased, specifies whether the lease is of infinite or fixed duration.
         */
        Nullable<LeaseDurationType> LeaseDuration;
        /**
         * Lease state of the share.
         */
        Nullable<Models::LeaseState> LeaseState;
        /**
         * The current lease status of the share.
         */
        Nullable<Models::LeaseStatus> LeaseStatus;
        Nullable<std::string> FileMode;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::int64_t> LinkCount;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::Download.
       */
      struct DownloadFileResult final
      {
        /**
         * Content of the file or file range.
         */
        std::unique_ptr<Core::IO::BodyStream> BodyStream;
        /**
         * Indicates the range of bytes returned.
         */
        Core::Http::HttpRange ContentRange;
        /**
         * Size of the file in bytes.
         */
        std::int64_t FileSize = std::int64_t();
        /**
         * MD5 hash for the downloaded range of data.
         */
        Nullable<ContentHash> TransactionalContentHash;
        /**
         * Standard HTTP properties supported files.
         */
        FileHttpHeaders HttpHeaders;
        /**
         * Detailed information of the downloaded file.
         */
        DownloadFileDetails Details;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::GetProperties.
       */
      struct FileProperties final
      {
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * Standard HTTP properties supported files.
         */
        FileHttpHeaders HttpHeaders;
        /**
         * Returns the date and time the file was last modified. The date format follows RFC 1123.
         * Any operation that modifies the file or its properties updates the last modified time.
         */
        DateTime LastModified;
        /**
         * A set of name-value pairs associated with this file as user-defined metadata.
         */
        Core::CaseInsensitiveMap Metadata;
        /**
         * The size of the file in bytes. This header returns the value of the 'x-ms-content-length'
         * header that is stored with the file.
         */
        std::int64_t FileSize = std::int64_t();
        /**
         * The ETag contains a value that you can use to perform operations conditionally, in
         * quotes.
         */
        Azure::ETag ETag;
        /**
         * Conclusion time of the last attempted Copy File operation where this file was the
         * destination file. This value can specify the time of a completed, aborted, or failed copy
         * attempt.
         */
        Nullable<DateTime> CopyCompletedOn;
        /**
         * Only appears when x-ms-copy-status is failed or pending. Describes cause of fatal or
         * non-fatal copy operation failure.
         */
        Nullable<std::string> CopyStatusDescription;
        /**
         * String identifier for the last attempted Copy File operation where this file was the
         * destination file.
         */
        Nullable<std::string> CopyId;
        /**
         * Contains the number of bytes copied and the total bytes in the source in the last
         * attempted Copy File operation where this file was the destination file. Can show between
         * 0 and Content-Length bytes copied.
         */
        Nullable<std::string> CopyProgress;
        /**
         * URL up to 2KB in length that specifies the source file used in the last attempted Copy
         * File operation where this file was the destination file.
         */
        Nullable<std::string> CopySource;
        /**
         * State of the copy operation identified by 'x-ms-copy-id'.
         */
        Nullable<Models::CopyStatus> CopyStatus;
        /**
         * The value of this header is set to true if the file data and application metadata are
         * completely encrypted using the specified algorithm. Otherwise, the value is set to false
         * (when the file is unencrypted, or if only parts of the file/application metadata are
         * encrypted).
         */
        bool IsServerEncrypted = bool();
        /**
         * When a file is leased, specifies whether the lease is of infinite or fixed duration.
         */
        Nullable<LeaseDurationType> LeaseDuration;
        /**
         * Lease state of the file.
         */
        Nullable<Models::LeaseState> LeaseState;
        /**
         * The current lease status of the file.
         */
        Nullable<Models::LeaseStatus> LeaseStatus;
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
        /**
         * NFS only. The link count of the file or directory.
         */
        Nullable<std::int64_t> LinkCount;
        /**
         * NFS only. Type of the file or directory.
         */
        Nullable<Models::NfsFileType> NfsFileType;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::Delete.
     */
    struct DeleteFileResult final
    {
      /**
       * Indicates if the file was successfully deleted by this operation.
       */
      bool Deleted = true;
      /**
       * NFS only. The link count of the file or directory.
       */
      Nullable<std::int64_t> LinkCount;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::SetProperties.
       */
      struct SetFilePropertiesResult final
      {
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the directory was last modified. Any operation that modifies
         * the directory or its properties updates the last modified time. Operations on files do
         * not affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * NFS only. The mode of the file or directory.
         */
        Nullable<std::string> FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        Nullable<std::string> Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        Nullable<std::string> Group;
        /**
         * NFS only. The link count of the file or directory.
         */
        Nullable<std::int64_t> LinkCount;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::SetMetadata.
     */
    struct SetFileMetadataResult final
    {
      /**
       * The ETag contains a value which represents the version of the file, in quotes.
       */
      Azure::ETag ETag;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = bool();
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::AcquireLease.
       */
      struct AcquireFileLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the file was last modified. Any operation that modifies the
         * file, including an update of the file's metadata or properties, changes the last-modified
         * time of the file.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a file's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::ReleaseLease.
       */
      struct ReleaseFileLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the file was last modified. Any operation that modifies the
         * file, including an update of the file's metadata or properties, changes the last-modified
         * time of the file.
         */
        DateTime LastModified;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::ChangeLease.
       */
      struct ChangeFileLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the file was last modified. Any operation that modifies the
         * file, including an update of the file's metadata or properties, changes the last-modified
         * time of the file.
         */
        DateTime LastModified;
        /**
         * Uniquely identifies a file's lease.
         */
        std::string LeaseId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::BreakLease.
       */
      struct BreakFileLeaseResult final
      {
        /**
         * The ETag contains a value that you can use to perform operations conditionally. If the
         * request version is 2011-08-18 or newer, the ETag value will be in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the file was last modified. Any operation that modifies the
         * file, including an update of the file's metadata or properties, changes the last-modified
         * time of the file.
         */
        DateTime LastModified;
      };
    } // namespace _detail
    /**
     * @brief If the file last write time should be preserved or overwritten.
     */
    class FileLastWrittenMode final
        : public Core::_internal::ExtendableEnumeration<FileLastWrittenMode> {
    public:
      /** Constructs a new FileLastWrittenMode instance */
      FileLastWrittenMode() = default;
      /** Constructs a new FileLastWrittenMode from a string. */
      explicit FileLastWrittenMode(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type FileLastWrittenMode: Now */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileLastWrittenMode Now;
      /** Constant value of type FileLastWrittenMode: Preserve */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static FileLastWrittenMode Preserve;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::UploadRange.
     */
    struct UploadFileRangeResult final
    {
      /**
       * The ETag contains a value which represents the version of the file, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the directory was last modified. Any operation that modifies the
       * share or its properties or metadata updates the last modified time. Operations on files do
       * not affect the last modified time of the share.
       */
      DateTime LastModified;
      /**
       * This header is returned so that the client can check for message content integrity. The
       * value of this header is computed by the File service; it is not necessarily the same value
       * as may have been specified in the request headers.
       */
      ContentHash TransactionalContentHash;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = false;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::UploadRangeFromUri.
     */
    struct UploadFileRangeFromUriResult final
    {
      /**
       * The ETag contains a value which represents the version of the file, in quotes.
       */
      Azure::ETag ETag;
      /**
       * Returns the date and time the directory was last modified. Any operation that modifies the
       * share or its properties or metadata updates the last modified time. Operations on files do
       * not affect the last modified time of the share.
       */
      DateTime LastModified;
      /**
       * This header is returned so that the client can check for message content integrity. The
       * value of this header is computed by the File service; it is not necessarily the same value
       * as may have been specified in the request headers.
       */
      ContentHash TransactionalContentHash;
      /**
       * The value of this header is set to true if the contents of the request are successfully
       * encrypted using the specified algorithm, and false otherwise.
       */
      bool IsServerEncrypted = false;
    };
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::GetRangeList.
     */
    struct GetFileRangeListResult final
    {
      /**
       * Array of Range.
       */
      std::vector<Core::Http::HttpRange> Ranges;
      /**
       * Array of ClearRange.
       */
      std::vector<Core::Http::HttpRange> ClearRanges;
      /**
       * The date/time that the file was last modified. Any operation that modifies the file,
       * including an update of the file's metadata or properties, changes the file's last modified
       * time.
       */
      DateTime LastModified;
      /**
       * The ETag contains a value which represents the version of the file, in quotes.
       */
      Azure::ETag ETag;
      /**
       * The size of the file in bytes.
       */
      std::int64_t FileSize = std::int64_t();
    };
    /**
     * @brief Specifies the option to copy file security descriptor from source file or to set it
     * using the value which is defined by the header value of x-ms-file-permission or
     * x-ms-file-permission-key.
     */
    class PermissionCopyMode final
        : public Core::_internal::ExtendableEnumeration<PermissionCopyMode> {
    public:
      /** Constructs a new PermissionCopyMode instance */
      PermissionCopyMode() = default;
      /** Constructs a new PermissionCopyMode from a string. */
      explicit PermissionCopyMode(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type PermissionCopyMode: Source */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static PermissionCopyMode Source;
      /** Constant value of type PermissionCopyMode: Override */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static PermissionCopyMode Override;
    };
    /**
     * @brief NFS only. Applicable only when the copy source is a File. Determines the copy behavior
     * of the mode bits of the file. source: The mode on the destination file is copied from the
     * source file. override: The mode on the destination file is determined via the x-ms-mode
     * header.
     */
    class ModeCopyMode final : public Core::_internal::ExtendableEnumeration<ModeCopyMode> {
    public:
      /** Constructs a new ModeCopyMode instance */
      ModeCopyMode() = default;
      /** Constructs a new ModeCopyMode from a string. */
      explicit ModeCopyMode(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type ModeCopyMode: Source */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ModeCopyMode Source;
      /** Constant value of type ModeCopyMode: Override */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static ModeCopyMode Override;
    };
    /**
     * @brief NFS only. Determines the copy behavior of the owner user identifier (UID) and group
     * identifier (GID) of the file. source: The owner user identifier (UID) and group identifier
     * (GID) on the destination file is copied from the source file. override: The owner user
     * identifier (UID) and group identifier (GID) on the destination file is determined via the
     * x-ms-owner and x-ms-group  headers.
     */
    class OwnerCopyMode final : public Core::_internal::ExtendableEnumeration<OwnerCopyMode> {
    public:
      /** Constructs a new OwnerCopyMode instance */
      OwnerCopyMode() = default;
      /** Constructs a new OwnerCopyMode from a string. */
      explicit OwnerCopyMode(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /** Constant value of type OwnerCopyMode: Source */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static OwnerCopyMode Source;
      /** Constant value of type OwnerCopyMode: Override */
      AZ_STORAGE_FILES_SHARES_DLLEXPORT const static OwnerCopyMode Override;
    };
    namespace _detail {
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::StartCopy.
       */
      struct StartFileCopyResult final
      {
        /**
         * If the copy is completed, contains the ETag of the destination file. If the copy is not
         * complete, contains the ETag of the empty file created at the start of the copy.
         */
        Azure::ETag ETag;
        /**
         * Returns the date/time that the copy operation to the destination file completed.
         */
        DateTime LastModified;
        /**
         * String identifier for this copy operation. Use with Get File or Get File Properties to
         * check the status of this copy operation, or pass to Abort Copy File to abort a pending
         * copy.
         */
        std::string CopyId;
        /**
         * State of the copy operation identified by x-ms-copy-id.
         */
        Models::CopyStatus CopyStatus;
      };
    } // namespace _detail
    /**
     * @brief Response type for #Azure::Storage::Files::Shares::ShareFileClient::AbortCopy.
     */
    struct AbortFileCopyResult final
    {
    };
    namespace _detail {
      /**
       * @brief An enumeration of handles.
       */
      struct ListHandlesResponse final
      {
        /**
         * Array of HandleItem.
         */
        std::vector<HandleItem> HandleList;
        std::string NextMarker;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::ForceCloseHandles.
       */
      struct ForceFileCloseHandlesResult final
      {
        /**
         * A string describing next handle to be closed. It is returned when more handles need to be
         * closed to complete the request.
         */
        Nullable<std::string> ContinuationToken;
        /**
         * Contains count of number of handles closed.
         */
        std::int32_t NumberOfHandlesClosed = std::int32_t();
        /**
         * Contains count of number of handles that failed to close.
         */
        std::int32_t NumberOfHandlesFailedToClose = std::int32_t();
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::Rename.
       */
      struct RenameFileResult final
      {
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The value of this header is set to true if the contents of the request are successfully
         * encrypted using the specified algorithm, and false otherwise.
         */
        bool IsServerEncrypted = bool();
        /**
         * Key of the permission set for the file.
         */
        std::string FilePermissionKey;
        /**
         * Attributes set for the file.
         */
        std::string FileAttributes;
        /**
         * Creation time for the file.
         */
        DateTime FileCreationTime;
        /**
         * Last write time for the file.
         */
        DateTime FileLastWriteTime;
        /**
         * Change time for the file.
         */
        DateTime FileChangeTime;
        /**
         * The fileId of the file.
         */
        std::string FileId;
        /**
         * The parent fileId of the directory.
         */
        std::string FileParentId;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::CreateSymbolicLink.
       */
      struct CreateFileSymbolicLinkResult final
      {
        bool Created = true;
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * NFS only. The mode of the file or directory.
         */
        std::string FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        std::string Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        std::string Group;
        /**
         * NFS only. Type of the file or directory.
         */
        Models::NfsFileType NfsFileType;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::GetSymbolicLink.
       */
      struct GetFileSymbolicLinkResult final
      {
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * The path to the original file, the symbolic link is pointing to. The path is of type
         * string which is not resolved and is stored as is. The path can be absolute path or the
         * relative path depending on the content stored in the symbolic link file.
         */
        std::string LinkText;
      };
      /**
       * @brief Response type for #Azure::Storage::Files::Shares::FileClient::CreateHardLink.
       */
      struct CreateFileHardLinkResult final
      {
        bool Created = true;
        /**
         * The SMB related properties for the file.
         */
        FileSmbProperties SmbProperties;
        /**
         * The ETag contains a value which represents the version of the file, in quotes.
         */
        Azure::ETag ETag;
        /**
         * Returns the date and time the share was last modified. Any operation that modifies the
         * directory or its properties updates the last modified time. Operations on files do not
         * affect the last modified time of the directory.
         */
        DateTime LastModified;
        /**
         * NFS only. The link count of the file or directory.
         */
        std::int64_t LinkCount = std::int64_t();
        /**
         * NFS only. The mode of the file or directory.
         */
        std::string FileMode;
        /**
         * NFS only. The owner of the file or directory.
         */
        std::string Owner;
        /**
         * NFS only. The owning group of the file or directory.
         */
        std::string Group;
        /**
         * NFS only. Type of the file or directory.
         */
        Models::NfsFileType NfsFileType;
      };
    } // namespace _detail
  } // namespace Models
  namespace _detail {
    class ServiceClient final {
    public:
      struct SetServicePropertiesOptions final
      {
        Models::ShareServiceProperties ShareServiceProperties;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::SetServicePropertiesResult> SetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetServicePropertiesOptions& options,
          const Core::Context& context);
      struct GetServicePropertiesOptions final
      {
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::ShareServiceProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServicePropertiesOptions& options,
          const Core::Context& context);
      struct ListServiceSharesSegmentOptions final
      {
        Nullable<std::string> Prefix;
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        Nullable<Models::ListSharesIncludeFlags> Include;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ListSharesResponse> ListSharesSegment(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListServiceSharesSegmentOptions& options,
          const Core::Context& context);
      struct GetServiceUserDelegationKeyOptions final
      {
        Models::_detail::KeyInfo KeyInfo;
      };
      static Response<Models::UserDelegationKey> GetUserDelegationKey(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetServiceUserDelegationKeyOptions& options,
          const Core::Context& context);
    };
    class ShareClient final {
    public:
      struct CreateShareOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::int64_t> Quota;
        Nullable<Models::AccessTier> AccessTier;
        Nullable<Models::ShareProtocols> EnabledProtocols;
        Nullable<Models::ShareRootSquash> RootSquash;
        Nullable<bool> EnableSnapshotVirtualDirectoryAccess;
        Nullable<bool> PaidBurstingEnabled;
        Nullable<std::int64_t> PaidBurstingMaxBandwidthMibps;
        Nullable<std::int64_t> PaidBurstingMaxIops;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::int64_t> ShareProvisionedIops;
        Nullable<std::int64_t> ShareProvisionedBandwidthMibps;
      };
      static Response<Models::CreateShareResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateShareOptions& options,
          const Core::Context& context);
      struct GetSharePropertiesOptions final
      {
        Nullable<std::string> Sharesnapshot;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::ShareProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetSharePropertiesOptions& options,
          const Core::Context& context);
      struct DeleteShareOptions final
      {
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::DeleteSnapshotsOption> DeleteSnapshots;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::DeleteShareResult> Delete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteShareOptions& options,
          const Core::Context& context);
      struct AcquireShareLeaseOptions final
      {
        Nullable<std::int32_t> Duration;
        Nullable<std::string> ProposedLeaseId;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::AcquireShareLeaseResult> AcquireLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AcquireShareLeaseOptions& options,
          const Core::Context& context);
      struct ReleaseShareLeaseOptions final
      {
        std::string LeaseId;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ReleaseShareLeaseResult> ReleaseLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ReleaseShareLeaseOptions& options,
          const Core::Context& context);
      struct ChangeShareLeaseOptions final
      {
        std::string LeaseId;
        Nullable<std::string> ProposedLeaseId;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ChangeShareLeaseResult> ChangeLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ChangeShareLeaseOptions& options,
          const Core::Context& context);
      struct RenewShareLeaseOptions final
      {
        std::string LeaseId;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::RenewShareLeaseResult> RenewLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenewShareLeaseOptions& options,
          const Core::Context& context);
      struct BreakShareLeaseOptions final
      {
        Nullable<std::int32_t> BreakPeriod;
        Nullable<std::string> LeaseId;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::BreakShareLeaseResult> BreakLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const BreakShareLeaseOptions& options,
          const Core::Context& context);
      struct CreateShareSnapshotOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::CreateShareSnapshotResult> CreateSnapshot(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateShareSnapshotOptions& options,
          const Core::Context& context);
      struct CreateSharePermissionOptions final
      {
        Models::_detail::SharePermission SharePermission;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::CreateSharePermissionResult> CreatePermission(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateSharePermissionOptions& options,
          const Core::Context& context);
      struct GetSharePermissionOptions final
      {
        std::string FilePermissionKey;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::SharePermission> GetPermission(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetSharePermissionOptions& options,
          const Core::Context& context);
      struct SetSharePropertiesOptions final
      {
        Nullable<std::int64_t> Quota;
        Nullable<Models::AccessTier> AccessTier;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareRootSquash> RootSquash;
        Nullable<bool> EnableSnapshotVirtualDirectoryAccess;
        Nullable<bool> PaidBurstingEnabled;
        Nullable<std::int64_t> PaidBurstingMaxBandwidthMibps;
        Nullable<std::int64_t> PaidBurstingMaxIops;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::int64_t> ShareProvisionedIops;
        Nullable<std::int64_t> ShareProvisionedBandwidthMibps;
      };
      static Response<Models::SetSharePropertiesResult> SetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetSharePropertiesOptions& options,
          const Core::Context& context);
      struct SetShareMetadataOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::SetShareMetadataResult> SetMetadata(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetShareMetadataOptions& options,
          const Core::Context& context);
      struct GetShareAccessPolicyOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::ShareAccessPolicy> GetAccessPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetShareAccessPolicyOptions& options,
          const Core::Context& context);
      struct SetShareAccessPolicyOptions final
      {
        std::vector<Models::SignedIdentifier> ShareAcl;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::SetShareAccessPolicyResult> SetAccessPolicy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetShareAccessPolicyOptions& options,
          const Core::Context& context);
      struct GetShareStatisticsOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::ShareStatistics> GetStatistics(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetShareStatisticsOptions& options,
          const Core::Context& context);
    };
    class DirectoryClient final {
    public:
      struct CreateDirectoryOptions final
      {
        Nullable<bool> AllowTrailingDot;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::string FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::string> FileMode;
      };
      static Response<Models::_detail::CreateDirectoryResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateDirectoryOptions& options,
          const Core::Context& context);
      struct GetDirectoryPropertiesOptions final
      {
        Nullable<bool> AllowTrailingDot;
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::DirectoryProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetDirectoryPropertiesOptions& options,
          const Core::Context& context);
      struct DeleteDirectoryOptions final
      {
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::DeleteDirectoryResult> Delete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteDirectoryOptions& options,
          const Core::Context& context);
      struct SetDirectoryPropertiesOptions final
      {
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::string FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::string> FileMode;
      };
      static Response<Models::_detail::SetDirectoryPropertiesResult> SetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetDirectoryPropertiesOptions& options,
          const Core::Context& context);
      struct SetDirectoryMetadataOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::SetDirectoryMetadataResult> SetMetadata(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetDirectoryMetadataOptions& options,
          const Core::Context& context);
      struct ListDirectoryFilesAndDirectoriesSegmentOptions final
      {
        Nullable<std::string> Prefix;
        Nullable<std::string> Sharesnapshot;
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        Nullable<Models::ListFilesIncludeFlags> Include;
        Nullable<bool> IncludeExtendedInfo;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ListFilesAndDirectoriesSegmentResponse>
      ListFilesAndDirectoriesSegment(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListDirectoryFilesAndDirectoriesSegmentOptions& options,
          const Core::Context& context);
      struct ListDirectoryHandlesOptions final
      {
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        Nullable<std::string> Sharesnapshot;
        Nullable<bool> Recursive;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ListHandlesResponse> ListHandles(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListDirectoryHandlesOptions& options,
          const Core::Context& context);
      struct ForceDirectoryCloseHandlesOptions final
      {
        Nullable<std::string> Marker;
        Nullable<std::string> Sharesnapshot;
        std::string HandleId;
        Nullable<bool> Recursive;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ForceCloseDirectoryHandlesResult> ForceCloseHandles(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ForceDirectoryCloseHandlesOptions& options,
          const Core::Context& context);
      struct RenameDirectoryOptions final
      {
        std::string RenameSource;
        Nullable<bool> ReplaceIfExists;
        Nullable<bool> IgnoreReadOnly;
        Nullable<std::string> SourceLeaseId;
        Nullable<std::string> DestinationLeaseId;
        Nullable<std::string> FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::map<std::string, std::string> Metadata;
        Nullable<bool> AllowTrailingDot;
        Nullable<bool> AllowSourceTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::RenameDirectoryResult> Rename(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenameDirectoryOptions& options,
          const Core::Context& context);
    };
    class FileClient final {
    public:
      struct CreateFileOptions final
      {
        Nullable<bool> AllowTrailingDot;
        std::int64_t FileContentLength = std::int64_t();
        Nullable<std::string> FileContentType;
        Nullable<std::string> FileContentEncoding;
        Nullable<std::string> FileContentLanguage;
        Nullable<std::string> FileCacheControl;
        Nullable<std::vector<std::uint8_t>> FileContentMD5;
        Nullable<std::string> FileContentDisposition;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::string FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::string> FileMode;
        Nullable<Models::NfsFileType> NfsFileType;
      };
      static Response<Models::_detail::CreateFileResult> Create(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateFileOptions& options,
          const Core::Context& context);
      struct DownloadFileOptions final
      {
        Nullable<bool> AllowTrailingDot;
        Nullable<std::string> Range;
        Nullable<bool> RangeGetContentMD5;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::DownloadFileResult> Download(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DownloadFileOptions& options,
          const Core::Context& context);
      struct GetFilePropertiesOptions final
      {
        Nullable<bool> AllowTrailingDot;
        Nullable<std::string> Sharesnapshot;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::FileProperties> GetProperties(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetFilePropertiesOptions& options,
          const Core::Context& context);
      struct DeleteFileOptions final
      {
        Nullable<bool> AllowTrailingDot;
        Nullable<std::string> LeaseId;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::DeleteFileResult> Delete(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const DeleteFileOptions& options,
          const Core::Context& context);
      struct SetFileHttpHeadersOptions final
      {
        Nullable<std::int64_t> FileContentLength;
        Nullable<std::string> FileContentType;
        Nullable<std::string> FileContentEncoding;
        Nullable<std::string> FileContentLanguage;
        Nullable<std::string> FileCacheControl;
        Nullable<std::vector<std::uint8_t>> FileContentMD5;
        Nullable<std::string> FileContentDisposition;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::string FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::string> FileMode;
      };
      static Response<Models::_detail::SetFilePropertiesResult> SetHttpHeaders(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetFileHttpHeadersOptions& options,
          const Core::Context& context);
      struct SetFileMetadataOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::SetFileMetadataResult> SetMetadata(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const SetFileMetadataOptions& options,
          const Core::Context& context);
      struct AcquireFileLeaseOptions final
      {
        Nullable<std::int32_t> Duration;
        Nullable<std::string> ProposedLeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::AcquireFileLeaseResult> AcquireLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AcquireFileLeaseOptions& options,
          const Core::Context& context);
      struct ReleaseFileLeaseOptions final
      {
        std::string LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ReleaseFileLeaseResult> ReleaseLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ReleaseFileLeaseOptions& options,
          const Core::Context& context);
      struct ChangeFileLeaseOptions final
      {
        std::string LeaseId;
        Nullable<std::string> ProposedLeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ChangeFileLeaseResult> ChangeLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ChangeFileLeaseOptions& options,
          const Core::Context& context);
      struct BreakFileLeaseOptions final
      {
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::BreakFileLeaseResult> BreakLease(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const BreakFileLeaseOptions& options,
          const Core::Context& context);
      struct UploadFileRangeOptions final
      {
        std::string Range;
        std::string FileRangeWrite;
        Nullable<std::vector<std::uint8_t>> ContentMD5;
        Nullable<std::string> LeaseId;
        Nullable<Models::FileLastWrittenMode> FileLastWrittenMode;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::UploadFileRangeResult> UploadRange(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          Core::IO::BodyStream& requestBody,
          const UploadFileRangeOptions& options,
          const Core::Context& context);
      struct UploadFileRangeFromUriOptions final
      {
        std::string Range;
        std::string CopySource;
        Nullable<std::string> SourceRange;
        Nullable<std::vector<std::uint8_t>> SourceContentCrc64;
        Nullable<std::vector<std::uint8_t>> SourceIfMatchCrc64;
        Nullable<std::vector<std::uint8_t>> SourceIfNoneMatchCrc64;
        Nullable<std::string> LeaseId;
        Nullable<std::string> CopySourceAuthorization;
        Nullable<Models::FileLastWrittenMode> FileLastWrittenMode;
        Nullable<bool> AllowTrailingDot;
        Nullable<bool> AllowSourceTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::UploadFileRangeFromUriResult> UploadRangeFromUri(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const UploadFileRangeFromUriOptions& options,
          const Core::Context& context);
      struct GetFileRangeListOptions final
      {
        Nullable<std::string> Sharesnapshot;
        Nullable<std::string> Prevsharesnapshot;
        Nullable<std::string> Range;
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<bool> SupportRename;
      };
      static Response<Models::GetFileRangeListResult> GetRangeList(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetFileRangeListOptions& options,
          const Core::Context& context);
      struct StartFileCopyOptions final
      {
        std::map<std::string, std::string> Metadata;
        std::string CopySource;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        Nullable<Models::PermissionCopyMode> FilePermissionCopyMode;
        Nullable<bool> IgnoreReadOnly;
        Nullable<std::string> FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<bool> SetArchiveAttribute;
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<bool> AllowSourceTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        Nullable<std::string> FileMode;
        Nullable<Models::ModeCopyMode> FileModeCopyMode;
        Nullable<Models::OwnerCopyMode> FileOwnerCopyMode;
      };
      static Response<Models::_detail::StartFileCopyResult> StartCopy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const StartFileCopyOptions& options,
          const Core::Context& context);
      struct AbortFileCopyOptions final
      {
        std::string CopyId;
        Nullable<std::string> LeaseId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::AbortFileCopyResult> AbortCopy(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const AbortFileCopyOptions& options,
          const Core::Context& context);
      struct ListFileHandlesOptions final
      {
        Nullable<std::string> Marker;
        Nullable<std::int32_t> MaxResults;
        Nullable<std::string> Sharesnapshot;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ListHandlesResponse> ListHandles(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ListFileHandlesOptions& options,
          const Core::Context& context);
      struct ForceFileCloseHandlesOptions final
      {
        Nullable<std::string> Marker;
        Nullable<std::string> Sharesnapshot;
        std::string HandleId;
        Nullable<bool> AllowTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::ForceFileCloseHandlesResult> ForceCloseHandles(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const ForceFileCloseHandlesOptions& options,
          const Core::Context& context);
      struct RenameFileOptions final
      {
        std::string RenameSource;
        Nullable<bool> ReplaceIfExists;
        Nullable<bool> IgnoreReadOnly;
        Nullable<std::string> SourceLeaseId;
        Nullable<std::string> DestinationLeaseId;
        Nullable<std::string> FileAttributes;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> FileChangeTime;
        Nullable<std::string> FilePermission;
        Nullable<Models::FilePermissionFormat> FilePermissionFormat;
        Nullable<std::string> FilePermissionKey;
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> FileContentType;
        Nullable<bool> AllowTrailingDot;
        Nullable<bool> AllowSourceTrailingDot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::RenameFileResult> Rename(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const RenameFileOptions& options,
          const Core::Context& context);
      struct CreateFileSymbolicLinkOptions final
      {
        std::map<std::string, std::string> Metadata;
        Nullable<std::string> FileCreationTime;
        Nullable<std::string> FileLastWriteTime;
        Nullable<std::string> LeaseId;
        Nullable<std::string> Owner;
        Nullable<std::string> Group;
        std::string LinkText;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::CreateFileSymbolicLinkResult> CreateSymbolicLink(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateFileSymbolicLinkOptions& options,
          const Core::Context& context);
      struct GetFileSymbolicLinkOptions final
      {
        Nullable<std::string> Sharesnapshot;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::GetFileSymbolicLinkResult> GetSymbolicLink(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const GetFileSymbolicLinkOptions& options,
          const Core::Context& context);
      struct CreateFileHardLinkOptions final
      {
        Nullable<std::string> LeaseId;
        std::string TargetFile;
        Nullable<Models::ShareTokenIntent> FileRequestIntent;
      };
      static Response<Models::_detail::CreateFileHardLinkResult> CreateHardLink(
          Core::Http::_internal::HttpPipeline& pipeline,
          const Core::Url& url,
          const CreateFileHardLinkOptions& options,
          const Core::Context& context);
    };
  } // namespace _detail
}}}} // namespace Azure::Storage::Files::Shares