#!/bin/sh
#
# Run svg2png on a few carefully chosen cases to ensure that it
# doesn't segfault. The $test_cases variable is set by automake.  We
# have to override some bits of gdk-pixbuf to ensure that the
# newly-build libsvgtiny-pixbuf is used, and not the installed copy --
# or worse, an installed copy of librsvg.
set -e

LOADERS_CACHE=$(pwd)/loaders.cache

# I'm not real happy about hard-coding the name ".libs", but it works
# for now (we need the directory where the just-built *.so file
# lives).
GDK_PIXBUF_MODULEDIR=.libs gdk-pixbuf-query-loaders > "${LOADERS_CACHE}"
export GDK_PIXBUF_MODULE_FILE="${LOADERS_CACHE}"

# Support running the test suite outside of automake
test -z "${test_cases}" && test_cases=test-cases

TEST_CASES=$(find ${test_cases} -type f -name '*.svg')
for f in $TEST_CASES; do
    g="$(basename "${f}").png"
    echo "Converting ${f} to ${g}..."
    ./svg2png "${f}" "${g}"
    echo "Success."
    rm "${g}"
done

rm "${LOADERS_CACHE}"
