/*  color.c: (c) 2002 sibn

    This file is part of GWiz.

    GWiz is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    GWiz is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with GWiz; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include "gwiz.h"

extern GwizApp gwiz;

Uint32 GwizMixColor (SDL_Color base)
{
    Uint32 color = 0;
    Uint8 *ptr[3];

    ptr[0] = (Uint8 *)&color;
    ptr[1] = ptr[0] + sizeof(Uint8);
    ptr[2] = ptr[1] + sizeof(Uint8);
    ptr[3] = ptr[2] + sizeof(Uint8);

#if SDl_BYTEORDER == SDL_BIGENDIAN
    *(Uint8 *)(ptr[0]) = base.unused;
    *(Uint8 *)(ptr[1]) = base.b;
    *(Uint8 *)(ptr[2]) = base.g;
    *(Uint8 *)(ptr[3]) = base.r;
#else
    *(Uint8 *)(ptr[0]) = base.r;
    *(Uint8 *)(ptr[1]) = base.g;
    *(Uint8 *)(ptr[2]) = base.b;
    *(Uint8 *)(ptr[3]) = base.unused;
#endif

    return (color);
}

void PaintAllPixelsToColor (Uint32 from, Uint32 to)
{
    int i, j;

    if (SDL_MUSTLOCK(gwiz.canvas))
	SDL_LockSurface (gwiz.canvas);
    for (i = 0; i < gwiz.canvas->h + 1; i++)
	for (j = 0; j < gwiz.canvas->w + 1; j++)
	    {
		/* every pixel that has the same color as 'from' should be
		   shifted to use 'to' instead. */
	    }
    if (SDL_MUSTLOCK(gwiz.canvas))
	SDL_UnlockSurface (gwiz.canvas);
    SDL_Flip (gwiz.canvas);
}
