// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutRecord`](crate::operation::put_record::builders::PutRecordFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`stream_name(impl Into<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_stream_name):<br>required: **false**<br><p>The name of the stream to put the data record into.</p><br>
    ///   - [`data(Blob)`](crate::operation::put_record::builders::PutRecordFluentBuilder::data) / [`set_data(Option<Blob>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_data):<br>required: **true**<br><p>The data blob to put into the record, which is base64-encoded when the blob is serialized. When the data blob (the payload before base64-encoding) is added to the partition key size, the total size must not exceed the maximum record size (1 MiB).</p><br>
    ///   - [`partition_key(impl Into<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::partition_key) / [`set_partition_key(Option<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_partition_key):<br>required: **true**<br><p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p><br>
    ///   - [`explicit_hash_key(impl Into<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::explicit_hash_key) / [`set_explicit_hash_key(Option<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_explicit_hash_key):<br>required: **false**<br><p>The hash value used to explicitly determine the shard the data record is assigned to by overriding the partition key hash.</p><br>
    ///   - [`sequence_number_for_ordering(impl Into<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::sequence_number_for_ordering) / [`set_sequence_number_for_ordering(Option<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_sequence_number_for_ordering):<br>required: **false**<br><p>Guarantees strictly increasing sequence numbers, for puts from the same client and to the same partition key. Usage: set the <code>SequenceNumberForOrdering</code> of record <i>n</i> to the sequence number of record <i>n-1</i> (as returned in the result when putting record <i>n-1</i>). If this parameter is not set, records are coarsely ordered based on arrival time.</p><br>
    ///   - [`stream_arn(impl Into<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::stream_arn) / [`set_stream_arn(Option<String>)`](crate::operation::put_record::builders::PutRecordFluentBuilder::set_stream_arn):<br>required: **false**<br><p>The ARN of the stream.</p><br>
    /// - On success, responds with [`PutRecordOutput`](crate::operation::put_record::PutRecordOutput) with field(s):
    ///   - [`shard_id(String)`](crate::operation::put_record::PutRecordOutput::shard_id): <p>The shard ID of the shard where the data record was placed.</p>
    ///   - [`sequence_number(String)`](crate::operation::put_record::PutRecordOutput::sequence_number): <p>The sequence number identifier that was assigned to the put data record. The sequence number for the record is unique across all records in the stream. A sequence number is the identifier associated with every record put into the stream.</p>
    ///   - [`encryption_type(Option<EncryptionType>)`](crate::operation::put_record::PutRecordOutput::encryption_type): <p>The encryption type to use on the record. This parameter can be one of the following values:</p> <ul>  <li>   <p><code>NONE</code>: Do not encrypt the records in the stream.</p></li>  <li>   <p><code>KMS</code>: Use server-side encryption on the records in the stream using a customer-managed Amazon Web Services KMS key.</p></li> </ul>
    /// - On failure, responds with [`SdkError<PutRecordError>`](crate::operation::put_record::PutRecordError)
    pub fn put_record(&self) -> crate::operation::put_record::builders::PutRecordFluentBuilder {
        crate::operation::put_record::builders::PutRecordFluentBuilder::new(self.handle.clone())
    }
}
