from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

ITALIAN_LANG_MODEL = {
    22: {  # 'A'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.POSITIVE,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.POSITIVE,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.POSITIVE,  # 'L'
        29: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.LIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    38: {  # 'B'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    24: {  # 'C'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.POSITIVE,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.LIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    35: {  # 'D'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    30: {  # 'E'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.POSITIVE,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.LIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    39: {  # 'F'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    37: {  # 'G'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.LIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    46: {  # 'H'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    21: {  # 'I'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.POSITIVE,  # 'C'
        35: SequenceLikelihood.POSITIVE,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.POSITIVE,  # 'L'
        29: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.POSITIVE,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    55: {  # 'J'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    54: {  # 'K'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    26: {  # 'L'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.POSITIVE,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    29: {  # 'M'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    34: {  # 'N'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.POSITIVE,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    36: {  # 'O'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.LIKELY,  # 'K'
        26: SequenceLikelihood.POSITIVE,  # 'L'
        29: SequenceLikelihood.POSITIVE,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.LIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    27: {  # 'P'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.LIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    48: {  # 'Q'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    33: {  # 'R'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    23: {  # 'S'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.POSITIVE,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.LIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.LIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.LIKELY,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.LIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    32: {  # 'T'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.LIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.POSITIVE,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.POSITIVE,  # 'T'
        43: SequenceLikelihood.LIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.LIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    43: {  # 'U'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.LIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.POSITIVE,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.POSITIVE,  # 'R'
        23: SequenceLikelihood.POSITIVE,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    41: {  # 'V'
        22: SequenceLikelihood.POSITIVE,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.LIKELY,  # 'D'
        30: SequenceLikelihood.POSITIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    52: {  # 'W'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    57: {  # 'X'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.LIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.LIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.LIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    58: {  # 'Y'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    53: {  # 'Z'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.LIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.POSITIVE,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    3: {  # 'a'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.LIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.POSITIVE,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    20: {  # 'b'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    10: {  # 'c'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    11: {  # 'd'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.LIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.POSITIVE,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    2: {  # 'e'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.LIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.LIKELY,  # 'L'
        29: SequenceLikelihood.LIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.LIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.POSITIVE,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.UNLIKELY,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    18: {  # 'f'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    15: {  # 'g'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    19: {  # 'h'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.POSITIVE,  # 'è'
        50: SequenceLikelihood.POSITIVE,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    1: {  # 'i'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.LIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.LIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.LIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.POSITIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.POSITIVE,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.POSITIVE,  # 'ù'
    },
    56: {  # 'j'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    40: {  # 'k'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    8: {  # 'l'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.LIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.LIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    14: {  # 'm'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    5: {  # 'n'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.LIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.LIKELY,  # 'ù'
    },
    4: {  # 'o'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.LIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.LIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.LIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.POSITIVE,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    13: {  # 'p'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.LIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    25: {  # 'q'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    7: {  # 'r'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.LIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.POSITIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        51: SequenceLikelihood.LIKELY,  # 'ì'
        47: SequenceLikelihood.POSITIVE,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    9: {  # 's'
        22: SequenceLikelihood.LIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.POSITIVE,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.UNLIKELY,  # 'Ù'
        28: SequenceLikelihood.LIKELY,  # 'à'
        31: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        51: SequenceLikelihood.POSITIVE,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.LIKELY,  # 'ù'
    },
    6: {  # 't'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.POSITIVE,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.LIKELY,  # 'v'
        44: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.POSITIVE,  # 'y'
        17: SequenceLikelihood.LIKELY,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.POSITIVE,  # 'à'
        31: SequenceLikelihood.LIKELY,  # 'è'
        50: SequenceLikelihood.LIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.LIKELY,  # 'ù'
    },
    12: {  # 'u'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.LIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.POSITIVE,  # 'b'
        10: SequenceLikelihood.POSITIVE,  # 'c'
        11: SequenceLikelihood.POSITIVE,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        14: SequenceLikelihood.POSITIVE,  # 'm'
        5: SequenceLikelihood.POSITIVE,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.POSITIVE,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.POSITIVE,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.LIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.UNLIKELY,  # 'É'
        64: SequenceLikelihood.UNLIKELY,  # 'Ì'
        65: SequenceLikelihood.UNLIKELY,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.POSITIVE,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    16: {  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.POSITIVE,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.POSITIVE,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.LIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    44: {  # 'w'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.LIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.POSITIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.POSITIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    49: {  # 'x'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.LIKELY,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.LIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    42: {  # 'y'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.LIKELY,  # 'a'
        20: SequenceLikelihood.LIKELY,  # 'b'
        10: SequenceLikelihood.LIKELY,  # 'c'
        11: SequenceLikelihood.LIKELY,  # 'd'
        2: SequenceLikelihood.LIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.LIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        14: SequenceLikelihood.LIKELY,  # 'm'
        5: SequenceLikelihood.LIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.LIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.LIKELY,  # 'r'
        9: SequenceLikelihood.LIKELY,  # 's'
        6: SequenceLikelihood.LIKELY,  # 't'
        12: SequenceLikelihood.LIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.LIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    17: {  # 'z'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.POSITIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.POSITIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.POSITIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.POSITIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.POSITIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.POSITIVE,  # 'z'
        60: SequenceLikelihood.UNLIKELY,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.UNLIKELY,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    60: {  # 'À'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        10: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    59: {  # 'È'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.UNLIKELY,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    62: {  # 'É'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.NEGATIVE,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    64: {  # 'Ì'
        22: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        10: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    65: {  # 'Ò'
        22: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.NEGATIVE,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        10: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    66: {  # 'Ó'
        22: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.NEGATIVE,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    63: {  # 'Ù'
        22: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.NEGATIVE,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.NEGATIVE,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.NEGATIVE,  # 'a'
        20: SequenceLikelihood.NEGATIVE,  # 'b'
        10: SequenceLikelihood.NEGATIVE,  # 'c'
        11: SequenceLikelihood.NEGATIVE,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.NEGATIVE,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.NEGATIVE,  # 'm'
        5: SequenceLikelihood.NEGATIVE,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.NEGATIVE,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.NEGATIVE,  # 'r'
        9: SequenceLikelihood.NEGATIVE,  # 's'
        6: SequenceLikelihood.NEGATIVE,  # 't'
        12: SequenceLikelihood.NEGATIVE,  # 'u'
        16: SequenceLikelihood.NEGATIVE,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.NEGATIVE,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    28: {  # 'à'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.UNLIKELY,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.UNLIKELY,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    31: {  # 'è'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    50: {  # 'é'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.UNLIKELY,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    51: {  # 'ì'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.UNLIKELY,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    47: {  # 'ò'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.UNLIKELY,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.UNLIKELY,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.UNLIKELY,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.NEGATIVE,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.NEGATIVE,  # 'w'
        49: SequenceLikelihood.NEGATIVE,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.UNLIKELY,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
    61: {  # 'ó'
        22: SequenceLikelihood.NEGATIVE,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.NEGATIVE,  # 'C'
        35: SequenceLikelihood.NEGATIVE,  # 'D'
        30: SequenceLikelihood.NEGATIVE,  # 'E'
        39: SequenceLikelihood.NEGATIVE,  # 'F'
        37: SequenceLikelihood.NEGATIVE,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.NEGATIVE,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.NEGATIVE,  # 'K'
        26: SequenceLikelihood.NEGATIVE,  # 'L'
        29: SequenceLikelihood.NEGATIVE,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.NEGATIVE,  # 'O'
        27: SequenceLikelihood.NEGATIVE,  # 'P'
        48: SequenceLikelihood.NEGATIVE,  # 'Q'
        33: SequenceLikelihood.NEGATIVE,  # 'R'
        23: SequenceLikelihood.NEGATIVE,  # 'S'
        32: SequenceLikelihood.NEGATIVE,  # 'T'
        43: SequenceLikelihood.NEGATIVE,  # 'U'
        41: SequenceLikelihood.NEGATIVE,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.NEGATIVE,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.NEGATIVE,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.UNLIKELY,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.NEGATIVE,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.NEGATIVE,  # 'à'
        31: SequenceLikelihood.NEGATIVE,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.NEGATIVE,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.NEGATIVE,  # 'ù'
    },
    45: {  # 'ù'
        22: SequenceLikelihood.UNLIKELY,  # 'A'
        38: SequenceLikelihood.NEGATIVE,  # 'B'
        24: SequenceLikelihood.UNLIKELY,  # 'C'
        35: SequenceLikelihood.UNLIKELY,  # 'D'
        30: SequenceLikelihood.UNLIKELY,  # 'E'
        39: SequenceLikelihood.UNLIKELY,  # 'F'
        37: SequenceLikelihood.UNLIKELY,  # 'G'
        46: SequenceLikelihood.NEGATIVE,  # 'H'
        21: SequenceLikelihood.UNLIKELY,  # 'I'
        55: SequenceLikelihood.NEGATIVE,  # 'J'
        54: SequenceLikelihood.UNLIKELY,  # 'K'
        26: SequenceLikelihood.UNLIKELY,  # 'L'
        29: SequenceLikelihood.UNLIKELY,  # 'M'
        34: SequenceLikelihood.UNLIKELY,  # 'N'
        36: SequenceLikelihood.UNLIKELY,  # 'O'
        27: SequenceLikelihood.UNLIKELY,  # 'P'
        48: SequenceLikelihood.UNLIKELY,  # 'Q'
        33: SequenceLikelihood.UNLIKELY,  # 'R'
        23: SequenceLikelihood.UNLIKELY,  # 'S'
        32: SequenceLikelihood.UNLIKELY,  # 'T'
        43: SequenceLikelihood.UNLIKELY,  # 'U'
        41: SequenceLikelihood.UNLIKELY,  # 'V'
        52: SequenceLikelihood.NEGATIVE,  # 'W'
        57: SequenceLikelihood.UNLIKELY,  # 'X'
        58: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        3: SequenceLikelihood.UNLIKELY,  # 'a'
        20: SequenceLikelihood.UNLIKELY,  # 'b'
        10: SequenceLikelihood.UNLIKELY,  # 'c'
        11: SequenceLikelihood.UNLIKELY,  # 'd'
        2: SequenceLikelihood.UNLIKELY,  # 'e'
        18: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        19: SequenceLikelihood.NEGATIVE,  # 'h'
        1: SequenceLikelihood.UNLIKELY,  # 'i'
        56: SequenceLikelihood.NEGATIVE,  # 'j'
        40: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        14: SequenceLikelihood.UNLIKELY,  # 'm'
        5: SequenceLikelihood.UNLIKELY,  # 'n'
        4: SequenceLikelihood.UNLIKELY,  # 'o'
        13: SequenceLikelihood.UNLIKELY,  # 'p'
        25: SequenceLikelihood.UNLIKELY,  # 'q'
        7: SequenceLikelihood.UNLIKELY,  # 'r'
        9: SequenceLikelihood.UNLIKELY,  # 's'
        6: SequenceLikelihood.UNLIKELY,  # 't'
        12: SequenceLikelihood.UNLIKELY,  # 'u'
        16: SequenceLikelihood.UNLIKELY,  # 'v'
        44: SequenceLikelihood.UNLIKELY,  # 'w'
        49: SequenceLikelihood.UNLIKELY,  # 'x'
        42: SequenceLikelihood.NEGATIVE,  # 'y'
        17: SequenceLikelihood.UNLIKELY,  # 'z'
        60: SequenceLikelihood.NEGATIVE,  # 'À'
        59: SequenceLikelihood.NEGATIVE,  # 'È'
        62: SequenceLikelihood.NEGATIVE,  # 'É'
        64: SequenceLikelihood.NEGATIVE,  # 'Ì'
        65: SequenceLikelihood.NEGATIVE,  # 'Ò'
        66: SequenceLikelihood.NEGATIVE,  # 'Ó'
        63: SequenceLikelihood.NEGATIVE,  # 'Ù'
        28: SequenceLikelihood.UNLIKELY,  # 'à'
        31: SequenceLikelihood.UNLIKELY,  # 'è'
        50: SequenceLikelihood.NEGATIVE,  # 'é'
        51: SequenceLikelihood.NEGATIVE,  # 'ì'
        47: SequenceLikelihood.UNLIKELY,  # 'ò'
        61: SequenceLikelihood.NEGATIVE,  # 'ó'
        45: SequenceLikelihood.UNLIKELY,  # 'ù'
    },
}

# Character Mapping Table(s):
CP037_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 28,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 50,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 31,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 51,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 60,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 59,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 64,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 20,  # 'b'
    131: 10,  # 'c'
    132: 11,  # 'd'
    133: 2,  # 'e'
    134: 18,  # 'f'
    135: 15,  # 'g'
    136: 19,  # 'h'
    137: 1,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 56,  # 'j'
    146: 40,  # 'k'
    147: 8,  # 'l'
    148: 14,  # 'm'
    149: 5,  # 'n'
    150: 4,  # 'o'
    151: 13,  # 'p'
    152: 25,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 6,  # 't'
    164: 12,  # 'u'
    165: 16,  # 'v'
    166: 44,  # 'w'
    167: 49,  # 'x'
    168: 42,  # 'y'
    169: 17,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 22,  # 'A'
    194: 38,  # 'B'
    195: 24,  # 'C'
    196: 35,  # 'D'
    197: 30,  # 'E'
    198: 39,  # 'F'
    199: 37,  # 'G'
    200: 46,  # 'H'
    201: 21,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 47,  # 'ò'
    206: 61,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 55,  # 'J'
    210: 54,  # 'K'
    211: 26,  # 'L'
    212: 29,  # 'M'
    213: 34,  # 'N'
    214: 36,  # 'O'
    215: 27,  # 'P'
    216: 48,  # 'Q'
    217: 33,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 45,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 23,  # 'S'
    227: 32,  # 'T'
    228: 43,  # 'U'
    229: 41,  # 'V'
    230: 52,  # 'W'
    231: 57,  # 'X'
    232: 58,  # 'Y'
    233: 53,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 65,  # 'Ò'
    238: 66,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 63,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Italian",
    char_to_order_map=CP037_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

CP437_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 28,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 31,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 51,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 47,  # 'ò'
    150: 0,  # 'û'
    151: 45,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 61,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Italian",
    char_to_order_map=CP437_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886187818674064,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

CP500_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 0,  # 'â'
    67: 0,  # 'ä'
    68: 28,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 50,  # 'é'
    82: 0,  # 'ê'
    83: 0,  # 'ë'
    84: 31,  # 'è'
    85: 0,  # 'í'
    86: 0,  # 'î'
    87: 0,  # 'ï'
    88: 51,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 0,  # 'Â'
    99: 0,  # 'Ä'
    100: 60,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 62,  # 'É'
    114: 0,  # 'Ê'
    115: 0,  # 'Ë'
    116: 59,  # 'È'
    117: 0,  # 'Í'
    118: 0,  # 'Î'
    119: 0,  # 'Ï'
    120: 64,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 3,  # 'a'
    130: 20,  # 'b'
    131: 10,  # 'c'
    132: 11,  # 'd'
    133: 2,  # 'e'
    134: 18,  # 'f'
    135: 15,  # 'g'
    136: 19,  # 'h'
    137: 1,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 56,  # 'j'
    146: 40,  # 'k'
    147: 8,  # 'l'
    148: 14,  # 'm'
    149: 5,  # 'n'
    150: 4,  # 'o'
    151: 13,  # 'p'
    152: 25,  # 'q'
    153: 7,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 9,  # 's'
    163: 6,  # 't'
    164: 12,  # 'u'
    165: 16,  # 'v'
    166: 44,  # 'w'
    167: 49,  # 'x'
    168: 42,  # 'y'
    169: 17,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 22,  # 'A'
    194: 38,  # 'B'
    195: 24,  # 'C'
    196: 35,  # 'D'
    197: 30,  # 'E'
    198: 39,  # 'F'
    199: 37,  # 'G'
    200: 46,  # 'H'
    201: 21,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 0,  # 'ô'
    204: 0,  # 'ö'
    205: 47,  # 'ò'
    206: 61,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 55,  # 'J'
    210: 54,  # 'K'
    211: 26,  # 'L'
    212: 29,  # 'M'
    213: 34,  # 'N'
    214: 36,  # 'O'
    215: 27,  # 'P'
    216: 48,  # 'Q'
    217: 33,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 0,  # 'û'
    220: 0,  # 'ü'
    221: 45,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 23,  # 'S'
    227: 32,  # 'T'
    228: 43,  # 'U'
    229: 41,  # 'V'
    230: 52,  # 'W'
    231: 57,  # 'X'
    232: 58,  # 'Y'
    233: 53,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 0,  # 'Ô'
    236: 0,  # 'Ö'
    237: 65,  # 'Ò'
    238: 66,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 0,  # 'Û'
    252: 0,  # 'Ü'
    253: 63,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Italian",
    char_to_order_map=CP500_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

CP850_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 28,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 31,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 51,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 47,  # 'ò'
    150: 0,  # 'û'
    151: 45,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 61,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 60,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 59,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 64,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 66,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 65,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 63,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Italian",
    char_to_order_map=CP850_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

CP858_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 50,  # 'é'
    131: 0,  # 'â'
    132: 0,  # 'ä'
    133: 28,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 0,  # 'ê'
    137: 0,  # 'ë'
    138: 31,  # 'è'
    139: 0,  # 'ï'
    140: 0,  # 'î'
    141: 51,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 62,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 0,  # 'ô'
    148: 0,  # 'ö'
    149: 47,  # 'ò'
    150: 0,  # 'û'
    151: 45,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 61,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 0,  # 'Â'
    183: 60,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 0,  # 'Ê'
    211: 0,  # 'Ë'
    212: 59,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 0,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 64,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 66,  # 'Ó'
    225: 0,  # 'ß'
    226: 0,  # 'Ô'
    227: 65,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 0,  # 'Û'
    235: 63,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Italian",
    char_to_order_map=CP858_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

ISO_8859_1_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 60,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 59,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 64,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 65,  # 'Ò'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 63,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 28,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 31,  # 'è'
    233: 50,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 51,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 47,  # 'ò'
    243: 61,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 45,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Italian",
    char_to_order_map=ISO_8859_1_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

ISO_8859_15_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 60,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 59,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 64,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 65,  # 'Ò'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 63,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 28,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 31,  # 'è'
    233: 50,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 51,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 47,  # 'ò'
    243: 61,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 45,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Italian",
    char_to_order_map=ISO_8859_15_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

MACROMAN_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 62,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 28,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 50,  # 'é'
    143: 31,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 51,  # 'ì'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 61,  # 'ó'
    152: 47,  # 'ò'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 45,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 60,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 0,  # 'Â'
    230: 0,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 59,  # 'È'
    234: 0,  # 'Í'
    235: 0,  # 'Î'
    236: 0,  # 'Ï'
    237: 64,  # 'Ì'
    238: 66,  # 'Ó'
    239: 0,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 65,  # 'Ò'
    242: 0,  # 'Ú'
    243: 0,  # 'Û'
    244: 63,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Italian",
    char_to_order_map=MACROMAN_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)

WINDOWS_1252_ITALIAN_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 22,  # 'A'
    66: 38,  # 'B'
    67: 24,  # 'C'
    68: 35,  # 'D'
    69: 30,  # 'E'
    70: 39,  # 'F'
    71: 37,  # 'G'
    72: 46,  # 'H'
    73: 21,  # 'I'
    74: 55,  # 'J'
    75: 54,  # 'K'
    76: 26,  # 'L'
    77: 29,  # 'M'
    78: 34,  # 'N'
    79: 36,  # 'O'
    80: 27,  # 'P'
    81: 48,  # 'Q'
    82: 33,  # 'R'
    83: 23,  # 'S'
    84: 32,  # 'T'
    85: 43,  # 'U'
    86: 41,  # 'V'
    87: 52,  # 'W'
    88: 57,  # 'X'
    89: 58,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 3,  # 'a'
    98: 20,  # 'b'
    99: 10,  # 'c'
    100: 11,  # 'd'
    101: 2,  # 'e'
    102: 18,  # 'f'
    103: 15,  # 'g'
    104: 19,  # 'h'
    105: 1,  # 'i'
    106: 56,  # 'j'
    107: 40,  # 'k'
    108: 8,  # 'l'
    109: 14,  # 'm'
    110: 5,  # 'n'
    111: 4,  # 'o'
    112: 13,  # 'p'
    113: 25,  # 'q'
    114: 7,  # 'r'
    115: 9,  # 's'
    116: 6,  # 't'
    117: 12,  # 'u'
    118: 16,  # 'v'
    119: 44,  # 'w'
    120: 49,  # 'x'
    121: 42,  # 'y'
    122: 17,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 60,  # 'À'
    193: 0,  # 'Á'
    194: 0,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 59,  # 'È'
    201: 62,  # 'É'
    202: 0,  # 'Ê'
    203: 0,  # 'Ë'
    204: 64,  # 'Ì'
    205: 0,  # 'Í'
    206: 0,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 65,  # 'Ò'
    211: 66,  # 'Ó'
    212: 0,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 63,  # 'Ù'
    218: 0,  # 'Ú'
    219: 0,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 28,  # 'à'
    225: 0,  # 'á'
    226: 0,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 31,  # 'è'
    233: 50,  # 'é'
    234: 0,  # 'ê'
    235: 0,  # 'ë'
    236: 51,  # 'ì'
    237: 0,  # 'í'
    238: 0,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 47,  # 'ò'
    243: 61,  # 'ó'
    244: 0,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 45,  # 'ù'
    250: 0,  # 'ú'
    251: 0,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_ITALIAN_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Italian",
    char_to_order_map=WINDOWS_1252_ITALIAN_CHAR_TO_ORDER,
    language_model=ITALIAN_LANG_MODEL,
    typical_positive_ratio=0.9886036930034635,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÈÉÌÒÓÙàèéìòóù",
)
