/*
 *  PDF to CPCA filter for Canon PDF Printer.
 *  Copyright CANON INC. 2018
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/wait.h>
#include <string.h>
#include <errno.h>
#include <signal.h>

#define	DEF_NO_ERR  0
#define	DEF_ERR    -1

int g_filter_pid = -1;

static void sigterm_handler(int sigcode)
{
	if( g_filter_pid != -1 ){
		kill(g_filter_pid, SIGTERM);
	}
}

static pid_t zExecDriver(char *argv[])
{
	pid_t pid = 0;

	pid = fork();
	if( pid < 0 ) {
		fprintf(stderr, "ERROR: pdftocpca error fork\n");
	}
	else if( pid == 0 )
	{
		execv("/usr/bin/cnpdfdrv", argv);

		fprintf(stderr, "ERROR: pdftocpca error execv\n");
		exit(1);
	}
	else
	{
		close(STDIN_FILENO);
		close(STDOUT_FILENO);
	}

	return pid;
}

int main(int argc, char * argv[])
{
	int err = DEF_NO_ERR;
	int status = 0;
	struct sigaction sigact;

#ifdef	UNIT_TEST
	freopen( "/tmp/unit_test/pdftocpca_leak_check.log", "a+", stderr);
#endif

#ifdef	DEBUG_SLEEP
	sleep(30);
#endif

	memset(&sigact, 0, sizeof(sigact));
	sigact.sa_handler = sigterm_handler;

	if(sigaction(SIGTERM, &sigact, NULL)){
		fputs("ERROR: pdftocpca could not register signal hander.\n", stderr);
		return 1;
	}

	if((argc < 6)||(argc > 7))
	{
		err = DEF_ERR;
	}
	else
	{
		g_filter_pid = zExecDriver(argv);
		if(g_filter_pid <= 0) {
			err = DEF_ERR;
		}
		else {
			waitpid(g_filter_pid, &status, 0);
		}
	}

	return err;
}

