//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_album?language=objc)
pub const kAFInfoDictionary_Album: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"album\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_approximatedurationinseconds?language=objc)
pub const kAFInfoDictionary_ApproximateDurationInSeconds: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"approximate duration in seconds\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_artist?language=objc)
pub const kAFInfoDictionary_Artist: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"artist\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_channellayout?language=objc)
pub const kAFInfoDictionary_ChannelLayout: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"channel layout\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_comments?language=objc)
pub const kAFInfoDictionary_Comments: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"comments\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_composer?language=objc)
pub const kAFInfoDictionary_Composer: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"composer\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_copyright?language=objc)
pub const kAFInfoDictionary_Copyright: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"copyright\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_encodingapplication?language=objc)
pub const kAFInfoDictionary_EncodingApplication: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"encoding application\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_genre?language=objc)
pub const kAFInfoDictionary_Genre: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"genre\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_isrc?language=objc)
pub const kAFInfoDictionary_ISRC: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"ISRC\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_keysignature?language=objc)
pub const kAFInfoDictionary_KeySignature: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"key signature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_lyricist?language=objc)
pub const kAFInfoDictionary_Lyricist: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"lyricist\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_nominalbitrate?language=objc)
pub const kAFInfoDictionary_NominalBitRate: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"nominal bit rate\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_recordeddate?language=objc)
pub const kAFInfoDictionary_RecordedDate: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"recorded date\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_sourcebitdepth?language=objc)
pub const kAFInfoDictionary_SourceBitDepth: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"source bit depth\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_sourceencoder?language=objc)
pub const kAFInfoDictionary_SourceEncoder: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"source encoder\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_subtitle?language=objc)
pub const kAFInfoDictionary_SubTitle: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"subtitle\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_tempo?language=objc)
pub const kAFInfoDictionary_Tempo: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"tempo\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_timesignature?language=objc)
pub const kAFInfoDictionary_TimeSignature: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"time signature\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_title?language=objc)
pub const kAFInfoDictionary_Title: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"title\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_tracknumber?language=objc)
pub const kAFInfoDictionary_TrackNumber: &CStr =
    unsafe { CStr::from_bytes_with_nul_unchecked(b"track number\0") };
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kafinfodictionary_year?language=objc)
pub const kAFInfoDictionary_Year: &CStr = unsafe { CStr::from_bytes_with_nul_unchecked(b"year\0") };
/// Identifier for an audio file type.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofiletypeid?language=objc)
pub type AudioFileTypeID = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileaifftype?language=objc)
pub const kAudioFileAIFFType: AudioFileTypeID = 0x41494646;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileaifctype?language=objc)
pub const kAudioFileAIFCType: AudioFileTypeID = 0x41494643;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilewavetype?language=objc)
pub const kAudioFileWAVEType: AudioFileTypeID = 0x57415645;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilerf64type?language=objc)
pub const kAudioFileRF64Type: AudioFileTypeID = 0x52463634;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilebw64type?language=objc)
pub const kAudioFileBW64Type: AudioFileTypeID = 0x42573634;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilewave64type?language=objc)
pub const kAudioFileWave64Type: AudioFileTypeID = 0x57363466;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilesounddesigner2type?language=objc)
pub const kAudioFileSoundDesigner2Type: AudioFileTypeID = 0x53643266;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilenexttype?language=objc)
pub const kAudioFileNextType: AudioFileTypeID = 0x4e655854;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilemp3type?language=objc)
pub const kAudioFileMP3Type: AudioFileTypeID = 0x4d504733;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilemp2type?language=objc)
pub const kAudioFileMP2Type: AudioFileTypeID = 0x4d504732;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilemp1type?language=objc)
pub const kAudioFileMP1Type: AudioFileTypeID = 0x4d504731;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileac3type?language=objc)
pub const kAudioFileAC3Type: AudioFileTypeID = 0x61632d33;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileaac_adtstype?language=objc)
pub const kAudioFileAAC_ADTSType: AudioFileTypeID = 0x61647473;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilempeg4type?language=objc)
pub const kAudioFileMPEG4Type: AudioFileTypeID = 0x6d703466;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilem4atype?language=objc)
pub const kAudioFileM4AType: AudioFileTypeID = 0x6d346166;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilem4btype?language=objc)
pub const kAudioFileM4BType: AudioFileTypeID = 0x6d346266;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilecaftype?language=objc)
pub const kAudioFileCAFType: AudioFileTypeID = 0x63616666;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofile3gptype?language=objc)
pub const kAudioFile3GPType: AudioFileTypeID = 0x33677070;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofile3gp2type?language=objc)
pub const kAudioFile3GP2Type: AudioFileTypeID = 0x33677032;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileamrtype?language=objc)
pub const kAudioFileAMRType: AudioFileTypeID = 0x616d7266;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileflactype?language=objc)
pub const kAudioFileFLACType: AudioFileTypeID = 0x666c6163;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilelatminloastype?language=objc)
pub const kAudioFileLATMInLOASType: AudioFileTypeID = 0x6c6f6173;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileunspecifiederror?language=objc)
pub const kAudioFileUnspecifiedError: OSStatus = 0x7768743f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileunsupportedfiletypeerror?language=objc)
pub const kAudioFileUnsupportedFileTypeError: OSStatus = 0x7479703f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileunsupporteddataformaterror?language=objc)
pub const kAudioFileUnsupportedDataFormatError: OSStatus = 0x666d743f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileunsupportedpropertyerror?language=objc)
pub const kAudioFileUnsupportedPropertyError: OSStatus = 0x7074793f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilebadpropertysizeerror?language=objc)
pub const kAudioFileBadPropertySizeError: OSStatus = 0x2173697a;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepermissionserror?language=objc)
pub const kAudioFilePermissionsError: OSStatus = 0x70726d3f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilenotoptimizederror?language=objc)
pub const kAudioFileNotOptimizedError: OSStatus = 0x6f70746d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileinvalidchunkerror?language=objc)
pub const kAudioFileInvalidChunkError: OSStatus = 0x63686b3f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofiledoesnotallow64bitdatasizeerror?language=objc)
pub const kAudioFileDoesNotAllow64BitDataSizeError: OSStatus = 0x6f66663f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileinvalidpacketoffseterror?language=objc)
pub const kAudioFileInvalidPacketOffsetError: OSStatus = 0x70636b3f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileinvalidpacketdependencyerror?language=objc)
pub const kAudioFileInvalidPacketDependencyError: OSStatus = 0x6465703f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileinvalidfileerror?language=objc)
pub const kAudioFileInvalidFileError: OSStatus = 0x6474613f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileoperationnotsupportederror?language=objc)
pub const kAudioFileOperationNotSupportedError: OSStatus = 0x6F703F3F;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilenotopenerror?language=objc)
pub const kAudioFileNotOpenError: OSStatus = -38;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileendoffileerror?language=objc)
pub const kAudioFileEndOfFileError: OSStatus = -39;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepositionerror?language=objc)
pub const kAudioFilePositionError: OSStatus = -40;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilefilenotfounderror?language=objc)
pub const kAudioFileFileNotFoundError: OSStatus = -43;

/// These are flags that can be used with the CreateURL API call
///
/// If set, then the CreateURL call will erase the contents of an existing file
/// If not set, then the CreateURL call will fail if the file already exists
///
/// Normally, newly created and optimized files will have padding added in order to page align
/// the data to 4KB boundaries. This makes reading the data more efficient.
/// When disk space is a concern, this flag can be set so that the padding will not be added.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofileflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFileFlags(pub u32);
bitflags::bitflags! {
    impl AudioFileFlags: u32 {
        #[doc(alias = "kAudioFileFlags_EraseFile")]
        const EraseFile = 1;
        #[doc(alias = "kAudioFileFlags_DontPageAlignAudioData")]
        const DontPageAlignAudioData = 2;
    }
}

unsafe impl Encode for AudioFileFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioFileFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilepermissions?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFilePermissions(pub i8);
impl AudioFilePermissions {
    #[doc(alias = "kAudioFileReadPermission")]
    pub const ReadPermission: Self = Self(0x01);
    #[doc(alias = "kAudioFileWritePermission")]
    pub const WritePermission: Self = Self(0x02);
    #[doc(alias = "kAudioFileReadWritePermission")]
    pub const ReadWritePermission: Self = Self(0x03);
}

unsafe impl Encode for AudioFilePermissions {
    const ENCODING: Encoding = i8::ENCODING;
}

unsafe impl RefEncode for AudioFilePermissions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudiofileid?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioFileID {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioFileID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("OpaqueAudioFileID", &[]));
}

/// An opaque reference to an AudioFile object.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofileid?language=objc)
pub type AudioFileID = *mut OpaqueAudioFileID;

/// A constant for an AudioFile property.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilepropertyid?language=objc)
pub type AudioFilePropertyID = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileloopdirection_nolooping?language=objc)
pub const kAudioFileLoopDirection_NoLooping: u32 = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileloopdirection_forward?language=objc)
pub const kAudioFileLoopDirection_Forward: u32 = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileloopdirection_forwardandbackward?language=objc)
pub const kAudioFileLoopDirection_ForwardAndBackward: u32 = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileloopdirection_backward?language=objc)
pub const kAudioFileLoopDirection_Backward: u32 = 3;

/// A struct for describing a SMPTE time.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofile_smpte_time?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFile_SMPTE_Time {
    pub mHours: i8,
    pub mMinutes: u8,
    pub mSeconds: u8,
    pub mFrames: u8,
    pub mSubFrameSampleOffset: u32,
}

unsafe impl Encode for AudioFile_SMPTE_Time {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFile_SMPTE_Time",
        &[
            <i8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u8>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioFile_SMPTE_Time {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilemarkertype_generic?language=objc)
pub const kAudioFileMarkerType_Generic: u32 = 0;

/// A marker annotates a position in an audio file with additional information.
///
/// (description)
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilemarker?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFileMarker {
    pub mFramePosition: f64,
    pub mName: *const CFString,
    pub mMarkerID: i32,
    pub mSMPTETime: AudioFile_SMPTE_Time,
    pub mType: u32,
    pub mReserved: u16,
    pub mChannel: u16,
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioFileMarker {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFileMarker",
        &[
            <f64>::ENCODING,
            <*const CFString>::ENCODING,
            <i32>::ENCODING,
            <AudioFile_SMPTE_Time>::ENCODING,
            <u32>::ENCODING,
            <u16>::ENCODING,
            <u16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioFileMarker {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A list of AudioFileMarker.
///
/// This defines the SMPTE timing scheme used in the marker list. See CAFFile.h for the values used here.
///
/// The number of markers in the mMarkers list.
///
/// A list of AudioFileMarker.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilemarkerlist?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFileMarkerList {
    pub mSMPTE_TimeType: u32,
    pub mNumberMarkers: u32,
    pub mMarkers: [AudioFileMarker; 1],
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioFileMarkerList {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFileMarkerList",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[AudioFileMarker; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioFileMarkerList {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// TODO: pub fn NumBytesToNumAudioFileMarkers(in_num_bytes: usize,) -> usize;

// TODO: pub fn NumAudioFileMarkersToNumBytes(in_num_markers: usize,) -> usize;

/// These are flags for an AudioFileRegion that specify a playback direction.
///
/// One or multiple of these flags can be set. For example, if both kAudioFileRegionFlag_LoopEnable and
/// kAudioFileRegionFlag_PlayForward are set, then the region will play as a forward loop. If only
/// kAudioFileRegionFlag_PlayForward is set, then the region will be played forward once.
///
/// If this flag is set, the region will be looped. One or both of the following must also be set.
///
/// If this flag is set, the region will be played forward.
///
/// If this flag is set, the region will be played backward.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofileregionflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFileRegionFlags(pub u32);
bitflags::bitflags! {
    impl AudioFileRegionFlags: u32 {
        #[doc(alias = "kAudioFileRegionFlag_LoopEnable")]
        const LoopEnable = 1;
        #[doc(alias = "kAudioFileRegionFlag_PlayForward")]
        const PlayForward = 2;
        #[doc(alias = "kAudioFileRegionFlag_PlayBackward")]
        const PlayBackward = 4;
    }
}

unsafe impl Encode for AudioFileRegionFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioFileRegionFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// An AudioFileRegion specifies a segment of audio data.
///
/// Generally a region consists of at least two markers marking the beginning and end of the segment.
/// There may also be other markers defining other meta information such as sync point.
///
/// each region must have a unique ID.
///
/// The name of the region.
///
/// AudioFileRegionFlags.
///
/// The number of markers in the mMarkers array.
///
/// A variable length array of AudioFileMarkers.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofileregion?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFileRegion {
    pub mRegionID: u32,
    pub mName: NonNull<CFString>,
    pub mFlags: AudioFileRegionFlags,
    pub mNumberMarkers: u32,
    pub mMarkers: [AudioFileMarker; 1],
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioFileRegion {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFileRegion",
        &[
            <u32>::ENCODING,
            <NonNull<CFString>>::ENCODING,
            <AudioFileRegionFlags>::ENCODING,
            <u32>::ENCODING,
            <[AudioFileMarker; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioFileRegion {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// A list of the AudioFileRegions in a file.
///
/// This is the struct used by the kAudioFilePropertyRegionList property.
///
/// This defines the SMPTE timing scheme used in the file. See CAFFile.h for the values used here.
///
/// The number of regions in the mRegions list.
///
/// A list of AudioFileRegions. Note that AudioFileMarkers are variable length, so this list cannot
/// be accessed as an array. Use the NextAudioFileRegion macro for traversing the list instead.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofileregionlist?language=objc)
#[cfg(feature = "objc2-core-foundation")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFileRegionList {
    pub mSMPTE_TimeType: u32,
    pub mNumberRegions: u32,
    pub mRegions: [AudioFileRegion; 1],
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl Encode for AudioFileRegionList {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFileRegionList",
        &[
            <u32>::ENCODING,
            <u32>::ENCODING,
            <[AudioFileRegion; 1]>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2-core-foundation")]
unsafe impl RefEncode for AudioFileRegionList {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// TODO: pub fn NextAudioFileRegion(in_af_region_ptr: NonNull<AudioFileRegion>,)-> Option<NonNull<AudioFileRegion>>;

/// used for properties kAudioFilePropertyPacketToFrame and kAudioFilePropertyFrameToPacket
///
/// See description of kAudioFilePropertyPacketToFrame and kAudioFilePropertyFrameToPacket
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioframepackettranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFramePacketTranslation {
    pub mFrame: i64,
    pub mPacket: i64,
    pub mFrameOffsetInPacket: u32,
}

unsafe impl Encode for AudioFramePacketTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFramePacketTranslation",
        &[<i64>::ENCODING, <i64>::ENCODING, <u32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioFramePacketTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// flags for the AudioBytePacketTranslation mFlags field
///
/// There is currently only one flag.
///
///
/// If the set then the result value is an estimate.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiobytepackettranslationflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioBytePacketTranslationFlags(pub u32);
bitflags::bitflags! {
    impl AudioBytePacketTranslationFlags: u32 {
        #[doc(alias = "kBytePacketTranslationFlag_IsEstimate")]
        const BytePacketTranslationFlag_IsEstimate = 1;
    }
}

unsafe impl Encode for AudioBytePacketTranslationFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioBytePacketTranslationFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for properties kAudioFileByteToPacket and kAudioFilePacketToByte
///
/// See description of kAudioFileByteToPacket and kAudioFilePacketToByte
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiobytepackettranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioBytePacketTranslation {
    pub mByte: i64,
    pub mPacket: i64,
    pub mByteOffsetInPacket: u32,
    pub mFlags: AudioBytePacketTranslationFlags,
}

unsafe impl Encode for AudioBytePacketTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioBytePacketTranslation",
        &[
            <i64>::ENCODING,
            <i64>::ENCODING,
            <u32>::ENCODING,
            <AudioBytePacketTranslationFlags>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for AudioBytePacketTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This contains information about the number of valid frames in a file and where they begin and end.
///
/// Some data formats may have packets whose contents are not completely valid, but represent priming or remainder
/// frames that are not meant to be played. For example a file with 100 packets of AAC is nominally 1024 * 100 = 102400 frames
/// of data. However the first 2112 frames of that may be priming frames and there may be some
/// number of remainder frames added to pad out to a full packet of 1024 frames. The priming and remainder frames should be
/// discarded. The total number of packets in the file times the frames per packet (or counting each packet's frames
/// individually for a variable frames per packet format) minus mPrimingFrames, minus mRemainderFrames, should
/// equal mNumberValidFrames.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilepackettableinfo?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFilePacketTableInfo {
    pub mNumberValidFrames: i64,
    pub mPrimingFrames: i32,
    pub mRemainderFrames: i32,
}

unsafe impl Encode for AudioFilePacketTableInfo {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFilePacketTableInfo",
        &[<i64>::ENCODING, <i32>::ENCODING, <i32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioFilePacketTableInfo {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for property kAudioFilePropertyPacketRangeByteCountUpperBound
///
/// See description of kAudioFilePropertyPacketRangeByteCountUpperBound
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiopacketrangebytecounttranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioPacketRangeByteCountTranslation {
    pub mPacket: i64,
    pub mPacketCount: i64,
    pub mByteCountUpperBound: i64,
}

unsafe impl Encode for AudioPacketRangeByteCountTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioPacketRangeByteCountTranslation",
        &[<i64>::ENCODING, <i64>::ENCODING, <i64>::ENCODING],
    );
}

unsafe impl RefEncode for AudioPacketRangeByteCountTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for property kAudioFilePropertyPacketToRollDistance
///
/// See descriptions of kAudioFilePropertyPacketToRollDistance and kAudioFilePropertyRestrictsRandomAccess
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiopacketrolldistancetranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioPacketRollDistanceTranslation {
    pub mPacket: i64,
    pub mRollDistance: i64,
}

unsafe impl Encode for AudioPacketRollDistanceTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioPacketRollDistanceTranslation",
        &[<i64>::ENCODING, <i64>::ENCODING],
    );
}

unsafe impl RefEncode for AudioPacketRollDistanceTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for property kAudioFilePropertyPreviousIndependentPacket and kAudioFilePropertyNextIndependentPacket
///
/// See descriptions of kAudioFilePropertyPreviousIndependentPacket and kAudioFilePropertyNextIndependentPacket
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audioindependentpackettranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioIndependentPacketTranslation {
    pub mPacket: i64,
    pub mIndependentlyDecodablePacket: i64,
}

unsafe impl Encode for AudioIndependentPacketTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioIndependentPacketTranslation",
        &[<i64>::ENCODING, <i64>::ENCODING],
    );
}

unsafe impl RefEncode for AudioIndependentPacketTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// used for property kAudioFilePropertyPacketToDependencyInfo
///
/// See descriptions of kAudioFilePropertyPacketToDependencyInfo and kAudioFilePropertyRestrictsRandomAccess
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiopacketdependencyinfotranslation?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioPacketDependencyInfoTranslation {
    pub mPacket: i64,
    pub mIsIndependentlyDecodable: u32,
    pub mNumberPrerollPackets: u32,
}

unsafe impl Encode for AudioPacketDependencyInfoTranslation {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioPacketDependencyInfoTranslation",
        &[<i64>::ENCODING, <u32>::ENCODING, <u32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioPacketDependencyInfoTranslation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// creates a new audio file (or initialises an existing file)
    ///
    /// creates a new (or initialises an existing) audio file specified by the URL.
    /// Upon success, an AudioFileID is returned which can be used for subsequent calls
    /// to the AudioFile APIs.
    ///
    /// Parameter `inFileRef`: an CFURLRef fully specifying the path of the file to create/initialise
    ///
    /// Parameter `inFileType`: an AudioFileTypeID indicating the type of audio file to create.
    ///
    /// Parameter `inFormat`: an AudioStreamBasicDescription describing the data format that will be
    /// added to the audio file.
    ///
    /// Parameter `inFlags`: relevant flags for creating/opening the file.
    /// if kAudioFileFlags_EraseFile is set, it will erase an existing file
    /// if not set, then the Create call will fail if the URL is an existing file
    ///
    /// Parameter `outAudioFile`: if successful, an AudioFileID that can be used for subsequent AudioFile calls.
    ///
    /// Returns: returns noErr if successful.
    #[cfg(all(feature = "objc2-core-audio-types", feature = "objc2-core-foundation"))]
    pub fn AudioFileCreateWithURL(
        in_file_ref: &CFURL,
        in_file_type: AudioFileTypeID,
        in_format: NonNull<AudioStreamBasicDescription>,
        in_flags: AudioFileFlags,
        out_audio_file: NonNull<AudioFileID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Open an existing audio file.
    ///
    /// Open an existing audio file for reading or reading and writing.
    ///
    /// Parameter `inFileRef`: the CFURLRef of an existing audio file.
    ///
    /// Parameter `inPermissions`: use the permission constants
    ///
    /// Parameter `inFileTypeHint`: For files which have no filename extension and whose type cannot be easily or
    /// uniquely determined from the data (ADTS,AC3), this hint can be used to indicate the file type.
    /// Otherwise you can pass zero for this. The hint is only used on OS versions 10.3.1 or greater.
    /// For OS versions prior to that, opening files of the above description will fail.
    ///
    /// Parameter `outAudioFile`: upon success, an AudioFileID that can be used for subsequent
    /// AudioFile calls.
    ///
    /// Returns: returns noErr if successful.
    #[cfg(feature = "objc2-core-foundation")]
    pub fn AudioFileOpenURL(
        in_file_ref: &CFURL,
        in_permissions: AudioFilePermissions,
        in_file_type_hint: AudioFileTypeID,
        out_audio_file: NonNull<AudioFileID>,
    ) -> OSStatus;
}

/// A callback for reading data. used with AudioFileOpenWithCallbacks or AudioFileInitializeWithCallbacks.
///
/// a function that will be called when AudioFile needs to read data.
///
/// Parameter `inClientData`: A pointer to the client data as set in the inClientData parameter to AudioFileXXXWithCallbacks.
///
/// Parameter `inPosition`: An offset into the data from which to read.
///
/// Parameter `requestCount`: The number of bytes to read.
///
/// Parameter `buffer`: The buffer in which to put the data read.
///
/// Parameter `actualCount`: The callback should set this to the number of bytes successfully read.
///
/// Returns: The callback should return noErr on success, or an appropriate error code on failure.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofile_readproc?language=objc)
pub type AudioFile_ReadProc = Option<
    unsafe extern "C-unwind" fn(
        NonNull<c_void>,
        i64,
        u32,
        NonNull<c_void>,
        NonNull<u32>,
    ) -> OSStatus,
>;

/// A callback for writing data. used with AudioFileOpenWithCallbacks or AudioFileInitializeWithCallbacks.
///
/// a function that will be called when AudioFile needs to write data.
///
/// Parameter `inClientData`: A pointer to the client data as set in the inClientData parameter to AudioFileXXXWithCallbacks.
///
/// Parameter `inPosition`: An offset into the data from which to read.
///
/// Parameter `requestCount`: The number of bytes to write.
///
/// Parameter `buffer`: The buffer containing the data to write.
///
/// Parameter `actualCount`: The callback should set this to the number of bytes successfully written.
///
/// Returns: The callback should return noErr on success, or an appropriate error code on failure.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofile_writeproc?language=objc)
pub type AudioFile_WriteProc = Option<
    unsafe extern "C-unwind" fn(
        NonNull<c_void>,
        i64,
        u32,
        NonNull<c_void>,
        NonNull<u32>,
    ) -> OSStatus,
>;

/// A callback for getting the size of the file data. used with AudioFileOpenWithCallbacks or AudioFileInitializeWithCallbacks.
///
/// a function that will be called when AudioFile needs to determine the size of the file data. This size is for all of the
/// data in the file, not just the audio data.
///
/// Parameter `inClientData`: A pointer to the client data as set in the inClientData parameter to AudioFileXXXWithCallbacks.
///
/// Returns: The callback should return the size of the data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofile_getsizeproc?language=objc)
pub type AudioFile_GetSizeProc = Option<unsafe extern "C-unwind" fn(NonNull<c_void>) -> i64>;

/// A callback for setting the size of the file data. used with AudioFileOpenWithCallbacks or AudioFileInitializeWithCallbacks.
///
/// a function that will be called when AudioFile needs to set the size of the file data. This size is for all of the
/// data in the file, not just the audio data. This will only be called if the file is written to.
///
/// Parameter `inClientData`: A pointer to the client data as set in the inClientData parameter to AudioFileXXXWithCallbacks.
///
/// Returns: The callback should return the size of the data.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofile_setsizeproc?language=objc)
pub type AudioFile_SetSizeProc =
    Option<unsafe extern "C-unwind" fn(NonNull<c_void>, i64) -> OSStatus>;

extern "C-unwind" {
    /// Wipe clean an existing file. You provide callbacks that the AudioFile API
    /// will use to get the data.
    ///
    /// Parameter `inClientData`: a constant that will be passed to your callbacks.
    ///
    /// Parameter `inReadFunc`: a function that will be called when AudioFile needs to read data.
    ///
    /// Parameter `inWriteFunc`: a function that will be called when AudioFile needs to write data.
    ///
    /// Parameter `inGetSizeFunc`: a function that will be called when AudioFile needs to know the file size.
    ///
    /// Parameter `inSetSizeFunc`: a function that will be called when AudioFile needs to set the file size.
    ///
    ///
    /// Parameter `inFileType`: an AudioFileTypeID indicating the type of audio file to which to initialize the file.
    ///
    /// Parameter `inFormat`: an AudioStreamBasicDescription describing the data format that will be
    /// added to the audio file.
    ///
    /// Parameter `inFlags`: flags for creating/opening the file. Currently zero.
    ///
    /// Parameter `outAudioFile`: upon success, an AudioFileID that can be used for subsequent
    /// AudioFile calls.
    ///
    /// Returns: returns noErr if successful.
    #[cfg(feature = "objc2-core-audio-types")]
    pub fn AudioFileInitializeWithCallbacks(
        in_client_data: NonNull<c_void>,
        in_read_func: AudioFile_ReadProc,
        in_write_func: AudioFile_WriteProc,
        in_get_size_func: AudioFile_GetSizeProc,
        in_set_size_func: AudioFile_SetSizeProc,
        in_file_type: AudioFileTypeID,
        in_format: NonNull<AudioStreamBasicDescription>,
        in_flags: AudioFileFlags,
        out_audio_file: NonNull<AudioFileID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Open an existing file. You provide callbacks that the AudioFile API
    /// will use to get the data.
    ///
    /// Parameter `inClientData`: a constant that will be passed to your callbacks.
    ///
    /// Parameter `inReadFunc`: a function that will be called when AudioFile needs to read data.
    ///
    /// Parameter `inWriteFunc`: a function that will be called when AudioFile needs to write data.
    ///
    /// Parameter `inGetSizeFunc`: a function that will be called when AudioFile needs to know the total file size.
    ///
    /// Parameter `inSetSizeFunc`: a function that will be called when AudioFile needs to set the file size.
    ///
    ///
    /// Parameter `inFileTypeHint`: For files which have no filename extension and whose type cannot be easily or
    /// uniquely determined from the data (ADTS,AC3), this hint can be used to indicate the file type.
    /// Otherwise you can pass zero for this. The hint is only used on OS versions 10.3.1 or greater.
    /// For OS versions prior to that, opening files of the above description will fail.
    ///
    /// Parameter `outAudioFile`: upon success, an AudioFileID that can be used for subsequent
    /// AudioFile calls.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileOpenWithCallbacks(
        in_client_data: NonNull<c_void>,
        in_read_func: AudioFile_ReadProc,
        in_write_func: AudioFile_WriteProc,
        in_get_size_func: AudioFile_GetSizeProc,
        in_set_size_func: AudioFile_SetSizeProc,
        in_file_type_hint: AudioFileTypeID,
        out_audio_file: NonNull<AudioFileID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Close an existing audio file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileClose(in_audio_file: AudioFileID) -> OSStatus;
}

extern "C-unwind" {
    /// Move the audio data to the end of the file and other internal optimizations of the file structure.
    ///
    /// Optimize the file so additional audio data can be appended to
    /// the existing data. Generally, this will place the audio data at
    /// the end of the file so additional writes can be placed to the
    /// file end. This can be a potentially expensive and time-consuming operation
    /// and should not be used during time critical operations. There is
    /// a kAudioFilePropertyIsOptimized property for checking on the optimized state
    /// of the file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileOptimize(in_audio_file: AudioFileID) -> OSStatus;
}

/// Read bytes of audio data from the audio file.
///
///
/// Returns kAudioFileEndOfFileError when read encounters end of file.
///
/// Parameter `inAudioFile`: an AudioFileID.
///
/// Parameter `inUseCache`: true if it is desired to cache the data upon read, else false
///
/// Parameter `inStartingByte`: the byte offset of the audio data desired to be returned
///
/// Parameter `ioNumBytes`: on input, the number of bytes to read, on output, the number of
/// bytes actually read.
///
/// Parameter `outBuffer`: outBuffer should be a void * to user allocated memory large enough for the requested bytes.
///
/// Returns: returns noErr if successful.
#[inline]
pub unsafe extern "C-unwind" fn AudioFileReadBytes(
    in_audio_file: AudioFileID,
    in_use_cache: bool,
    in_starting_byte: i64,
    io_num_bytes: NonNull<u32>,
    out_buffer: NonNull<c_void>,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioFileReadBytes(
            in_audio_file: AudioFileID,
            in_use_cache: Boolean,
            in_starting_byte: i64,
            io_num_bytes: NonNull<u32>,
            out_buffer: NonNull<c_void>,
        ) -> OSStatus;
    }
    unsafe {
        AudioFileReadBytes(
            in_audio_file,
            in_use_cache as _,
            in_starting_byte,
            io_num_bytes,
            out_buffer,
        )
    }
}

/// Write bytes of audio data to the audio file.
///
/// Parameter `inAudioFile`: an AudioFileID.
///
/// Parameter `inUseCache`: true if it is desired to cache the data upon write, else false
///
/// Parameter `inStartingByte`: the byte offset where the audio data should be written
///
/// Parameter `ioNumBytes`: on input, the number of bytes to write, on output, the number of
/// bytes actually written.
///
/// Parameter `inBuffer`: inBuffer should be a void * containing the bytes to be written
///
/// Returns: returns noErr if successful.
#[inline]
pub unsafe extern "C-unwind" fn AudioFileWriteBytes(
    in_audio_file: AudioFileID,
    in_use_cache: bool,
    in_starting_byte: i64,
    io_num_bytes: NonNull<u32>,
    in_buffer: NonNull<c_void>,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioFileWriteBytes(
            in_audio_file: AudioFileID,
            in_use_cache: Boolean,
            in_starting_byte: i64,
            io_num_bytes: NonNull<u32>,
            in_buffer: NonNull<c_void>,
        ) -> OSStatus;
    }
    unsafe {
        AudioFileWriteBytes(
            in_audio_file,
            in_use_cache as _,
            in_starting_byte,
            io_num_bytes,
            in_buffer,
        )
    }
}

/// Read packets of audio data from the audio file.
///
/// AudioFileReadPacketData reads as many of the requested number of packets
/// as will fit in the buffer size given by ioNumPackets.
/// Unlike the deprecated AudioFileReadPackets, ioNumPackets must be initialized.
/// If the byte size of the number packets requested is
/// less than the buffer size, ioNumBytes will be reduced.
/// If the buffer is too small for the number of packets
/// requested, ioNumPackets and ioNumBytes will be reduced
/// to the number of packets that can be accommodated and their byte size.
/// Returns kAudioFileEndOfFileError when read encounters end of file.
/// For all uncompressed formats, packets == frames.
///
///
/// Parameter `inAudioFile`: an AudioFileID.
///
/// Parameter `inUseCache`: true if it is desired to cache the data upon read, else false
///
/// Parameter `ioNumBytes`: on input the size of outBuffer in bytes.
/// on output, the number of bytes actually returned.
///
/// Parameter `outPacketDescriptions`: An array of packet descriptions describing the packets being returned.
/// The size of the array must be greater or equal to the number of packets requested.
/// On return the packet description will be filled out with the packet offsets and sizes.
/// Packet descriptions are ignored for CBR data.
///
/// Parameter `inStartingPacket`: The packet index of the first packet desired to be returned
///
/// Parameter `ioNumPackets`: on input, the number of packets to read, on output, the number of
/// packets actually read.
///
/// Parameter `outBuffer`: outBuffer should be a pointer to user allocated memory.
///
/// Returns: returns noErr if successful.
#[cfg(feature = "objc2-core-audio-types")]
#[inline]
pub unsafe extern "C-unwind" fn AudioFileReadPacketData(
    in_audio_file: AudioFileID,
    in_use_cache: bool,
    io_num_bytes: NonNull<u32>,
    out_packet_descriptions: *mut AudioStreamPacketDescription,
    in_starting_packet: i64,
    io_num_packets: NonNull<u32>,
    out_buffer: *mut c_void,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioFileReadPacketData(
            in_audio_file: AudioFileID,
            in_use_cache: Boolean,
            io_num_bytes: NonNull<u32>,
            out_packet_descriptions: *mut AudioStreamPacketDescription,
            in_starting_packet: i64,
            io_num_packets: NonNull<u32>,
            out_buffer: *mut c_void,
        ) -> OSStatus;
    }
    unsafe {
        AudioFileReadPacketData(
            in_audio_file,
            in_use_cache as _,
            io_num_bytes,
            out_packet_descriptions,
            in_starting_packet,
            io_num_packets,
            out_buffer,
        )
    }
}

/// Read packets of audio data from the audio file.
///
/// AudioFileReadPackets is DEPRECATED. Use AudioFileReadPacketData instead.
/// READ THE HEADER DOC FOR AudioFileReadPacketData. It is not a drop-in replacement.
/// In particular, for AudioFileReadPacketData ioNumBytes must be initialized to the buffer size.
/// AudioFileReadPackets assumes you have allocated your buffer to ioNumPackets times the maximum packet size.
/// For many compressed formats this will only use a portion of the buffer since the ratio of the maximum
/// packet size to the typical packet size can be large. Use AudioFileReadPacketData instead.
///
///
/// Parameter `inAudioFile`: an AudioFileID.
///
/// Parameter `inUseCache`: true if it is desired to cache the data upon read, else false
///
/// Parameter `outNumBytes`: on output, the number of bytes actually returned
///
/// Parameter `outPacketDescriptions`: on output, an array of packet descriptions describing
/// the packets being returned. NULL may be passed for this
/// parameter. Nothing will be returned for linear pcm data.
///
/// Parameter `inStartingPacket`: the packet index of the first packet desired to be returned
///
/// Parameter `ioNumPackets`: on input, the number of packets to read, on output, the number of
/// packets actually read.
///
/// Parameter `outBuffer`: outBuffer should be a pointer to user allocated memory of size:
/// number of packets requested times file's maximum (or upper bound on)
/// packet size.
///
/// Returns: returns noErr if successful.
#[cfg(feature = "objc2-core-audio-types")]
#[deprecated = "no longer supported"]
#[inline]
pub unsafe extern "C-unwind" fn AudioFileReadPackets(
    in_audio_file: AudioFileID,
    in_use_cache: bool,
    out_num_bytes: NonNull<u32>,
    out_packet_descriptions: *mut AudioStreamPacketDescription,
    in_starting_packet: i64,
    io_num_packets: NonNull<u32>,
    out_buffer: *mut c_void,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioFileReadPackets(
            in_audio_file: AudioFileID,
            in_use_cache: Boolean,
            out_num_bytes: NonNull<u32>,
            out_packet_descriptions: *mut AudioStreamPacketDescription,
            in_starting_packet: i64,
            io_num_packets: NonNull<u32>,
            out_buffer: *mut c_void,
        ) -> OSStatus;
    }
    unsafe {
        AudioFileReadPackets(
            in_audio_file,
            in_use_cache as _,
            out_num_bytes,
            out_packet_descriptions,
            in_starting_packet,
            io_num_packets,
            out_buffer,
        )
    }
}

/// Write packets of audio data to the audio file.
///
/// For all uncompressed formats, packets == frames.
///
/// Parameter `inAudioFile`: an AudioFileID.
///
/// Parameter `inUseCache`: true if it is desired to cache the data upon write, else false
///
/// Parameter `inNumBytes`: the number of bytes being provided for write
///
/// Parameter `inPacketDescriptions`: an array of packet descriptions describing the packets being
/// provided. Not all formats require packet descriptions to be
/// provided. NULL may be passed if no descriptions are required.
///
/// Parameter `inStartingPacket`: the packet index of where the first packet provided should be placed.
///
/// Parameter `ioNumPackets`: on input, the number of packets to write, on output, the number of
/// packets actually written.
///
/// Parameter `inBuffer`: a void * to user allocated memory containing the packets to write.
///
/// Returns: returns noErr if successful.
#[cfg(feature = "objc2-core-audio-types")]
#[inline]
pub unsafe extern "C-unwind" fn AudioFileWritePackets(
    in_audio_file: AudioFileID,
    in_use_cache: bool,
    in_num_bytes: u32,
    in_packet_descriptions: *const AudioStreamPacketDescription,
    in_starting_packet: i64,
    io_num_packets: NonNull<u32>,
    in_buffer: NonNull<c_void>,
) -> OSStatus {
    extern "C-unwind" {
        fn AudioFileWritePackets(
            in_audio_file: AudioFileID,
            in_use_cache: Boolean,
            in_num_bytes: u32,
            in_packet_descriptions: *const AudioStreamPacketDescription,
            in_starting_packet: i64,
            io_num_packets: NonNull<u32>,
            in_buffer: NonNull<c_void>,
        ) -> OSStatus;
    }
    unsafe {
        AudioFileWritePackets(
            in_audio_file,
            in_use_cache as _,
            in_num_bytes,
            in_packet_descriptions,
            in_starting_packet,
            io_num_packets,
            in_buffer,
        )
    }
}

extern "C-unwind" {
    /// Get the number of user data items with a certain ID in the file
    ///
    /// "User Data" refers to chunks in AIFF, CAF and WAVE files, or resources
    /// in Sound Designer II files, and possibly other things in other files.
    /// For simplicity, referred to below as "chunks".
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `outNumberItems`: on output, if successful, number of chunks of this type in the file.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileCountUserData(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        out_number_items: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the size of user data in a file
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Parameter `outUserDataSize`: on output, if successful, the size of the user data chunk.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetUserDataSize(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
        out_user_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the 64-bit size of user data in a file
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Parameter `outUserDataSize`: on output, if successful, the size of the user data chunk.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetUserDataSize64(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
        out_user_data_size: NonNull<u64>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get the data of a chunk in a file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Parameter `ioUserDataSize`: the size of the buffer on input, size of bytes copied to buffer on output
    ///
    /// Parameter `outUserData`: a pointer to a buffer in which to copy the chunk data.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetUserData(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
        io_user_data_size: NonNull<u32>,
        out_user_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Get a part of the data of a chunk in a file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Parameter `inOffset`: offset from the first byte of the chunk to the first byte to get.
    ///
    /// Parameter `ioUserDataSize`: the size of the buffer on input, size of bytes copied to buffer on output
    ///
    /// Parameter `outUserData`: a pointer to a buffer in which to copy the chunk data.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetUserDataAtOffset(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
        in_offset: i64,
        io_user_data_size: NonNull<u32>,
        out_user_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set the data of a chunk in a file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Parameter `inUserDataSize`: on input the size of the data to copy, on output, size of bytes copied from the buffer
    ///
    /// Parameter `inUserData`: a pointer to a buffer from which to copy the chunk data
    /// (only the contents of the chunk, not including the chunk header).
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileSetUserData(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
        in_user_data_size: u32,
        in_user_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Remove a user chunk in a file.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inUserDataID`: the four char code of the chunk.
    ///
    /// Parameter `inIndex`: an index specifying which chunk if there are more than one.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileRemoveUserData(
        in_audio_file: AudioFileID,
        in_user_data_id: u32,
        in_index: u32,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyfileformat?language=objc)
pub const kAudioFilePropertyFileFormat: AudioFilePropertyID = 0x66666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertydataformat?language=objc)
pub const kAudioFilePropertyDataFormat: AudioFilePropertyID = 0x64666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyisoptimized?language=objc)
pub const kAudioFilePropertyIsOptimized: AudioFilePropertyID = 0x6f70746d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertymagiccookiedata?language=objc)
pub const kAudioFilePropertyMagicCookieData: AudioFilePropertyID = 0x6d676963;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyaudiodatabytecount?language=objc)
pub const kAudioFilePropertyAudioDataByteCount: AudioFilePropertyID = 0x62636e74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyaudiodatapacketcount?language=objc)
pub const kAudioFilePropertyAudioDataPacketCount: AudioFilePropertyID = 0x70636e74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertymaximumpacketsize?language=objc)
pub const kAudioFilePropertyMaximumPacketSize: AudioFilePropertyID = 0x70737a65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertydataoffset?language=objc)
pub const kAudioFilePropertyDataOffset: AudioFilePropertyID = 0x646f6666;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertychannellayout?language=objc)
pub const kAudioFilePropertyChannelLayout: AudioFilePropertyID = 0x636d6170;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertydefersizeupdates?language=objc)
pub const kAudioFilePropertyDeferSizeUpdates: AudioFilePropertyID = 0x64737a75;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertydataformatname?language=objc)
pub const kAudioFilePropertyDataFormatName: AudioFilePropertyID = 0x666e6d65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertymarkerlist?language=objc)
pub const kAudioFilePropertyMarkerList: AudioFilePropertyID = 0x6d6b6c73;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyregionlist?language=objc)
pub const kAudioFilePropertyRegionList: AudioFilePropertyID = 0x72676c73;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypackettoframe?language=objc)
pub const kAudioFilePropertyPacketToFrame: AudioFilePropertyID = 0x706b6672;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyframetopacket?language=objc)
pub const kAudioFilePropertyFrameToPacket: AudioFilePropertyID = 0x6672706b;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyrestrictsrandomaccess?language=objc)
pub const kAudioFilePropertyRestrictsRandomAccess: AudioFilePropertyID = 0x72726170;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypackettorolldistance?language=objc)
pub const kAudioFilePropertyPacketToRollDistance: AudioFilePropertyID = 0x706b726c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypreviousindependentpacket?language=objc)
pub const kAudioFilePropertyPreviousIndependentPacket: AudioFilePropertyID = 0x70696e64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertynextindependentpacket?language=objc)
pub const kAudioFilePropertyNextIndependentPacket: AudioFilePropertyID = 0x6e696e64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypackettodependencyinfo?language=objc)
pub const kAudioFilePropertyPacketToDependencyInfo: AudioFilePropertyID = 0x706b6470;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypackettobyte?language=objc)
pub const kAudioFilePropertyPacketToByte: AudioFilePropertyID = 0x706b6279;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertybytetopacket?language=objc)
pub const kAudioFilePropertyByteToPacket: AudioFilePropertyID = 0x6279706b;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertychunkids?language=objc)
pub const kAudioFilePropertyChunkIDs: AudioFilePropertyID = 0x63686964;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyinfodictionary?language=objc)
pub const kAudioFilePropertyInfoDictionary: AudioFilePropertyID = 0x696e666f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypackettableinfo?language=objc)
pub const kAudioFilePropertyPacketTableInfo: AudioFilePropertyID = 0x706e666f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyformatlist?language=objc)
pub const kAudioFilePropertyFormatList: AudioFilePropertyID = 0x666c7374;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypacketsizeupperbound?language=objc)
pub const kAudioFilePropertyPacketSizeUpperBound: AudioFilePropertyID = 0x706b7562;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertypacketrangebytecountupperbound?language=objc)
pub const kAudioFilePropertyPacketRangeByteCountUpperBound: AudioFilePropertyID = 0x70727562;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyreserveduration?language=objc)
pub const kAudioFilePropertyReserveDuration: AudioFilePropertyID = 0x72737276;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyestimatedduration?language=objc)
pub const kAudioFilePropertyEstimatedDuration: AudioFilePropertyID = 0x65647572;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertybitrate?language=objc)
pub const kAudioFilePropertyBitRate: AudioFilePropertyID = 0x62726174;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyid3tag?language=objc)
pub const kAudioFilePropertyID3Tag: AudioFilePropertyID = 0x69643374;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyid3tagoffset?language=objc)
pub const kAudioFilePropertyID3TagOffset: AudioFilePropertyID = 0x6964336f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertysourcebitdepth?language=objc)
pub const kAudioFilePropertySourceBitDepth: AudioFilePropertyID = 0x73627464;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyalbumartwork?language=objc)
pub const kAudioFilePropertyAlbumArtwork: AudioFilePropertyID = 0x61617274;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyaudiotrackcount?language=objc)
pub const kAudioFilePropertyAudioTrackCount: AudioFilePropertyID = 0x61746374;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilepropertyuseaudiotrack?language=objc)
pub const kAudioFilePropertyUseAudioTrack: AudioFilePropertyID = 0x7561746b;

extern "C-unwind" {
    /// Get information about the size of a property of an AudioFile  and whether it can be set.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inPropertyID`: an AudioFileProperty constant.
    ///
    /// Parameter `outDataSize`: the size in bytes of the current value of the property. In order to get the property value,
    /// you will need a buffer of this size.
    ///
    /// Parameter `isWritable`: will be set to 1 if writable, or 0 if read only.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetPropertyInfo(
        in_audio_file: AudioFileID,
        in_property_id: AudioFilePropertyID,
        out_data_size: *mut u32,
        is_writable: *mut u32,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Copies the value for a property of an AudioFile into a buffer.
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inPropertyID`: an AudioFileProperty constant.
    ///
    /// Parameter `ioDataSize`: on input the size of the outPropertyData buffer. On output the number of bytes written to the buffer.
    ///
    /// Parameter `outPropertyData`: the buffer in which to write the property data.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetProperty(
        in_audio_file: AudioFileID,
        in_property_id: AudioFilePropertyID,
        io_data_size: NonNull<u32>,
        out_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Sets the value for a property of an AudioFile .
    ///
    /// Parameter `inAudioFile`: an AudioFileID.
    ///
    /// Parameter `inPropertyID`: an AudioFileProperty constant.
    ///
    /// Parameter `inDataSize`: the size of the property data.
    ///
    /// Parameter `inPropertyData`: the buffer containing the property data.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileSetProperty(
        in_audio_file: AudioFileID,
        in_property_id: AudioFilePropertyID,
        in_data_size: u32,
        in_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_readabletypes?language=objc)
pub const kAudioFileGlobalInfo_ReadableTypes: AudioFilePropertyID = 0x61667266;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_writabletypes?language=objc)
pub const kAudioFileGlobalInfo_WritableTypes: AudioFilePropertyID = 0x61667766;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_filetypename?language=objc)
pub const kAudioFileGlobalInfo_FileTypeName: AudioFilePropertyID = 0x66746e6d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_availablestreamdescriptionsforformat?language=objc)
pub const kAudioFileGlobalInfo_AvailableStreamDescriptionsForFormat: AudioFilePropertyID =
    0x73646964;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_availableformatids?language=objc)
pub const kAudioFileGlobalInfo_AvailableFormatIDs: AudioFilePropertyID = 0x666d6964;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_allextensions?language=objc)
pub const kAudioFileGlobalInfo_AllExtensions: AudioFilePropertyID = 0x616c7874;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_allhfstypecodes?language=objc)
pub const kAudioFileGlobalInfo_AllHFSTypeCodes: AudioFilePropertyID = 0x61686673;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_allutis?language=objc)
pub const kAudioFileGlobalInfo_AllUTIs: AudioFilePropertyID = 0x61757469;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_allmimetypes?language=objc)
pub const kAudioFileGlobalInfo_AllMIMETypes: AudioFilePropertyID = 0x616d696d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_extensionsfortype?language=objc)
pub const kAudioFileGlobalInfo_ExtensionsForType: AudioFilePropertyID = 0x66657874;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_hfstypecodesfortype?language=objc)
pub const kAudioFileGlobalInfo_HFSTypeCodesForType: AudioFilePropertyID = 0x66686673;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_utisfortype?language=objc)
pub const kAudioFileGlobalInfo_UTIsForType: AudioFilePropertyID = 0x66757469;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_mimetypesfortype?language=objc)
pub const kAudioFileGlobalInfo_MIMETypesForType: AudioFilePropertyID = 0x666d696d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_typesformimetype?language=objc)
pub const kAudioFileGlobalInfo_TypesForMIMEType: AudioFilePropertyID = 0x746d696d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_typesforuti?language=objc)
pub const kAudioFileGlobalInfo_TypesForUTI: AudioFilePropertyID = 0x74757469;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_typesforhfstypecode?language=objc)
pub const kAudioFileGlobalInfo_TypesForHFSTypeCode: AudioFilePropertyID = 0x74686673;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofileglobalinfo_typesforextension?language=objc)
pub const kAudioFileGlobalInfo_TypesForExtension: AudioFilePropertyID = 0x74657874;

/// This is used as a specifier for kAudioFileGlobalInfo_AvailableStreamDescriptions
///
/// This struct is used to specify a desired audio file type and data format ID  so
/// that a list of stream descriptions of available formats can be obtained.
///
/// a four char code for the file type such as kAudioFileAIFFType, kAudioFileCAFType, etc.
///
/// a four char code for the format ID such as kAudioFormatLinearPCM, kAudioFormatMPEG4AAC, etc.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofiletypeandformatid?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct AudioFileTypeAndFormatID {
    pub mFileType: AudioFileTypeID,
    pub mFormatID: u32,
}

unsafe impl Encode for AudioFileTypeAndFormatID {
    const ENCODING: Encoding = Encoding::Struct(
        "AudioFileTypeAndFormatID",
        &[<AudioFileTypeID>::ENCODING, <u32>::ENCODING],
    );
}

unsafe impl RefEncode for AudioFileTypeAndFormatID {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    /// Get the size of a global property.
    ///
    /// Parameter `inPropertyID`: an AudioFileGlobalInfo property constant.
    ///
    /// Parameter `inSpecifierSize`: The size of the specifier data.
    ///
    /// Parameter `inSpecifier`: A specifier is a buffer of data used as an input argument to some of the global info properties.
    ///
    /// Parameter `outDataSize`: the size in bytes of the current value of the property. In order to get the property value,
    /// you will need a buffer of this size.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetGlobalInfoSize(
        in_property_id: AudioFilePropertyID,
        in_specifier_size: u32,
        in_specifier: *mut c_void,
        out_data_size: NonNull<u32>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Copies the value for a global property into a buffer.
    ///
    /// Parameter `inPropertyID`: an AudioFileGlobalInfo property constant.
    ///
    /// Parameter `inSpecifierSize`: The size of the specifier data.
    ///
    /// Parameter `inSpecifier`: A specifier is a buffer of data used as an input argument to some of the global info properties.
    ///
    /// Parameter `ioDataSize`: on input the size of the outPropertyData buffer. On output the number of bytes written to the buffer.
    ///
    /// Parameter `outPropertyData`: the buffer in which to write the property data.
    ///
    /// Returns: returns noErr if successful.
    pub fn AudioFileGetGlobalInfo(
        in_property_id: AudioFilePropertyID,
        in_specifier_size: u32,
        in_specifier: *mut c_void,
        io_data_size: NonNull<u32>,
        out_property_data: NonNull<c_void>,
    ) -> OSStatus;
}
