/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __RBC_BUFFER_H__
#define __RBC_BUFFER_H__


#include <glib.h>


typedef enum
{
  RBC_BUFFER_EMPTY,
  RBC_BUFFER_SIMPLE,
  RBC_BUFFER_PAGE_TABLE
} RBCBufferType;


typedef struct _RBCBuffer RBCBuffer;
typedef struct _RBCPage   RBCPage;

struct _RBCBuffer
{
  RBCBufferType type;

  gpointer      data;
  gsize         length;
};

/* This needs to match struct iovec for readv/writev */
struct _RBCPage
{
  gpointer data;
  gsize    length;
};


RBCBuffer *rbc_buffer_empty_new      (void);

RBCBuffer *rbc_buffer_simple_new     (gsize      length);

RBCBuffer *rbc_buffer_page_table_new (gsize      length);

void       rbc_buffer_destroy        (RBCBuffer *buffer);

void       rbc_buffer_fill_from_page (RBCBuffer *buffer,
                                      RBCPage   *page);


#endif /* __RBC_BUFFER_H__ */
