/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __APP_H__
#define __APP_H__


#include <glib.h>


typedef struct _EndpointApp EndpointApp;

struct _EndpointApp
{
  GMainContext *context;
  GMainLoop    *loop;

  gchar        *ps_name;
  gint          ps_len;

  gint          max_logins;
  gint          max_logins_per_port;
  gboolean      honor_exclusive;

  GHashTable   *disks;

  gpointer      cleanup;
  gpointer      wire_funcs;

  gpointer      user_data;
};


EndpointApp  *endpoint_app_new     (const gchar *configfile);

void          endpoint_app_destroy (EndpointApp *app);


#endif /* __APP_H__ */
