// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/appengine/v1/appengine.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_APPLICATIONS_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_APPLICATIONS_CONNECTION_IMPL_H

#include "google/cloud/appengine/v1/applications_connection.h"
#include "google/cloud/appengine/v1/applications_connection_idempotency_policy.h"
#include "google/cloud/appengine/v1/applications_options.h"
#include "google/cloud/appengine/v1/internal/applications_retry_traits.h"
#include "google/cloud/appengine/v1/internal/applications_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace appengine_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ApplicationsConnectionImpl : public appengine_v1::ApplicationsConnection {
 public:
  ~ApplicationsConnectionImpl() override = default;

  ApplicationsConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<appengine_v1_internal::ApplicationsStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::appengine::v1::Application> GetApplication(
      google::appengine::v1::GetApplicationRequest const& request) override;

  future<StatusOr<google::appengine::v1::Application>> CreateApplication(
      google::appengine::v1::CreateApplicationRequest const& request) override;

  StatusOr<google::longrunning::Operation> CreateApplication(
      NoAwaitTag,
      google::appengine::v1::CreateApplicationRequest const& request) override;

  future<StatusOr<google::appengine::v1::Application>> CreateApplication(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::appengine::v1::Application>> UpdateApplication(
      google::appengine::v1::UpdateApplicationRequest const& request) override;

  StatusOr<google::longrunning::Operation> UpdateApplication(
      NoAwaitTag,
      google::appengine::v1::UpdateApplicationRequest const& request) override;

  future<StatusOr<google::appengine::v1::Application>> UpdateApplication(
      google::longrunning::Operation const& operation) override;

  future<StatusOr<google::appengine::v1::Application>> RepairApplication(
      google::appengine::v1::RepairApplicationRequest const& request) override;

  StatusOr<google::longrunning::Operation> RepairApplication(
      NoAwaitTag,
      google::appengine::v1::RepairApplicationRequest const& request) override;

  future<StatusOr<google::appengine::v1::Application>> RepairApplication(
      google::longrunning::Operation const& operation) override;

 private:
  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<appengine_v1_internal::ApplicationsStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace appengine_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_APPENGINE_V1_INTERNAL_APPLICATIONS_CONNECTION_IMPL_H
