// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_FUTURE_RESERVATIONS_V1_FUTURE_RESERVATIONS_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_FUTURE_RESERVATIONS_V1_FUTURE_RESERVATIONS_CLIENT_H

#include "google/cloud/compute/future_reservations/v1/future_reservations_rest_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// Service for the futureReservations resource.
/// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class FutureReservationsClient {
 public:
  explicit FutureReservationsClient(
      std::shared_ptr<FutureReservationsConnection> connection,
      Options opts = {});
  ~FutureReservationsClient();

  ///@{
  /// @name Copy and move support
  FutureReservationsClient(FutureReservationsClient const&) = default;
  FutureReservationsClient& operator=(FutureReservationsClient const&) =
      default;
  FutureReservationsClient(FutureReservationsClient&&) = default;
  FutureReservationsClient& operator=(FutureReservationsClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(FutureReservationsClient const& a,
                         FutureReservationsClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(FutureReservationsClient const& a,
                         FutureReservationsClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Retrieves an aggregated list of future reservations. To prevent failure,
  /// Google recommends that you set the `returnPartialSuccess` parameter to
  /// `true`.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/aggregatedList
  ///
  /// @param project  Project ID for this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cpp.compute.v1.FutureReservationsScopedList], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.AggregatedListFutureReservationsRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L124}
  /// [google.cloud.cpp.compute.v1.FutureReservationsScopedList]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L523}
  ///
  // clang-format on
  StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
  AggregatedListFutureReservations(std::string const& project,
                                   Options opts = {});

  // clang-format off
  ///
  /// Retrieves an aggregated list of future reservations. To prevent failure,
  /// Google recommends that you set the `returnPartialSuccess` parameter to
  /// `true`.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/aggregatedList
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.AggregatedListFutureReservationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cpp.compute.v1.FutureReservationsScopedList], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.AggregatedListFutureReservationsRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L124}
  /// [google.cloud.cpp.compute.v1.FutureReservationsScopedList]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L523}
  ///
  // clang-format on
  StreamRange<
      std::pair<std::string,
                google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
  AggregatedListFutureReservations(
      google::cloud::cpp::compute::future_reservations::v1::
          AggregatedListFutureReservationsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Cancel the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/cancel
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param future_reservation  Name of the future reservation to retrieve. Name should conform to RFC1035.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.CancelRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Cancel(
      std::string const& project, std::string const& zone,
      std::string const& future_reservation, Options opts = {});

  // clang-format off
  ///
  /// @copybrief Cancel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> Cancel(
      NoAwaitTag, std::string const& project, std::string const& zone,
      std::string const& future_reservation, Options opts = {});

  // clang-format off
  ///
  /// Cancel the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/cancel
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.CancelRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.CancelRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L206}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Cancel(
      google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief Cancel
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> Cancel(
      NoAwaitTag,
      google::cloud::cpp::compute::future_reservations::v1::CancelRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief Cancel
  ///
  /// This method accepts a `google::cloud::cpp::compute::v1::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> Cancel(
      google::cloud::cpp::compute::v1::Operation const& operation,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/delete
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param future_reservation  Name of the future reservation to retrieve. Name should conform to RFC1035.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.DeleteFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L239}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteFutureReservation(std::string const& project, std::string const& zone,
                          std::string const& future_reservation,
                          Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteFutureReservation(
      NoAwaitTag, std::string const& project, std::string const& zone,
      std::string const& future_reservation, Options opts = {});

  // clang-format off
  ///
  /// Deletes the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/delete
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.DeleteFutureReservationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.DeleteFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L239}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteFutureReservation(google::cloud::cpp::compute::future_reservations::v1::
                              DeleteFutureReservationRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteFutureReservation(
      NoAwaitTag,
      google::cloud::cpp::compute::future_reservations::v1::
          DeleteFutureReservationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteFutureReservation
  ///
  /// This method accepts a `google::cloud::cpp::compute::v1::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteFutureReservation(
      google::cloud::cpp::compute::v1::Operation const& operation,
      Options opts = {});

  // clang-format off
  ///
  /// Retrieves information about the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/get
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param future_reservation  Name of the future reservation to retrieve. Name should conform to RFC1035.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cpp.compute.v1.FutureReservation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.GetFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L272}
  /// [google.cloud.cpp.compute.v1.FutureReservation]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
  GetFutureReservation(std::string const& project, std::string const& zone,
                       std::string const& future_reservation,
                       Options opts = {});

  // clang-format off
  ///
  /// Retrieves information about the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/get
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.GetFutureReservationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.cpp.compute.v1.FutureReservation])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.GetFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L272}
  /// [google.cloud.cpp.compute.v1.FutureReservation]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L28}
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
  GetFutureReservation(google::cloud::cpp::compute::future_reservations::v1::
                           GetFutureReservationRequest const& request,
                       Options opts = {});

  // clang-format off
  ///
  /// Creates a new Future Reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/insert
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param future_reservation_resource  The FutureReservation for this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.InsertFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L286}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertFutureReservation(
      std::string const& project, std::string const& zone,
      google::cloud::cpp::compute::v1::FutureReservation const&
          future_reservation_resource,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief InsertFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertFutureReservation(
      NoAwaitTag, std::string const& project, std::string const& zone,
      google::cloud::cpp::compute::v1::FutureReservation const&
          future_reservation_resource,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a new Future Reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/insert
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.InsertFutureReservationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.InsertFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L286}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertFutureReservation(google::cloud::cpp::compute::future_reservations::v1::
                              InsertFutureReservationRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// @copybrief InsertFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertFutureReservation(
      NoAwaitTag,
      google::cloud::cpp::compute::future_reservations::v1::
          InsertFutureReservationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief InsertFutureReservation
  ///
  /// This method accepts a `google::cloud::cpp::compute::v1::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertFutureReservation(
      google::cloud::cpp::compute::v1::Operation const& operation,
      Options opts = {});

  // clang-format off
  ///
  /// A list of all the future reservations that have been configured for the
  /// specified project in specified zone.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/list
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cpp.compute.v1.FutureReservation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.ListFutureReservationsRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L319}
  /// [google.cloud.cpp.compute.v1.FutureReservation]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
  ListFutureReservations(std::string const& project, std::string const& zone,
                         Options opts = {});

  // clang-format off
  ///
  /// A list of all the future reservations that have been configured for the
  /// specified project in specified zone.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/list
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.ListFutureReservationsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.cpp.compute.v1.FutureReservation], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.ListFutureReservationsRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L319}
  /// [google.cloud.cpp.compute.v1.FutureReservation]: @cloud_cpp_reference_link{google/cloud/compute/v1/internal/common_043.proto#L28}
  ///
  // clang-format on
  StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
  ListFutureReservations(google::cloud::cpp::compute::future_reservations::v1::
                             ListFutureReservationsRequest request,
                         Options opts = {});

  // clang-format off
  ///
  /// Updates the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/update
  ///
  /// @param project  Project ID for this request.
  /// @param zone  Name of the zone for this request. Name should conform to RFC1035.
  /// @param future_reservation  Name of the reservation to update. Name should conform to RFC1035.
  /// @param update_mask  update_mask indicates fields to be updated as part of this request.
  /// @param future_reservation_resource  The FutureReservation for this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.UpdateFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L390}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateFutureReservation(
      std::string const& project, std::string const& zone,
      std::string const& future_reservation, std::string const& update_mask,
      google::cloud::cpp::compute::v1::FutureReservation const&
          future_reservation_resource,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> UpdateFutureReservation(
      NoAwaitTag, std::string const& project, std::string const& zone,
      std::string const& future_reservation, std::string const& update_mask,
      google::cloud::cpp::compute::v1::FutureReservation const&
          future_reservation_resource,
      Options opts = {});

  // clang-format off
  ///
  /// Updates the specified future reservation.
  /// https://cloud.google.com/compute/docs/reference/rest/v1/futureReservations/update
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.cpp.compute.future_reservations.v1.UpdateFutureReservationRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.cpp.compute.v1.Operation] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: http://cloud/compute/docs/api/how-tos/api-requests-responses#handling_api_responses
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.cpp.compute.future_reservations.v1.UpdateFutureReservationRequest]: @cloud_cpp_reference_link{google/cloud/compute/future_reservations/v1/future_reservations.proto#L390}
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateFutureReservation(google::cloud::cpp::compute::future_reservations::v1::
                              UpdateFutureReservationRequest const& request,
                          Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFutureReservation
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::cloud::cpp::compute::v1::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::cloud::cpp::compute::v1::Operation> UpdateFutureReservation(
      NoAwaitTag,
      google::cloud::cpp::compute::future_reservations::v1::
          UpdateFutureReservationRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateFutureReservation
  ///
  /// This method accepts a `google::cloud::cpp::compute::v1::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  UpdateFutureReservation(
      google::cloud::cpp::compute::v1::Operation const& operation,
      Options opts = {});

 private:
  std::shared_ptr<FutureReservationsConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_FUTURE_RESERVATIONS_V1_FUTURE_RESERVATIONS_CLIENT_H
