// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/datacatalog/v1/datacatalog.proto

#include "google/cloud/datacatalog/v1/data_catalog_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace datacatalog_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

DataCatalogConnectionIdempotencyPolicy::
    ~DataCatalogConnectionIdempotencyPolicy() = default;

std::unique_ptr<DataCatalogConnectionIdempotencyPolicy>
DataCatalogConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<DataCatalogConnectionIdempotencyPolicy>(*this);
}

Idempotency DataCatalogConnectionIdempotencyPolicy::SearchCatalog(
    google::cloud::datacatalog::v1::SearchCatalogRequest) {  // NOLINT
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::CreateEntryGroup(
    google::cloud::datacatalog::v1::CreateEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::GetEntryGroup(
    google::cloud::datacatalog::v1::GetEntryGroupRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UpdateEntryGroup(
    google::cloud::datacatalog::v1::UpdateEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::DeleteEntryGroup(
    google::cloud::datacatalog::v1::DeleteEntryGroupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ListEntryGroups(
    google::cloud::datacatalog::v1::ListEntryGroupsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::CreateEntry(
    google::cloud::datacatalog::v1::CreateEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UpdateEntry(
    google::cloud::datacatalog::v1::UpdateEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::DeleteEntry(
    google::cloud::datacatalog::v1::DeleteEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::GetEntry(
    google::cloud::datacatalog::v1::GetEntryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::LookupEntry(
    google::cloud::datacatalog::v1::LookupEntryRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ListEntries(
    google::cloud::datacatalog::v1::ListEntriesRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ModifyEntryOverview(
    google::cloud::datacatalog::v1::ModifyEntryOverviewRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ModifyEntryContacts(
    google::cloud::datacatalog::v1::ModifyEntryContactsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::CreateTagTemplate(
    google::cloud::datacatalog::v1::CreateTagTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::GetTagTemplate(
    google::cloud::datacatalog::v1::GetTagTemplateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UpdateTagTemplate(
    google::cloud::datacatalog::v1::UpdateTagTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::DeleteTagTemplate(
    google::cloud::datacatalog::v1::DeleteTagTemplateRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::CreateTagTemplateField(
    google::cloud::datacatalog::v1::CreateTagTemplateFieldRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UpdateTagTemplateField(
    google::cloud::datacatalog::v1::UpdateTagTemplateFieldRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::RenameTagTemplateField(
    google::cloud::datacatalog::v1::RenameTagTemplateFieldRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
DataCatalogConnectionIdempotencyPolicy::RenameTagTemplateFieldEnumValue(
    google::cloud::datacatalog::v1::
        RenameTagTemplateFieldEnumValueRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::DeleteTagTemplateField(
    google::cloud::datacatalog::v1::DeleteTagTemplateFieldRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::CreateTag(
    google::cloud::datacatalog::v1::CreateTagRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UpdateTag(
    google::cloud::datacatalog::v1::UpdateTagRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::DeleteTag(
    google::cloud::datacatalog::v1::DeleteTagRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ListTags(
    google::cloud::datacatalog::v1::ListTagsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ReconcileTags(
    google::cloud::datacatalog::v1::ReconcileTagsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::StarEntry(
    google::cloud::datacatalog::v1::StarEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::UnstarEntry(
    google::cloud::datacatalog::v1::UnstarEntryRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request) {
  return request.policy().etag().empty() ? Idempotency::kNonIdempotent
                                         : Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency DataCatalogConnectionIdempotencyPolicy::ImportEntries(
    google::cloud::datacatalog::v1::ImportEntriesRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<DataCatalogConnectionIdempotencyPolicy>
MakeDefaultDataCatalogConnectionIdempotencyPolicy() {
  return std::make_unique<DataCatalogConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datacatalog_v1
}  // namespace cloud
}  // namespace google
