// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataproc/v1/batches.proto

#include "google/cloud/dataproc/v1/batch_controller_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace dataproc_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

BatchControllerClient::BatchControllerClient(
    std::shared_ptr<BatchControllerConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
BatchControllerClient::~BatchControllerClient() = default;

future<StatusOr<google::cloud::dataproc::v1::Batch>>
BatchControllerClient::CreateBatch(
    std::string const& parent, google::cloud::dataproc::v1::Batch const& batch,
    std::string const& batch_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateBatchRequest request;
  request.set_parent(parent);
  *request.mutable_batch() = batch;
  request.set_batch_id(batch_id);
  return connection_->CreateBatch(request);
}

StatusOr<google::longrunning::Operation> BatchControllerClient::CreateBatch(
    NoAwaitTag, std::string const& parent,
    google::cloud::dataproc::v1::Batch const& batch,
    std::string const& batch_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::CreateBatchRequest request;
  request.set_parent(parent);
  *request.mutable_batch() = batch;
  request.set_batch_id(batch_id);
  return connection_->CreateBatch(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Batch>>
BatchControllerClient::CreateBatch(
    google::cloud::dataproc::v1::CreateBatchRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBatch(request);
}

StatusOr<google::longrunning::Operation> BatchControllerClient::CreateBatch(
    NoAwaitTag, google::cloud::dataproc::v1::CreateBatchRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBatch(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::dataproc::v1::Batch>>
BatchControllerClient::CreateBatch(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateBatch(operation);
}

StatusOr<google::cloud::dataproc::v1::Batch> BatchControllerClient::GetBatch(
    std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::GetBatchRequest request;
  request.set_name(name);
  return connection_->GetBatch(request);
}

StatusOr<google::cloud::dataproc::v1::Batch> BatchControllerClient::GetBatch(
    google::cloud::dataproc::v1::GetBatchRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBatch(request);
}

StreamRange<google::cloud::dataproc::v1::Batch>
BatchControllerClient::ListBatches(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::ListBatchesRequest request;
  request.set_parent(parent);
  return connection_->ListBatches(request);
}

StreamRange<google::cloud::dataproc::v1::Batch>
BatchControllerClient::ListBatches(
    google::cloud::dataproc::v1::ListBatchesRequest request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListBatches(std::move(request));
}

Status BatchControllerClient::DeleteBatch(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::dataproc::v1::DeleteBatchRequest request;
  request.set_name(name);
  return connection_->DeleteBatch(request);
}

Status BatchControllerClient::DeleteBatch(
    google::cloud::dataproc::v1::DeleteBatchRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBatch(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataproc_v1
}  // namespace cloud
}  // namespace google
