// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/discoveryengine/v1/control_service.proto

#include "google/cloud/discoveryengine/v1/control_connection.h"
#include "google/cloud/discoveryengine/v1/control_options.h"
#include "google/cloud/discoveryengine/v1/internal/control_connection_impl.h"
#include "google/cloud/discoveryengine/v1/internal/control_option_defaults.h"
#include "google/cloud/discoveryengine/v1/internal/control_stub_factory.h"
#include "google/cloud/discoveryengine/v1/internal/control_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace discoveryengine_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ControlServiceConnection::~ControlServiceConnection() = default;

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceConnection::CreateControl(
    google::cloud::discoveryengine::v1::CreateControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status ControlServiceConnection::DeleteControl(
    google::cloud::discoveryengine::v1::DeleteControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceConnection::UpdateControl(
    google::cloud::discoveryengine::v1::UpdateControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::discoveryengine::v1::Control>
ControlServiceConnection::GetControl(
    google::cloud::discoveryengine::v1::GetControlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::discoveryengine::v1::Control>
ControlServiceConnection::ListControls(
    google::cloud::discoveryengine::v1::
        ListControlsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::discoveryengine::v1::Control>>();
}

std::shared_ptr<ControlServiceConnection> MakeControlServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 ControlServicePolicyOptionList>(options,
                                                                 __func__);
  options = discoveryengine_v1_internal::ControlServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = discoveryengine_v1_internal::CreateDefaultControlServiceStub(
      std::move(auth), options);
  return discoveryengine_v1_internal::MakeControlServiceTracingConnection(
      std::make_shared<
          discoveryengine_v1_internal::ControlServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace discoveryengine_v1
}  // namespace cloud
}  // namespace google
