// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

#include "google/cloud/filestore/v1/internal/cloud_filestore_manager_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/filestore/v1/cloud_filestore_service.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace filestore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFilestoreManagerStub::~CloudFilestoreManagerStub() = default;

StatusOr<google::cloud::filestore::v1::ListInstancesResponse>
DefaultCloudFilestoreManagerStub::ListInstances(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::ListInstancesRequest const& request) {
  google::cloud::filestore::v1::ListInstancesResponse response;
  auto status = grpc_stub_->ListInstances(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::filestore::v1::Instance>
DefaultCloudFilestoreManagerStub::GetInstance(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::GetInstanceRequest const& request) {
  google::cloud::filestore::v1::Instance response;
  auto status = grpc_stub_->GetInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncCreateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::CreateInstanceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::CreateInstanceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateInstance(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::CreateInstance(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::CreateInstanceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncUpdateInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::UpdateInstanceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::UpdateInstanceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateInstance(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::UpdateInstance(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::UpdateInstanceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncRestoreInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::RestoreInstanceRequest,
      google::longrunning::Operation>(
      cq,
      [this](
          grpc::ClientContext* context,
          google::cloud::filestore::v1::RestoreInstanceRequest const& request,
          grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRestoreInstance(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::RestoreInstance(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::RestoreInstanceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->RestoreInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncRevertInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::RevertInstanceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::RevertInstanceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRevertInstance(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::RevertInstance(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::RevertInstanceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->RevertInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncDeleteInstance(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::DeleteInstanceRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::DeleteInstanceRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteInstance(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::DeleteInstance(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::DeleteInstanceRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteInstance(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::filestore::v1::ListSnapshotsResponse>
DefaultCloudFilestoreManagerStub::ListSnapshots(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::ListSnapshotsRequest const& request) {
  google::cloud::filestore::v1::ListSnapshotsResponse response;
  auto status = grpc_stub_->ListSnapshots(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::filestore::v1::Snapshot>
DefaultCloudFilestoreManagerStub::GetSnapshot(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::GetSnapshotRequest const& request) {
  google::cloud::filestore::v1::Snapshot response;
  auto status = grpc_stub_->GetSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncCreateSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::CreateSnapshotRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::CreateSnapshotRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateSnapshot(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::CreateSnapshot(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::CreateSnapshotRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncDeleteSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::DeleteSnapshotRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::DeleteSnapshotRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteSnapshot(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::DeleteSnapshot(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::DeleteSnapshotRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncUpdateSnapshot(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::UpdateSnapshotRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::UpdateSnapshotRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateSnapshot(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::UpdateSnapshot(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::UpdateSnapshotRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateSnapshot(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::filestore::v1::ListBackupsResponse>
DefaultCloudFilestoreManagerStub::ListBackups(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::ListBackupsRequest const& request) {
  google::cloud::filestore::v1::ListBackupsResponse response;
  auto status = grpc_stub_->ListBackups(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::filestore::v1::Backup>
DefaultCloudFilestoreManagerStub::GetBackup(
    grpc::ClientContext& context, Options const&,
    google::cloud::filestore::v1::GetBackupRequest const& request) {
  google::cloud::filestore::v1::Backup response;
  auto status = grpc_stub_->GetBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncCreateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::CreateBackupRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::CreateBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::CreateBackup(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::CreateBackupRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->CreateBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncDeleteBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::DeleteBackupRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::DeleteBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::DeleteBackup(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::DeleteBackupRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->DeleteBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncUpdateBackup(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::filestore::v1::UpdateBackupRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::filestore::v1::UpdateBackupRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateBackup(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultCloudFilestoreManagerStub::UpdateBackup(
    grpc::ClientContext& context, Options,
    google::cloud::filestore::v1::UpdateBackupRequest const& request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->UpdateBackup(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultCloudFilestoreManagerStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultCloudFilestoreManagerStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace filestore_v1_internal
}  // namespace cloud
}  // namespace google
