// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/metastore/v1/metastore_federation.proto

#include "google/cloud/metastore/v1/internal/dataproc_metastore_federation_connection_impl.h"
#include "google/cloud/metastore/v1/internal/dataproc_metastore_federation_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace metastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<metastore_v1::DataprocMetastoreFederationRetryPolicy>
retry_policy(Options const& options) {
  return options
      .get<metastore_v1::DataprocMetastoreFederationRetryPolicyOption>()
      ->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options
      .get<metastore_v1::DataprocMetastoreFederationBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<
    metastore_v1::DataprocMetastoreFederationConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<metastore_v1::
               DataprocMetastoreFederationConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options
      .get<metastore_v1::DataprocMetastoreFederationPollingPolicyOption>()
      ->clone();
}

}  // namespace

DataprocMetastoreFederationConnectionImpl::
    DataprocMetastoreFederationConnectionImpl(
        std::unique_ptr<google::cloud::BackgroundThreads> background,
        std::shared_ptr<metastore_v1_internal::DataprocMetastoreFederationStub>
            stub,
        Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(
          std::move(options),
          DataprocMetastoreFederationConnection::options())) {}

StreamRange<google::cloud::metastore::v1::Federation>
DataprocMetastoreFederationConnectionImpl::ListFederations(
    google::cloud::metastore::v1::ListFederationsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListFederations(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::metastore::v1::Federation>>(
      current, std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<
           metastore_v1::DataprocMetastoreFederationRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          Options const& options,
          google::cloud::metastore::v1::ListFederationsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context, Options const& options,
                   google::cloud::metastore::v1::ListFederationsRequest const&
                       request) {
              return stub->ListFederations(context, options, request);
            },
            options, r, function_name);
      },
      [](google::cloud::metastore::v1::ListFederationsResponse r) {
        std::vector<google::cloud::metastore::v1::Federation> result(
            r.federations().size());
        auto& messages = *r.mutable_federations();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::metastore::v1::Federation>
DataprocMetastoreFederationConnectionImpl::GetFederation(
    google::cloud::metastore::v1::GetFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetFederation(request),
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::metastore::v1::GetFederationRequest const& request) {
        return stub_->GetFederation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::metastore::v1::Federation>>
DataprocMetastoreFederationConnectionImpl::CreateFederation(
    google::cloud::metastore::v1::CreateFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->CreateFederation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::metastore::v1::Federation>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::metastore::v1::CreateFederationRequest const&
              request) {
        return stub->AsyncCreateFederation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::metastore::v1::Federation>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreFederationConnectionImpl::CreateFederation(
    NoAwaitTag,
    google::cloud::metastore::v1::CreateFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateFederation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::metastore::v1::CreateFederationRequest const&
                 request) {
        return stub_->CreateFederation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::metastore::v1::Federation>>
DataprocMetastoreFederationConnectionImpl::CreateFederation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::metastore::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::metastore::v1::Federation>>(
        internal::InvalidArgumentError(
            "operation does not correspond to CreateFederation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::metastore::v1::Federation>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::metastore::v1::Federation>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::metastore::v1::Federation>>
DataprocMetastoreFederationConnectionImpl::UpdateFederation(
    google::cloud::metastore::v1::UpdateFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->UpdateFederation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::metastore::v1::Federation>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::metastore::v1::UpdateFederationRequest const&
              request) {
        return stub->AsyncUpdateFederation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::metastore::v1::Federation>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreFederationConnectionImpl::UpdateFederation(
    NoAwaitTag,
    google::cloud::metastore::v1::UpdateFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateFederation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::metastore::v1::UpdateFederationRequest const&
                 request) {
        return stub_->UpdateFederation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::metastore::v1::Federation>>
DataprocMetastoreFederationConnectionImpl::UpdateFederation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::metastore::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::metastore::v1::Federation>>(
        internal::InvalidArgumentError(
            "operation does not correspond to UpdateFederation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::metastore::v1::Federation>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::metastore::v1::Federation>,
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreFederationConnectionImpl::DeleteFederation(
    google::cloud::metastore::v1::DeleteFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto request_copy = request;
  auto const idempotent =
      idempotency_policy(*current)->DeleteFederation(request_copy);
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::metastore::v1::OperationMetadata>(
      background_->cq(), current, std::move(request_copy),
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::cloud::metastore::v1::DeleteFederationRequest const&
              request) {
        return stub->AsyncDeleteFederation(cq, std::move(context),
                                           std::move(options), request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::metastore::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current), idempotent,
      polling_policy(*current), __func__);
}

StatusOr<google::longrunning::Operation>
DataprocMetastoreFederationConnectionImpl::DeleteFederation(
    NoAwaitTag,
    google::cloud::metastore::v1::DeleteFederationRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteFederation(request),
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::metastore::v1::DeleteFederationRequest const&
                 request) {
        return stub_->DeleteFederation(context, options, request);
      },
      *current, request, __func__);
}

future<StatusOr<google::cloud::metastore::v1::OperationMetadata>>
DataprocMetastoreFederationConnectionImpl::DeleteFederation(
    google::longrunning::Operation const& operation) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  if (!operation.metadata()
           .Is<typename google::cloud::metastore::v1::OperationMetadata>()) {
    return make_ready_future<
        StatusOr<google::cloud::metastore::v1::OperationMetadata>>(
        internal::InvalidArgumentError(
            "operation does not correspond to DeleteFederation",
            GCP_ERROR_INFO().WithMetadata("operation",
                                          operation.metadata().DebugString())));
  }

  return google::cloud::internal::AsyncAwaitLongRunningOperation<
      google::cloud::metastore::v1::OperationMetadata>(
      background_->cq(), current, operation,
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     google::cloud::internal::ImmutableOptions options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context),
                                       std::move(options), request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context,
          google::cloud::internal::ImmutableOptions options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context),
                                          std::move(options), request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::metastore::v1::OperationMetadata>,
      polling_policy(*current), __func__);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace metastore_v1_internal
}  // namespace cloud
}  // namespace google
