// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/resourcemanager/v3/tag_values.proto

#include "google/cloud/resourcemanager/v3/tag_values_client.h"
#include "google/cloud/resourcemanager/v3/tag_values_options.h"
#include <memory>
#include <thread>
#include <utility>

namespace google {
namespace cloud {
namespace resourcemanager_v3 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

TagValuesClient::TagValuesClient(
    std::shared_ptr<TagValuesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
TagValuesClient::~TagValuesClient() = default;

StreamRange<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::ListTagValues(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::ListTagValuesRequest request;
  request.set_parent(parent);
  return connection_->ListTagValues(request);
}

StreamRange<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::ListTagValues(
    google::cloud::resourcemanager::v3::ListTagValuesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListTagValues(std::move(request));
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::GetTagValue(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::GetTagValueRequest request;
  request.set_name(name);
  return connection_->GetTagValue(request);
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::GetTagValue(
    google::cloud::resourcemanager::v3::GetTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetTagValue(request);
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::GetNamespacedTagValue(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest request;
  request.set_name(name);
  return connection_->GetNamespacedTagValue(request);
}

StatusOr<google::cloud::resourcemanager::v3::TagValue>
TagValuesClient::GetNamespacedTagValue(
    google::cloud::resourcemanager::v3::GetNamespacedTagValueRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetNamespacedTagValue(request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::CreateTagValue(
    google::cloud::resourcemanager::v3::TagValue const& tag_value,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::CreateTagValueRequest request;
  *request.mutable_tag_value() = tag_value;
  return connection_->CreateTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::CreateTagValue(
    NoAwaitTag, google::cloud::resourcemanager::v3::TagValue const& tag_value,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::CreateTagValueRequest request;
  *request.mutable_tag_value() = tag_value;
  return connection_->CreateTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::CreateTagValue(
    google::cloud::resourcemanager::v3::CreateTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::CreateTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::CreateTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::CreateTagValue(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateTagValue(operation);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::UpdateTagValue(
    google::cloud::resourcemanager::v3::TagValue const& tag_value,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::UpdateTagValueRequest request;
  *request.mutable_tag_value() = tag_value;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::UpdateTagValue(
    NoAwaitTag, google::cloud::resourcemanager::v3::TagValue const& tag_value,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::UpdateTagValueRequest request;
  *request.mutable_tag_value() = tag_value;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::UpdateTagValue(
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::UpdateTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::UpdateTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::UpdateTagValue(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateTagValue(operation);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::DeleteTagValue(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::DeleteTagValueRequest request;
  request.set_name(name);
  return connection_->DeleteTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::DeleteTagValue(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::resourcemanager::v3::DeleteTagValueRequest request;
  request.set_name(name);
  return connection_->DeleteTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::DeleteTagValue(
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagValue(request);
}

StatusOr<google::longrunning::Operation> TagValuesClient::DeleteTagValue(
    NoAwaitTag,
    google::cloud::resourcemanager::v3::DeleteTagValueRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagValue(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::resourcemanager::v3::TagValue>>
TagValuesClient::DeleteTagValue(google::longrunning::Operation const& operation,
                                Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteTagValue(operation);
}

StatusOr<google::iam::v1::Policy> TagValuesClient::GetIamPolicy(
    std::string const& resource, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest request;
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> TagValuesClient::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> TagValuesClient::SetIamPolicy(
    std::string const& resource, google::iam::v1::Policy const& policy,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::SetIamPolicyRequest request;
  request.set_resource(resource);
  *request.mutable_policy() = policy;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::Policy> TagValuesClient::SetIamPolicy(
    std::string const& resource, IamUpdater const& updater, Options opts) {
  internal::CheckExpectedOptions<TagValuesBackoffPolicyOption>(opts, __func__);
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::GetIamPolicyRequest get_request;
  get_request.set_resource(resource);
  google::iam::v1::SetIamPolicyRequest set_request;
  set_request.set_resource(resource);
  auto backoff_policy =
      internal::CurrentOptions().get<TagValuesBackoffPolicyOption>();
  if (backoff_policy != nullptr) {
    backoff_policy = backoff_policy->clone();
  }
  for (;;) {
    auto recent = connection_->GetIamPolicy(get_request);
    if (!recent) {
      return recent.status();
    }
    auto policy = updater(*std::move(recent));
    if (!policy) {
      return internal::CancelledError(
          "updater did not yield a policy",
          GCP_ERROR_INFO().WithMetadata("gl-cpp.error.origin", "client"));
    }
    *set_request.mutable_policy() = *std::move(policy);
    auto result = connection_->SetIamPolicy(set_request);
    if (result || result.status().code() != StatusCode::kAborted ||
        backoff_policy == nullptr) {
      return result;
    }
    std::this_thread::sleep_for(backoff_policy->OnCompletion());
  }
}

StatusOr<google::iam::v1::Policy> TagValuesClient::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TagValuesClient::TestIamPermissions(std::string const& resource,
                                    std::vector<std::string> const& permissions,
                                    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::iam::v1::TestIamPermissionsRequest request;
  request.set_resource(resource);
  *request.mutable_permissions() = {permissions.begin(), permissions.end()};
  return connection_->TestIamPermissions(request);
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
TagValuesClient::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const& request, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace resourcemanager_v3
}  // namespace cloud
}  // namespace google
