/*
 * Decompiled with CFR 0.152.
 */
package jflex.anttask;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jflex.core.OptionUtils;
import jflex.exceptions.GeneratorException;
import jflex.generator.LexGenerator;
import jflex.option.Options;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JFlexTask
extends Task {
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("package\\s+(\\S+)\\s*;");
    private static final Pattern CLASS_PATTERN = Pattern.compile("%class\\s+(\\S+)");
    private File inputFile;
    private String className = null;
    private String packageName = null;
    private File destinationDir;
    private File outputDir = null;

    public JFlexTask() {
        OptionUtils.setDefaultOptions();
        this.setVerbose(false);
        this.setUnusedWarning(true);
        Options.progress = false;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void execute() {
        try {
            if (this.inputFile == null) {
                throw new BuildException("Input file needed. Use <jflex file=\"your_scanner.flex\"/>");
            }
            if (!this.inputFile.canRead()) {
                throw new BuildException("Cannot read input file " + this.inputFile);
            }
            try {
                this.findPackageAndClass();
                this.normalizeOutdir();
                File destFile = new File(this.outputDir, this.className + ".java");
                if (this.inputFile.lastModified() > destFile.lastModified()) {
                    new LexGenerator(this.inputFile).generate();
                    if (!Options.verbose) {
                        System.out.println("Generated: " + destFile.getName());
                    }
                }
            }
            catch (IOException e1) {
                throw new BuildException((Throwable)e1);
            }
        }
        catch (GeneratorException e) {
            throw new BuildException("JFlex generation failed", (Throwable)e);
        }
    }

    public void findPackageAndClass() throws IOException {
        this.packageName = null;
        this.className = null;
        BufferedReader r = Files.newBufferedReader(this.inputFile.toPath(), StandardCharsets.UTF_8);
        try (LineNumberReader reader = new LineNumberReader(r);){
            String line;
            while ((this.className == null || this.packageName == null) && (line = reader.readLine()) != null) {
                Matcher matcher;
                if (this.packageName == null && (matcher = PACKAGE_PATTERN.matcher(line)).find()) {
                    this.packageName = matcher.group(1);
                }
                if (this.className != null || !(matcher = CLASS_PATTERN.matcher(line)).find()) continue;
                this.className = matcher.group(1);
            }
            if (this.className == null) {
                this.className = "Yylex";
            }
        }
    }

    public void normalizeOutdir() {
        File destDir;
        if (this.outputDir != null) {
            return;
        }
        if (this.destinationDir != null) {
            if (this.packageName == null) {
                destDir = this.destinationDir;
            } else {
                String path = this.packageName.replace('.', File.separatorChar);
                destDir = new File(this.destinationDir, path);
            }
        } else {
            destDir = new File(this.inputFile.getParent());
        }
        this.setOutdir(destDir);
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDestdir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    public void setOutdir(File outDir) {
        this.outputDir = outDir;
        OptionUtils.setDir(this.outputDir);
    }

    public void setFile(File file) {
        this.inputFile = file;
    }

    public void setGenerateDot(boolean genDot) {
        this.setDot(genDot);
    }

    public void setTimeStatistics(boolean displayTime) {
        Options.time = displayTime;
    }

    public void setTime(boolean displayTime) {
        this.setTimeStatistics(displayTime);
    }

    public final void setVerbose(boolean verbose) {
        Options.verbose = verbose;
        OptionUtils.set_unused_warning(verbose);
    }

    public final void setUnusedWarning(boolean warn) {
        OptionUtils.set_unused_warning(warn);
    }

    public void setSkeleton(File skeleton) {
        OptionUtils.setSkeleton(skeleton);
    }

    public void setSkel(File skeleton) {
        this.setSkeleton(skeleton);
    }

    public void setSkipMinimization(boolean skipMin) {
        this.setNomin(skipMin);
    }

    public void setNomin(boolean b) {
        Options.no_minimize = b;
    }

    public void setNobak(boolean b) {
        Options.no_backup = b;
    }

    public void setPack(boolean b) {
    }

    public void setDot(boolean b) {
        Options.dot = b;
    }

    public void setDump(boolean b) {
        Options.dump = b;
    }

    public void setJLex(boolean b) {
        Options.jlex = b;
    }

    public void setLegacyDot(boolean b) {
        Options.legacy_dot = b;
    }

    public void setEncoding(String encodingName) {
        OptionUtils.setEncoding(encodingName);
    }
}

